/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.EqualsAndHashCode;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class EqualsAndHashCodeASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = EqualsAndHashCode.class;
    static final ClassNode MY_TYPE = new ClassNode(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode HASHUTIL_TYPE = new ClassNode(HashCodeHelper.class);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);
    private static final ClassNode OBJECT_TYPE = new ClassNode(Object.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            boolean callSuper = this.memberHasValue(anno, "callSuper", true);
            if (callSuper && cNode.getSuperClass().getName().equals("java.lang.Object")) {
                this.addError("Error during " + MY_TYPE_NAME + " processing: callSuper=true but '" + cNode.getName() + "' has no super class.", anno);
            }
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            List<String> excludes = this.tokenize((String)this.getMemberValue(anno, "excludes"));
            EqualsAndHashCodeASTTransformation.createHashCode(cNode, false, includeFields, callSuper, excludes);
            EqualsAndHashCodeASTTransformation.createEquals(cNode, includeFields, callSuper, excludes);
        }
    }

    public static void createHashCode(ClassNode cNode, boolean cacheResult, boolean includeFields, boolean callSuper, List<String> excludes) {
        boolean hasExistingHashCode = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "hashCode", 0);
        if (hasExistingHashCode && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_hashCode", 0)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        List<FieldNode> list = AbstractASTTransformUtil.getInstancePropertyFields(cNode);
        if (includeFields) {
            list.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
        }
        if (cacheResult) {
            FieldNode hashField = cNode.addField("$hash$code", 4098, ClassHelper.int_TYPE, null);
            VariableExpression hash = new VariableExpression(hashField);
            body.addStatement(new IfStatement(AbstractASTTransformUtil.isZeroExpr(hash), EqualsAndHashCodeASTTransformation.calculateHashStatements(hash, list, callSuper), new EmptyStatement()));
            body.addStatement(new ReturnStatement(hash));
        } else {
            body.addStatement(EqualsAndHashCodeASTTransformation.calculateHashStatements(null, list, callSuper));
        }
        cNode.addMethod(new MethodNode(hasExistingHashCode ? "_hashCode" : "hashCode", hasExistingHashCode ? 2 : 1, ClassHelper.int_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body));
    }

    private static Statement calculateHashStatements(Expression hash, List<FieldNode> list, boolean callSuper) {
        BlockStatement body = new BlockStatement();
        VariableExpression result = new VariableExpression("_result");
        StaticMethodCallExpression init = new StaticMethodCallExpression(HASHUTIL_TYPE, "initHash", MethodCallExpression.NO_ARGUMENTS);
        body.addStatement(new ExpressionStatement(new DeclarationExpression((Expression)result, ASSIGN, (Expression)init)));
        for (FieldNode fNode : list) {
            if (fNode.getName().contains("$")) continue;
            VariableExpression fieldExpr = new VariableExpression(fNode);
            TupleExpression args = new TupleExpression(result, fieldExpr);
            StaticMethodCallExpression current = new StaticMethodCallExpression(HASHUTIL_TYPE, "updateHash", args);
            body.addStatement(AbstractASTTransformUtil.assignStatement(result, current));
        }
        if (callSuper) {
            TupleExpression args = new TupleExpression(result, new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "hashCode", MethodCallExpression.NO_ARGUMENTS));
            StaticMethodCallExpression current = new StaticMethodCallExpression(HASHUTIL_TYPE, "updateHash", args);
            body.addStatement(AbstractASTTransformUtil.assignStatement(result, current));
        }
        if (hash != null) {
            body.addStatement(AbstractASTTransformUtil.assignStatement(hash, result));
        } else {
            body.addStatement(new ReturnStatement(result));
        }
        return body;
    }

    public static void createEquals(ClassNode cNode, boolean includeFields, boolean callSuper, List<String> excludes) {
        boolean hasExistingEquals = AbstractASTTransformUtil.hasDeclaredMethod(cNode, "equals", 1);
        if (hasExistingEquals && AbstractASTTransformUtil.hasDeclaredMethod(cNode, "_equals", 1)) {
            return;
        }
        BlockStatement body = new BlockStatement();
        VariableExpression other = new VariableExpression("other");
        body.addStatement(AbstractASTTransformUtil.returnFalseIfNull(other));
        body.addStatement(AbstractASTTransformUtil.returnFalseIfWrongType(cNode, other));
        body.addStatement(AbstractASTTransformUtil.returnTrueIfIdentical(VariableExpression.THIS_EXPRESSION, other));
        body.addStatement(new ExpressionStatement(new BinaryExpression(other, ASSIGN, new CastExpression(cNode, other))));
        List<FieldNode> list = AbstractASTTransformUtil.getInstancePropertyFields(cNode);
        if (includeFields) {
            list.addAll(AbstractASTTransformUtil.getInstanceNonPropertyFields(cNode));
        }
        for (FieldNode fNode : list) {
            if (excludes.contains(fNode.getName()) || fNode.getName().contains("$")) continue;
            body.addStatement(AbstractASTTransformUtil.returnFalseIfPropertyNotEqual(fNode, other));
        }
        if (callSuper) {
            IfStatement result = new IfStatement(AbstractASTTransformUtil.isTrueExpr(new MethodCallExpression((Expression)VariableExpression.SUPER_EXPRESSION, "equals", (Expression)other)), new EmptyStatement(), new ReturnStatement(ConstantExpression.FALSE));
            body.addStatement(result);
        }
        body.addStatement(new ReturnStatement(ConstantExpression.TRUE));
        Parameter[] params = new Parameter[]{new Parameter(OBJECT_TYPE, "other")};
        cNode.addMethod(new MethodNode(hasExistingEquals ? "_equals" : "equals", hasExistingEquals ? 2 : 1, ClassHelper.boolean_TYPE, params, ClassNode.EMPTY_ARRAY, body));
    }
}

