/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.BytecodeInstruction;
import org.codehaus.groovy.classgen.BytecodeSequence;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;

public class InnerClassVisitor
extends ClassCodeVisitorSupport
implements Opcodes {
    private final SourceUnit sourceUnit;
    private ClassNode classNode;
    private static final int publicSynthetic = 4097;
    private FieldNode thisField = null;

    public InnerClassVisitor(CompilationUnit cu, SourceUnit su) {
        this.sourceUnit = su;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visitClass(ClassNode node) {
        this.classNode = node;
        this.thisField = null;
        InnerClassNode innerClass = null;
        if (!node.isEnum() && !node.isInterface() && node instanceof InnerClassNode) {
            innerClass = (InnerClassNode)node;
            if (!this.isStatic(innerClass) && innerClass.getVariableScope() == null) {
                this.thisField = innerClass.addField("this$0", 4097, node.getOuterClass(), null);
            }
            if (innerClass.getVariableScope() == null && innerClass.getDeclaredConstructors().isEmpty()) {
                innerClass.addConstructor(4097, new Parameter[0], null, null);
            }
        }
        super.visitClass(node);
        if (node.isEnum() || node.isInterface()) {
            return;
        }
        this.addDispatcherMethods();
        if (innerClass == null) {
            return;
        }
        if (node.getSuperClass().isInterface()) {
            node.addInterface(node.getUnresolvedSuperClass());
            node.setUnresolvedSuperClass(ClassHelper.OBJECT_TYPE);
        }
        this.addDefaultMethods(innerClass);
    }

    private boolean isStatic(InnerClassNode node) {
        VariableScope scope = node.getVariableScope();
        if (scope != null) {
            return scope.isInStaticContext();
        }
        return (node.getModifiers() & 8) != 0;
    }

    private void addDefaultMethods(InnerClassNode node) {
        boolean isStatic = this.isStatic(node);
        final String classInternalName = BytecodeHelper.getClassInternalName(node);
        final String outerClassInternalName = this.getInternalName(node.getOuterClass(), isStatic);
        final String outerClassDescriptor = this.getTypeDescriptor(node.getOuterClass(), isStatic);
        final int objectDistance = this.getObjectDistance(node.getOuterClass());
        Parameter[] parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "args")};
        MethodNode method = node.addSyntheticMethod("methodMissing", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        BlockStatement block = new BlockStatement();
        if (isStatic) {
            this.setMethodDispatcherCode(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$invoke$" + objectDistance, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
                    mv.visitInsn(176);
                }
            }));
        }
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "val")};
        method = node.addSyntheticMethod("propertyMissing", 1, ClassHelper.VOID_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        if (isStatic) {
            this.setPropertySetDispatcher(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$set$" + objectDistance, "(Ljava/lang/String;Ljava/lang/Object;)V");
                    mv.visitInsn(177);
                }
            }));
        }
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")};
        method = node.addSyntheticMethod("propertyMissing", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        if (isStatic) {
            this.setPropertyGetterDispatcher(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$get$" + objectDistance, "(Ljava/lang/String;)Ljava/lang/Object;");
                    mv.visitInsn(176);
                }
            }));
        }
        method.setCode(block);
    }

    private String getTypeDescriptor(ClassNode node, boolean isStatic) {
        return BytecodeHelper.getTypeDescription(this.getClassNode(node, isStatic));
    }

    private String getInternalName(ClassNode node, boolean isStatic) {
        return BytecodeHelper.getClassInternalName(this.getClassNode(node, isStatic));
    }

    public void visitConstructor(ConstructorNode node) {
        this.addThisReference(node);
        super.visitConstructor(node);
    }

    private void addThisReference(ConstructorNode node) {
        Parameter thisPara;
        if (this.classNode.isEnum() || this.classNode.isInterface()) {
            return;
        }
        if ((this.classNode.getModifiers() & 8) != 0) {
            return;
        }
        Statement code = node.getCode();
        if (!(this.classNode instanceof InnerClassNode)) {
            return;
        }
        InnerClassNode innerClass = (InnerClassNode)this.classNode;
        if (innerClass.getVariableScope() != null) {
            return;
        }
        if ((innerClass.getModifiers() & 8) != 0) {
            return;
        }
        Parameter[] params = node.getParameters();
        Parameter[] newParams = new Parameter[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = thisPara = new Parameter(this.classNode.getOuterClass(), this.getUniqueName(params, node));
        node.setParameters(newParams);
        Statement firstStatement = node.getFirstStatement();
        BlockStatement block = null;
        if (code == null) {
            block = new BlockStatement();
        } else if (!(code instanceof BlockStatement)) {
            block = new BlockStatement();
            block.addStatement(code);
        } else {
            block = (BlockStatement)code;
        }
        BlockStatement newCode = new BlockStatement();
        InnerClassVisitor.addFieldInit(thisPara, this.thisField, newCode);
        ConstructorCallExpression cce = this.getFirstIfSpecialConstructorCall(block);
        if (cce == null) {
            newCode.addStatement(block);
        } else if (cce.isThisCall()) {
            TupleExpression args = (TupleExpression)cce.getArguments();
            List<Expression> expressions = args.getExpressions();
            VariableExpression ve = new VariableExpression(thisPara.getName());
            ve.setAccessedVariable(thisPara);
            expressions.add(0, ve);
            newCode = block;
        } else {
            block.getStatements().remove(0);
            newCode.getStatements().add(0, firstStatement);
            newCode.addStatement(block);
        }
        node.setCode(newCode);
    }

    private String getUniqueName(Parameter[] params, ConstructorNode node) {
        String namePrefix = "$p";
        block0: for (int i = 0; i < 100; ++i) {
            namePrefix = namePrefix + "$";
            for (Parameter p : params) {
                if (p.getName().equals(namePrefix)) continue block0;
            }
            return namePrefix;
        }
        this.addError("unable to find a unique prefix name for synthetic this reference", node);
        return namePrefix;
    }

    private ConstructorCallExpression getFirstIfSpecialConstructorCall(Statement code) {
        if (code == null || !(code instanceof ExpressionStatement)) {
            return null;
        }
        Expression expression = ((ExpressionStatement)code).getExpression();
        if (!(expression instanceof ConstructorCallExpression)) {
            return null;
        }
        ConstructorCallExpression cce = (ConstructorCallExpression)expression;
        if (cce.isSpecialCall()) {
            return cce;
        }
        return null;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        if (!call.isUsingAnnonymousInnerClass()) {
            return;
        }
        InnerClassNode innerClass = (InnerClassNode)call.getType();
        if (!innerClass.getDeclaredConstructors().isEmpty()) {
            return;
        }
        if ((innerClass.getModifiers() & 8) != 0) {
            return;
        }
        VariableScope scope = innerClass.getVariableScope();
        if (scope == null) {
            return;
        }
        boolean isStatic = scope.isInStaticContext();
        List<Expression> expressions = ((TupleExpression)call.getArguments()).getExpressions();
        BlockStatement block = new BlockStatement();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(expressions.size() + 1 + scope.getReferencedLocalVariablesCount());
        ArrayList<Expression> superCallArguments = new ArrayList<Expression>(expressions.size());
        int pCount = 0;
        for (Expression expr : expressions) {
            Parameter param = new Parameter(ClassHelper.OBJECT_TYPE, "p" + ++pCount);
            parameters.add(param);
            superCallArguments.add(new VariableExpression(param));
        }
        ConstructorCallExpression cce = new ConstructorCallExpression(ClassNode.SUPER, new TupleExpression(superCallArguments));
        block.addStatement(new ExpressionStatement(cce));
        expressions.add(VariableExpression.THIS_EXPRESSION);
        ClassNode outerClassType = this.getClassNode(innerClass.getOuterClass(), isStatic);
        Parameter thisParameter = new Parameter(outerClassType, "p" + ++pCount);
        parameters.add(thisParameter);
        this.thisField = innerClass.addField("this$0", 4097, outerClassType, null);
        InnerClassVisitor.addFieldInit(thisParameter, this.thisField, block);
        Iterator<Variable> it = scope.getReferencedLocalVariablesIterator();
        while (it.hasNext()) {
            ++pCount;
            Variable var = it.next();
            VariableExpression ve = new VariableExpression(var);
            ve.setClosureSharedVariable(true);
            ve.setUseReferenceDirectly(true);
            expressions.add(ve);
            Parameter p = new Parameter(ClassHelper.REFERENCE_TYPE, "p" + pCount);
            parameters.add(p);
            VariableExpression initial = new VariableExpression(p);
            initial.setUseReferenceDirectly(true);
            FieldNode pField = innerClass.addFieldFirst(ve.getName(), 4097, ClassHelper.REFERENCE_TYPE, initial);
            int finalPCount = pCount;
            pField.setHolder(true);
        }
        innerClass.addConstructor(1, parameters.toArray(new Parameter[0]), ClassNode.EMPTY_ARRAY, block);
    }

    private ClassNode getClassNode(ClassNode node, boolean isStatic) {
        if (isStatic) {
            node = ClassHelper.CLASS_Type;
        }
        return node;
    }

    private void addDispatcherMethods() {
        int objectDistance = this.getObjectDistance(this.classNode);
        Parameter[] parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "args")};
        MethodNode method = this.classNode.addSyntheticMethod("this$dist$invoke$" + objectDistance, 4097, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        BlockStatement block = new BlockStatement();
        this.setMethodDispatcherCode(block, VariableExpression.THIS_EXPRESSION, parameters);
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "value")};
        method = this.classNode.addSyntheticMethod("this$dist$set$" + objectDistance, 4161, ClassHelper.VOID_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        this.setPropertySetDispatcher(block, VariableExpression.THIS_EXPRESSION, parameters);
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")};
        method = this.classNode.addSyntheticMethod("this$dist$get$" + objectDistance, 4161, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        this.setPropertyGetterDispatcher(block, VariableExpression.THIS_EXPRESSION, parameters);
        method.setCode(block);
    }

    private void setPropertyGetterDispatcher(BlockStatement block, Expression thiz, Parameter[] parameters) {
        ArrayList<ConstantExpression> gStringStrings = new ArrayList<ConstantExpression>();
        gStringStrings.add(new ConstantExpression(""));
        gStringStrings.add(new ConstantExpression(""));
        ArrayList<Expression> gStringValues = new ArrayList<Expression>();
        gStringValues.add(new VariableExpression(parameters[0]));
        block.addStatement(new ReturnStatement(new AttributeExpression(thiz, new GStringExpression("$name", gStringStrings, gStringValues))));
    }

    private void setPropertySetDispatcher(BlockStatement block, Expression thiz, Parameter[] parameters) {
        ArrayList<ConstantExpression> gStringStrings = new ArrayList<ConstantExpression>();
        gStringStrings.add(new ConstantExpression(""));
        gStringStrings.add(new ConstantExpression(""));
        ArrayList<Expression> gStringValues = new ArrayList<Expression>();
        gStringValues.add(new VariableExpression(parameters[0]));
        block.addStatement(new ExpressionStatement(new BinaryExpression(new AttributeExpression(thiz, new GStringExpression("$name", gStringStrings, gStringValues)), Token.newSymbol(100, -1, -1), new VariableExpression(parameters[1]))));
    }

    private void setMethodDispatcherCode(BlockStatement block, Expression thiz, Parameter[] parameters) {
        ArrayList<ConstantExpression> gStringStrings = new ArrayList<ConstantExpression>();
        gStringStrings.add(new ConstantExpression(""));
        gStringStrings.add(new ConstantExpression(""));
        ArrayList<Expression> gStringValues = new ArrayList<Expression>();
        gStringValues.add(new VariableExpression(parameters[0]));
        block.addStatement(new ReturnStatement(new MethodCallExpression(thiz, new GStringExpression("$name", gStringStrings, gStringValues), (Expression)new ArgumentListExpression(new SpreadExpression(new VariableExpression(parameters[1]))))));
    }

    private static void addFieldInit(Parameter p, FieldNode fn, BlockStatement block) {
        VariableExpression ve = new VariableExpression(p);
        FieldExpression fe = new FieldExpression(fn);
        block.addStatement(new ExpressionStatement(new BinaryExpression(fe, Token.newSymbol(100, -1, -1), ve)));
    }

    private int getObjectDistance(ClassNode node) {
        int count = 1;
        while (node != null && node != ClassHelper.OBJECT_TYPE) {
            ++count;
            node = node.getSuperClass();
        }
        return count;
    }
}

