/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.sql.CallResultSet;
import groovy.sql.DataSet;
import groovy.sql.ExpandedVariable;
import groovy.sql.GroovyResultSet;
import groovy.sql.GroovyResultSetProxy;
import groovy.sql.GroovyRowResult;
import groovy.sql.InOutParameter;
import groovy.sql.InParameter;
import groovy.sql.OutParameter;
import groovy.sql.ResultSetOutParameter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.codehaus.groovy.runtime.SqlGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sql {
    protected static Logger log = Logger.getLogger(Sql.class.getName());
    private static final List<Object> EMPTY_LIST = Collections.emptyList();
    private DataSource dataSource;
    private Connection useConnection;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = -1;
    private int updateCount = 0;
    private Closure configureStatement;
    private boolean cacheConnection;
    private boolean cacheStatements;
    private final Map<String, Statement> statementCache = new HashMap<String, Statement>();
    public static final OutParameter ARRAY = new OutParameter(){

        public int getType() {
            return 2003;
        }
    };
    public static final OutParameter BIGINT = new OutParameter(){

        public int getType() {
            return -5;
        }
    };
    public static final OutParameter BINARY = new OutParameter(){

        public int getType() {
            return -2;
        }
    };
    public static final OutParameter BIT = new OutParameter(){

        public int getType() {
            return -7;
        }
    };
    public static final OutParameter BLOB = new OutParameter(){

        public int getType() {
            return 2004;
        }
    };
    public static final OutParameter BOOLEAN = new OutParameter(){

        public int getType() {
            return 16;
        }
    };
    public static final OutParameter CHAR = new OutParameter(){

        public int getType() {
            return 1;
        }
    };
    public static final OutParameter CLOB = new OutParameter(){

        public int getType() {
            return 2005;
        }
    };
    public static final OutParameter DATALINK = new OutParameter(){

        public int getType() {
            return 70;
        }
    };
    public static final OutParameter DATE = new OutParameter(){

        public int getType() {
            return 91;
        }
    };
    public static final OutParameter DECIMAL = new OutParameter(){

        public int getType() {
            return 3;
        }
    };
    public static final OutParameter DISTINCT = new OutParameter(){

        public int getType() {
            return 2001;
        }
    };
    public static final OutParameter DOUBLE = new OutParameter(){

        public int getType() {
            return 8;
        }
    };
    public static final OutParameter FLOAT = new OutParameter(){

        public int getType() {
            return 6;
        }
    };
    public static final OutParameter INTEGER = new OutParameter(){

        public int getType() {
            return 4;
        }
    };
    public static final OutParameter JAVA_OBJECT = new OutParameter(){

        public int getType() {
            return 2000;
        }
    };
    public static final OutParameter LONGVARBINARY = new OutParameter(){

        public int getType() {
            return -4;
        }
    };
    public static final OutParameter LONGVARCHAR = new OutParameter(){

        public int getType() {
            return -1;
        }
    };
    public static final OutParameter NULL = new OutParameter(){

        public int getType() {
            return 0;
        }
    };
    public static final OutParameter NUMERIC = new OutParameter(){

        public int getType() {
            return 2;
        }
    };
    public static final OutParameter OTHER = new OutParameter(){

        public int getType() {
            return 1111;
        }
    };
    public static final OutParameter REAL = new OutParameter(){

        public int getType() {
            return 7;
        }
    };
    public static final OutParameter REF = new OutParameter(){

        public int getType() {
            return 2006;
        }
    };
    public static final OutParameter SMALLINT = new OutParameter(){

        public int getType() {
            return 5;
        }
    };
    public static final OutParameter STRUCT = new OutParameter(){

        public int getType() {
            return 2002;
        }
    };
    public static final OutParameter TIME = new OutParameter(){

        public int getType() {
            return 92;
        }
    };
    public static final OutParameter TIMESTAMP = new OutParameter(){

        public int getType() {
            return 93;
        }
    };
    public static final OutParameter TINYINT = new OutParameter(){

        public int getType() {
            return -6;
        }
    };
    public static final OutParameter VARBINARY = new OutParameter(){

        public int getType() {
            return -3;
        }
    };
    public static final OutParameter VARCHAR = new OutParameter(){

        public int getType() {
            return 12;
        }
    };

    public static Sql newInstance(String url) throws SQLException {
        Connection connection = DriverManager.getConnection(url);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties) throws SQLException {
        Connection connection = DriverManager.getConnection(url, properties);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, Properties properties, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, properties);
    }

    public static Sql newInstance(String url, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(url, user, password);
        return new Sql(connection);
    }

    public static Sql newInstance(String url, String user, String password, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url, user, password);
    }

    public static Sql newInstance(String url, String driverClassName) throws SQLException, ClassNotFoundException {
        Sql.loadDriver(driverClassName);
        return Sql.newInstance(url);
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public static void loadDriver(String driverClassName) throws ClassNotFoundException {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
            }
            catch (ClassNotFoundException e2) {
                try {
                    Sql.class.getClassLoader().loadClass(driverClassName);
                }
                catch (ClassNotFoundException e3) {
                    throw e;
                }
            }
        }
    }

    public static InParameter ARRAY(Object value) {
        return Sql.in(2003, value);
    }

    public static InParameter BIGINT(Object value) {
        return Sql.in(-5, value);
    }

    public static InParameter BINARY(Object value) {
        return Sql.in(-2, value);
    }

    public static InParameter BIT(Object value) {
        return Sql.in(-7, value);
    }

    public static InParameter BLOB(Object value) {
        return Sql.in(2004, value);
    }

    public static InParameter BOOLEAN(Object value) {
        return Sql.in(16, value);
    }

    public static InParameter CHAR(Object value) {
        return Sql.in(1, value);
    }

    public static InParameter CLOB(Object value) {
        return Sql.in(2005, value);
    }

    public static InParameter DATALINK(Object value) {
        return Sql.in(70, value);
    }

    public static InParameter DATE(Object value) {
        return Sql.in(91, value);
    }

    public static InParameter DECIMAL(Object value) {
        return Sql.in(3, value);
    }

    public static InParameter DISTINCT(Object value) {
        return Sql.in(2001, value);
    }

    public static InParameter DOUBLE(Object value) {
        return Sql.in(8, value);
    }

    public static InParameter FLOAT(Object value) {
        return Sql.in(6, value);
    }

    public static InParameter INTEGER(Object value) {
        return Sql.in(4, value);
    }

    public static InParameter JAVA_OBJECT(Object value) {
        return Sql.in(2000, value);
    }

    public static InParameter LONGVARBINARY(Object value) {
        return Sql.in(-4, value);
    }

    public static InParameter LONGVARCHAR(Object value) {
        return Sql.in(-1, value);
    }

    public static InParameter NULL(Object value) {
        return Sql.in(0, value);
    }

    public static InParameter NUMERIC(Object value) {
        return Sql.in(2, value);
    }

    public static InParameter OTHER(Object value) {
        return Sql.in(1111, value);
    }

    public static InParameter REAL(Object value) {
        return Sql.in(7, value);
    }

    public static InParameter REF(Object value) {
        return Sql.in(2006, value);
    }

    public static InParameter SMALLINT(Object value) {
        return Sql.in(5, value);
    }

    public static InParameter STRUCT(Object value) {
        return Sql.in(2002, value);
    }

    public static InParameter TIME(Object value) {
        return Sql.in(92, value);
    }

    public static InParameter TIMESTAMP(Object value) {
        return Sql.in(93, value);
    }

    public static InParameter TINYINT(Object value) {
        return Sql.in(-6, value);
    }

    public static InParameter VARBINARY(Object value) {
        return Sql.in(-3, value);
    }

    public static InParameter VARCHAR(Object value) {
        return Sql.in(12, value);
    }

    public static InParameter in(final int type, final Object value) {
        return new InParameter(){

            public int getType() {
                return type;
            }

            public Object getValue() {
                return value;
            }
        };
    }

    public static OutParameter out(final int type) {
        return new OutParameter(){

            public int getType() {
                return type;
            }
        };
    }

    public static InOutParameter inout(final InParameter in) {
        return new InOutParameter(){

            public int getType() {
                return in.getType();
            }

            public Object getValue() {
                return in.getValue();
            }
        };
    }

    public static ResultSetOutParameter resultSet(final int type) {
        return new ResultSetOutParameter(){

            public int getType() {
                return type;
            }
        };
    }

    public static ExpandedVariable expand(final Object object) {
        return new ExpandedVariable(){

            public Object getObject() {
                return object;
            }
        };
    }

    public Sql(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Sql(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("Must specify a non-null Connection");
        }
        this.useConnection = connection;
    }

    public Sql(Sql parent) {
        this.dataSource = parent.dataSource;
        this.useConnection = parent.useConnection;
    }

    public DataSet dataSet(String table) {
        return new DataSet(this, table);
    }

    public DataSet dataSet(Class<?> type) {
        return new DataSet(this, type);
    }

    public void query(String sql, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = this.getStatement(connection, sql);
        ResultSet results = null;
        try {
            log.fine(sql);
            results = statement.executeQuery(sql);
            closure.call(results);
        }
        catch (SQLException e) {
            log.log(Level.FINE, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement, results);
        }
    }

    public void query(String sql, List<Object> params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            log.fine(sql);
            statement = this.getPreparedStatement(connection, sql, params);
            results = statement.executeQuery();
            closure.call(results);
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void query(GString gstring, Closure closure) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.query(sql, params, closure);
    }

    public void eachRow(String sql, Closure closure) throws SQLException {
        this.eachRow(sql, (Closure)null, closure);
    }

    public void eachRow(String sql, Closure metaClosure, Closure rowClosure) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = this.getStatement(connection, sql);
        ResultSet results = null;
        try {
            log.fine(sql);
            results = statement.executeQuery(sql);
            if (metaClosure != null) {
                metaClosure.call(results.getMetaData());
            }
            GroovyResultSet groovyRS = new GroovyResultSetProxy(results).getImpl();
            while (groovyRS.next()) {
                rowClosure.call(groovyRS);
            }
        }
        catch (SQLException e) {
            log.log(Level.FINE, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement, results);
        }
    }

    public void eachRow(String sql, List<Object> params, Closure closure) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        ResultSet results = null;
        try {
            log.fine(sql);
            statement = this.getPreparedStatement(connection, sql, params);
            results = statement.executeQuery();
            GroovyResultSet groovyRS = new GroovyResultSetProxy(results).getImpl();
            while (groovyRS.next()) {
                closure.call(groovyRS);
            }
            this.closeResources(connection, statement, results);
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement, results);
                throw throwable;
            }
        }
    }

    public void eachRow(GString gstring, Closure closure) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.eachRow(sql, params, closure);
    }

    public List<GroovyRowResult> rows(String sql) throws SQLException {
        return this.rows(sql, (Closure)null);
    }

    public List<GroovyRowResult> rows(GString gstring) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.rows(sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroovyRowResult> rows(String sql, Closure metaClosure) throws SQLException {
        AbstractQueryCommand command = this.createQueryCommand(sql);
        ResultSet rs = null;
        try {
            rs = command.execute();
            if (metaClosure != null) {
                metaClosure.call(rs.getMetaData());
            }
            List<GroovyRowResult> result = this.asList(sql, rs);
            rs = null;
            List<GroovyRowResult> list = result;
            return list;
        }
        finally {
            command.closeResources(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroovyRowResult> rows(String sql, List<Object> params) throws SQLException {
        AbstractQueryCommand command = this.createPreparedQueryCommand(sql, params);
        try {
            List<GroovyRowResult> list = this.asList(sql, command.execute());
            return list;
        }
        finally {
            command.closeResources();
        }
    }

    public Object firstRow(String sql) throws SQLException {
        List<GroovyRowResult> rows = this.rows(sql);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    public Object firstRow(GString gstring) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.firstRow(sql, params);
    }

    public Object firstRow(String sql, List<Object> params) throws SQLException {
        List<GroovyRowResult> rows = this.rows(sql, params);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    public boolean execute(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            log.fine(sql);
            statement = this.getStatement(connection, sql);
            boolean isResultSet = statement.execute(sql);
            this.updateCount = statement.getUpdateCount();
            boolean bl = isResultSet;
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(String sql, List<Object> params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            log.fine(sql);
            statement = this.getPreparedStatement(connection, sql, params);
            boolean isResultSet = statement.execute();
            this.updateCount = statement.getUpdateCount();
            boolean bl = isResultSet;
            this.closeResources(connection, statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public boolean execute(GString gstring) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.execute(sql, params);
    }

    public List<List<Object>> executeInsert(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            log.fine(sql);
            statement = this.getStatement(connection, sql);
            this.updateCount = statement.executeUpdate(sql, 1);
            ResultSet keys = statement.getGeneratedKeys();
            List<List<Object>> list = this.calculateKeys(keys);
            this.closeResources(connection, statement);
            return list;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public List<List<Object>> executeInsert(String sql, List<Object> params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            log.fine(sql);
            statement = this.getPreparedStatement(connection, sql, params, 1);
            this.updateCount = statement.executeUpdate();
            ResultSet keys = statement.getGeneratedKeys();
            List<List<Object>> list = this.calculateKeys(keys);
            this.closeResources(connection, statement);
            return list;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public List<List<Object>> executeInsert(GString gstring) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.executeInsert(sql, params);
    }

    public int executeUpdate(String sql) throws SQLException {
        Connection connection = this.createConnection();
        Statement statement = null;
        try {
            log.fine(sql);
            statement = this.getStatement(connection, sql);
            int n = this.updateCount = statement.executeUpdate(sql);
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(String sql, List<Object> params) throws SQLException {
        Connection connection = this.createConnection();
        PreparedStatement statement = null;
        try {
            log.fine(sql);
            statement = this.getPreparedStatement(connection, sql, params);
            int n = this.updateCount = statement.executeUpdate();
            this.closeResources(connection, statement);
            return n;
        }
        catch (SQLException e) {
            try {
                log.log(Level.FINE, "Failed to execute: " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResources(connection, statement);
                throw throwable;
            }
        }
    }

    public int executeUpdate(GString gstring) throws SQLException {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.executeUpdate(sql, params);
    }

    public int call(String sql) throws Exception {
        return this.call(sql, EMPTY_LIST);
    }

    public int call(GString gstring) throws Exception {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        return this.call(sql, params);
    }

    public int call(String sql, List<Object> params) throws Exception {
        Connection connection = this.createConnection();
        CallableStatement statement = connection.prepareCall(sql);
        try {
            log.fine(sql);
            this.setParameters(params, statement);
            this.configure(statement);
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            log.log(Level.FINE, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
        }
    }

    public void call(String sql, List<Object> params, Closure closure) throws Exception {
        Connection connection = this.createConnection();
        CallableStatement statement = connection.prepareCall(sql);
        ArrayList<GroovyResultSet> resultSetResources = new ArrayList<GroovyResultSet>();
        try {
            log.fine(sql);
            this.setParameters(params, statement);
            statement.execute();
            ArrayList<Object> results = new ArrayList<Object>();
            int indx = 0;
            int inouts = 0;
            for (Object value : params) {
                if (value instanceof OutParameter) {
                    if (value instanceof ResultSetOutParameter) {
                        GroovyResultSet resultSet = CallResultSet.getImpl(statement, indx);
                        resultSetResources.add(resultSet);
                        results.add(resultSet);
                    } else {
                        Object o = statement.getObject(indx + 1);
                        if (o instanceof ResultSet) {
                            GroovyResultSet resultSet = new GroovyResultSetProxy((ResultSet)o).getImpl();
                            results.add(resultSet);
                            resultSetResources.add(resultSet);
                        } else {
                            results.add(o);
                        }
                    }
                    ++inouts;
                }
                ++indx;
            }
            closure.call(results.toArray(new Object[inouts]));
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Failed to execute: " + sql, e);
            throw e;
        }
        finally {
            this.closeResources(connection, statement);
            for (GroovyResultSet rs : resultSetResources) {
                this.closeResources(null, null, rs);
            }
        }
    }

    public void call(GString gstring, Closure closure) throws Exception {
        List<Object> params = this.getParameters(gstring);
        String sql = this.asSql(gstring, params);
        this.call(sql, params, closure);
    }

    public void close() throws SQLException {
        if (this.useConnection == null) {
            log.log(Level.FINEST, "Close operation not supported when using datasets - attempt to close ignored");
            return;
        }
        try {
            this.useConnection.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Caught exception closing connection: " + e, e);
            throw e;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void commit() throws SQLException {
        if (this.useConnection == null) {
            log.log(Level.FINEST, "Commit operation not supported when using datasets unless using withTransaction or cacheConnection - attempt to commit ignored");
            return;
        }
        try {
            this.useConnection.commit();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Caught exception committing connection: " + e, e);
            throw e;
        }
    }

    public void rollback() throws SQLException {
        if (this.useConnection == null) {
            log.log(Level.FINEST, "Rollback operation not supported when using datasets unless using withTransaction or cacheConnection - attempt to rollback ignored");
            return;
        }
        try {
            this.useConnection.rollback();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Caught exception rolling back connection: " + e, e);
            throw e;
        }
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public Connection getConnection() {
        return this.useConnection;
    }

    public void withStatement(Closure configureStatement) {
        this.configureStatement = configureStatement;
    }

    public synchronized void setCacheStatements(boolean cacheStatements) {
        this.cacheStatements = cacheStatements;
        if (!cacheStatements) {
            this.clearStatementCache();
        }
    }

    public boolean isCacheStatements() {
        return this.cacheStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheConnection(Closure closure) throws SQLException {
        boolean savedCacheConnection = this.cacheConnection;
        this.cacheConnection = true;
        Connection connection = null;
        try {
            connection = this.createConnection();
            this.callClosurePossiblyWithConnection(closure, connection);
        }
        finally {
            this.cacheConnection = false;
            this.closeResources(connection, null);
            this.cacheConnection = savedCacheConnection;
            if (this.dataSource != null && !this.cacheConnection) {
                this.useConnection = null;
            }
        }
    }

    public synchronized void withTransaction(Closure closure) throws SQLException {
        boolean savedCacheConnection = this.cacheConnection;
        this.cacheConnection = true;
        Connection connection = null;
        boolean savedAutoCommit = true;
        try {
            connection = this.createConnection();
            savedAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            this.callClosurePossiblyWithConnection(closure, connection);
            connection.commit();
        }
        catch (SQLException e) {
            this.handleError(connection, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.handleError(connection, e);
            throw e;
        }
        catch (Error e) {
            this.handleError(connection, e);
            throw e;
        }
        finally {
            if (connection != null) {
                connection.setAutoCommit(savedAutoCommit);
            }
            this.cacheConnection = false;
            this.closeResources(connection, null);
            this.cacheConnection = savedCacheConnection;
            if (this.dataSource != null && !this.cacheConnection) {
                this.useConnection = null;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] withBatch(Closure closure) throws SQLException {
        int[] nArray;
        Statement statement;
        Connection connection;
        boolean savedCacheConnection;
        block9: {
            savedCacheConnection = this.cacheConnection;
            this.cacheConnection = true;
            connection = null;
            statement = null;
            boolean savedAutoCommit = true;
            try {
                connection = this.createConnection();
                savedAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                statement = this.createStatement(connection);
                closure.call(statement);
                int[] result = statement.executeBatch();
                connection.commit();
                log.fine("Successfully executed batch with " + result.length + " command(s)");
                nArray = result;
                if (connection == null) break block9;
            }
            catch (SQLException e) {
                try {
                    this.handleError(connection, e);
                    throw e;
                    catch (RuntimeException e2) {
                        this.handleError(connection, e2);
                        throw e2;
                    }
                    catch (Error e3) {
                        this.handleError(connection, e3);
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        connection.setAutoCommit(savedAutoCommit);
                    }
                    this.cacheConnection = false;
                    this.closeResources(connection, statement);
                    this.cacheConnection = savedCacheConnection;
                    if (this.dataSource != null && !this.cacheConnection) {
                        this.useConnection = null;
                    }
                    throw throwable;
                }
            }
            connection.setAutoCommit(savedAutoCommit);
        }
        this.cacheConnection = false;
        this.closeResources(connection, statement);
        this.cacheConnection = savedCacheConnection;
        if (this.dataSource != null && !this.cacheConnection) {
            this.useConnection = null;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cacheStatements(Closure closure) throws SQLException {
        boolean savedCacheStatements = this.cacheStatements;
        this.cacheStatements = true;
        Connection connection = null;
        try {
            connection = this.createConnection();
            this.callClosurePossiblyWithConnection(closure, connection);
        }
        finally {
            this.cacheStatements = false;
            this.closeResources(connection, null);
            this.cacheStatements = savedCacheStatements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResultSet executeQuery(String sql) throws SQLException {
        AbstractQueryCommand command = this.createQueryCommand(sql);
        ResultSet rs = null;
        try {
            rs = command.execute();
        }
        finally {
            command.closeResources();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResultSet executePreparedQuery(String sql, List<Object> params) throws SQLException {
        AbstractQueryCommand command = this.createPreparedQueryCommand(sql, params);
        ResultSet rs = null;
        try {
            rs = command.execute();
        }
        finally {
            command.closeResources();
        }
        return rs;
    }

    protected List<GroovyRowResult> asList(String sql, ResultSet rs) throws SQLException {
        ArrayList<GroovyRowResult> results = new ArrayList<GroovyRowResult>();
        try {
            while (rs.next()) {
                results.add(SqlGroovyMethods.toRowResult(rs));
            }
            ArrayList<GroovyRowResult> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            log.log(Level.INFO, "Failed to retrieve row from ResultSet for: " + sql, e);
            throw e;
        }
        finally {
            rs.close();
        }
    }

    protected String asSql(GString gstring, List<Object> values) {
        String[] strings = gstring.getStrings();
        if (strings.length <= 0) {
            throw new IllegalArgumentException("No SQL specified in GString: " + gstring);
        }
        boolean nulls = false;
        StringBuffer buffer = new StringBuffer();
        boolean warned = false;
        Iterator<Object> iter = values.iterator();
        for (int i = 0; i < strings.length; ++i) {
            String text = strings[i];
            if (text != null) {
                buffer.append(text);
            }
            if (!iter.hasNext()) continue;
            Object value = iter.next();
            if (value != null) {
                if (value instanceof ExpandedVariable) {
                    buffer.append(((ExpandedVariable)value).getObject());
                    iter.remove();
                    continue;
                }
                boolean validBinding = true;
                if (i < strings.length - 1) {
                    String nextText = strings[i + 1];
                    if ((text.endsWith("\"") || text.endsWith("'")) && (nextText.startsWith("'") || nextText.startsWith("\""))) {
                        if (!warned) {
                            log.warning("In Groovy SQL please do not use quotes around dynamic expressions (which start with $) as this means we cannot use a JDBC PreparedStatement and so is a security hole. Groovy has worked around your mistake but the security hole is still there. The expression so far is: " + buffer.toString() + "?" + nextText);
                            warned = true;
                        }
                        buffer.append(value);
                        iter.remove();
                        validBinding = false;
                    }
                }
                if (!validBinding) continue;
                buffer.append("?");
                continue;
            }
            nulls = true;
            iter.remove();
            buffer.append("?'\"?");
        }
        String sql = buffer.toString();
        if (nulls) {
            sql = this.nullify(sql);
        }
        return sql;
    }

    protected String nullify(String sql) {
        int firstWhere = this.findWhereKeyword(sql);
        if (firstWhere >= 0) {
            Pattern[] patterns = new Pattern[]{Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)!=\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?)<>\\s{0,1}(\\s*)\\?'\"\\?(.*)"), Pattern.compile("(?is)^(.{" + firstWhere + "}.*?[^<>])=\\s{0,1}(\\s*)\\?'\"\\?(.*)")};
            String[] replacements = new String[]{"$1 is not $2null$3", "$1 is not $2null$3", "$1 is $2null$3"};
            for (int i = 0; i < patterns.length; ++i) {
                Matcher matcher = patterns[i].matcher(sql);
                while (matcher.matches()) {
                    sql = matcher.replaceAll(replacements[i]);
                    matcher = patterns[i].matcher(sql);
                }
            }
        }
        return sql.replaceAll("\\?'\"\\?", "null");
    }

    protected int findWhereKeyword(String sql) {
        char[] chars = sql.toLowerCase().toCharArray();
        char[] whereChars = "where".toCharArray();
        boolean inString = false;
        int inWhere = 0;
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\'': {
                    inString = !inString;
                    continue block3;
                }
                default: {
                    if (inString || chars[i] != whereChars[inWhere] || ++inWhere != whereChars.length) continue block3;
                    return i;
                }
            }
        }
        return -1;
    }

    protected List<Object> getParameters(GString gstring) {
        return new ArrayList<Object>(Arrays.asList(gstring.getValues()));
    }

    protected void setParameters(List<Object> params, PreparedStatement statement) throws SQLException {
        int i = 1;
        for (Object value : params) {
            this.setObject(statement, i++, value);
        }
    }

    protected void setObject(PreparedStatement statement, int i, Object value) throws SQLException {
        if (value instanceof InParameter || value instanceof OutParameter) {
            if (value instanceof InParameter) {
                InParameter in = (InParameter)value;
                Object val = in.getValue();
                if (null == val) {
                    statement.setNull(i, in.getType());
                } else {
                    statement.setObject(i, val, in.getType());
                }
            }
            if (value instanceof OutParameter) {
                try {
                    OutParameter out = (OutParameter)value;
                    ((CallableStatement)statement).registerOutParameter(i, out.getType());
                }
                catch (ClassCastException e) {
                    throw new SQLException("Cannot register out parameter.");
                }
            }
        } else {
            statement.setObject(i, value);
        }
    }

    protected Connection createConnection() throws SQLException {
        if ((this.cacheStatements || this.cacheConnection) && this.useConnection != null) {
            return this.useConnection;
        }
        if (this.dataSource != null) {
            Connection con;
            try {
                con = AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws SQLException {
                        return Sql.this.dataSource.getConnection();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw (RuntimeException)e;
            }
            if (this.cacheStatements || this.cacheConnection) {
                this.useConnection = con;
            }
            return con;
        }
        return this.useConnection;
    }

    protected void closeResources(Connection connection, Statement statement, ResultSet results) {
        if (results != null) {
            try {
                results.close();
            }
            catch (SQLException e) {
                log.log(Level.INFO, "Caught exception closing resultSet: " + e.getMessage() + " - continuing", e);
            }
        }
        this.closeResources(connection, statement);
    }

    protected void closeResources(Connection connection, Statement statement) {
        if (this.cacheStatements) {
            return;
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.log(Level.INFO, "Caught exception closing statement: " + e.getMessage() + " - continuing", e);
            }
        }
        if (this.cacheConnection) {
            return;
        }
        if (connection != null && this.dataSource != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.log(Level.INFO, "Caught exception closing connection: " + e.getMessage() + " - continuing", e);
            }
        }
    }

    protected void configure(Statement statement) {
        Closure configureStatement = this.configureStatement;
        if (configureStatement != null) {
            configureStatement.call(statement);
        }
    }

    private List<List<Object>> calculateKeys(ResultSet keys) throws SQLException {
        ArrayList<List<Object>> autoKeys = new ArrayList<List<Object>>();
        int count = keys.getMetaData().getColumnCount();
        while (keys.next()) {
            ArrayList<Object> rowKeys = new ArrayList<Object>(count);
            for (int i = 1; i <= count; ++i) {
                rowKeys.add(keys.getObject(i));
            }
            autoKeys.add(rowKeys);
        }
        return autoKeys;
    }

    private Statement createStatement(Connection connection) throws SQLException {
        if (this.resultSetHoldability == -1) {
            return connection.createStatement(this.resultSetType, this.resultSetConcurrency);
        }
        return connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    private void handleError(Connection connection, Throwable t) throws SQLException {
        if (connection != null) {
            log.log(Level.INFO, "Rolling back due to: " + t.getMessage(), t);
            connection.rollback();
        }
    }

    private void callClosurePossiblyWithConnection(Closure closure, Connection connection) {
        if (closure.getMaximumNumberOfParameters() == 1) {
            closure.call(connection);
        } else {
            closure.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStatementCache() {
        Statement[] statements;
        Map<String, Statement> map = this.statementCache;
        synchronized (map) {
            if (this.statementCache.isEmpty()) {
                return;
            }
            statements = new Statement[this.statementCache.size()];
            this.statementCache.values().toArray(statements);
            this.statementCache.clear();
        }
        for (Statement s : statements) {
            try {
                s.close();
            }
            catch (SQLException e) {
                log.log(Level.INFO, "Failed to close statement. Already closed?", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement getAbstractStatement(AbstractStatementCommand cmd, Connection connection, String sql) throws SQLException {
        Statement stmt;
        if (this.cacheStatements) {
            Map<String, Statement> map = this.statementCache;
            synchronized (map) {
                stmt = this.statementCache.get(sql);
                if (stmt == null) {
                    stmt = cmd.execute(connection, sql);
                    this.statementCache.put(sql, stmt);
                }
            }
        } else {
            stmt = cmd.execute(connection, sql);
        }
        return stmt;
    }

    private Statement getStatement(Connection connection, String sql) throws SQLException {
        Statement stmt = this.getAbstractStatement(new CreateStatementCommand(), connection, sql);
        this.configure(stmt);
        return stmt;
    }

    private PreparedStatement getPreparedStatement(Connection connection, String sql, List<Object> params, int returnGeneratedKeys) throws SQLException {
        PreparedStatement statement = (PreparedStatement)this.getAbstractStatement(new CreatePreparedStatementCommand(returnGeneratedKeys), connection, sql);
        this.setParameters(params, statement);
        this.configure(statement);
        return statement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, String sql, List<Object> params) throws SQLException {
        return this.getPreparedStatement(connection, sql, params, 0);
    }

    protected AbstractQueryCommand createQueryCommand(String sql) {
        return new QueryCommand(sql);
    }

    protected AbstractQueryCommand createPreparedQueryCommand(String sql, List<Object> queryParams) {
        return new PreparedQueryCommand(sql, queryParams);
    }

    protected void setInternalConnection(Connection conn) {
    }

    protected final class QueryCommand
    extends AbstractQueryCommand {
        QueryCommand(String sql2) {
            super(sql2);
        }

        protected ResultSet runQuery(Connection connection) throws SQLException {
            this.statement = Sql.this.getStatement(connection, this.sql);
            return this.statement.executeQuery(this.sql);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class PreparedQueryCommand
    extends AbstractQueryCommand {
        private List<Object> params;

        PreparedQueryCommand(String sql2, List<Object> queryParams) {
            super(sql2);
            this.params = queryParams;
        }

        @Override
        protected ResultSet runQuery(Connection connection) throws SQLException {
            PreparedStatement s = Sql.this.getPreparedStatement(connection, this.sql, this.params);
            this.statement = s;
            return s.executeQuery();
        }
    }

    protected abstract class AbstractQueryCommand {
        protected final String sql;
        protected Statement statement;
        private Connection connection;

        AbstractQueryCommand(String sql2) {
            this.sql = sql2;
        }

        final ResultSet execute() throws SQLException {
            this.connection = Sql.this.createConnection();
            Sql.this.setInternalConnection(this.connection);
            this.statement = null;
            try {
                log.fine(this.sql);
                ResultSet result = this.runQuery(this.connection);
                assert (null != this.statement);
                return result;
            }
            catch (SQLException e) {
                log.log(Level.FINE, "Failed to execute: " + this.sql, e);
                this.closeResources();
                this.connection = null;
                this.statement = null;
                throw e;
            }
        }

        public final void closeResources() {
            Sql.this.closeResources(this.connection, this.statement);
        }

        public final void closeResources(ResultSet rs) {
            Sql.this.closeResources(this.connection, this.statement, rs);
        }

        protected abstract ResultSet runQuery(Connection var1) throws SQLException;
    }

    private class CreateStatementCommand
    extends AbstractStatementCommand {
        private CreateStatementCommand() {
        }

        Statement execute(Connection conn, String sql) throws SQLException {
            return Sql.this.createStatement(conn);
        }
    }

    private class CreatePreparedStatementCommand
    extends AbstractStatementCommand {
        private final int returnGeneratedKeys;

        CreatePreparedStatementCommand(int returnGeneratedKeys) {
            this.returnGeneratedKeys = returnGeneratedKeys;
        }

        PreparedStatement execute(Connection connection, String sql) throws SQLException {
            if (this.returnGeneratedKeys != 0) {
                return connection.prepareStatement(sql, this.returnGeneratedKeys);
            }
            if (this.appearsLikeStoredProc(sql)) {
                return connection.prepareCall(sql);
            }
            return connection.prepareStatement(sql);
        }

        boolean appearsLikeStoredProc(String sql) {
            return sql.matches("\\s*[{]?\\s*[?]?\\s*[=]?\\s*[cC][aA][lL][lL].*");
        }
    }

    private abstract class AbstractStatementCommand {
        private AbstractStatementCommand() {
        }

        abstract Statement execute(Connection var1, String var2) throws SQLException;
    }
}

