/*
 * Decompiled with CFR 0.152.
 */
package groovy.grape;

import groovy.grape.Grape;
import groovy.lang.Grab;
import groovy.lang.GrabConfig;
import groovy.lang.GrabExclude;
import groovy.lang.Grapes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class GrabAnnotationTransformation
extends ClassCodeVisitorSupport
implements ASTTransformation {
    private static final String GRAB_CLASS_NAME = Grab.class.getName();
    private static final String GRAB_DOT_NAME = GRAB_CLASS_NAME.substring(GRAB_CLASS_NAME.lastIndexOf("."));
    private static final String GRAB_SHORT_NAME = GRAB_DOT_NAME.substring(1);
    private static final String GRABEXCLUDE_CLASS_NAME = GrabExclude.class.getName();
    private static final String GRABEXCLUDE_DOT_NAME = GrabAnnotationTransformation.dotName(GRABEXCLUDE_CLASS_NAME);
    private static final String GRABEXCLUDE_SHORT_NAME = GrabAnnotationTransformation.shortName(GRABEXCLUDE_DOT_NAME);
    private static final String GRABCONFIG_CLASS_NAME = GrabConfig.class.getName();
    private static final String GRABCONFIG_DOT_NAME = GrabAnnotationTransformation.dotName(GRABCONFIG_CLASS_NAME);
    private static final String GRABCONFIG_SHORT_NAME = GrabAnnotationTransformation.shortName(GRABCONFIG_DOT_NAME);
    private static final String GRAPES_CLASS_NAME = Grapes.class.getName();
    private static final String GRAPES_DOT_NAME = GrabAnnotationTransformation.dotName(GRAPES_CLASS_NAME);
    private static final String GRAPES_SHORT_NAME = GrabAnnotationTransformation.shortName(GRAPES_DOT_NAME);
    private static final ClassNode THREAD_CLASSNODE = new ClassNode(Thread.class);
    private static final List<String> GRABEXCLUDE_REQUIRED = Arrays.asList("group", "module");
    private static final List<String> GRAB_REQUIRED = Arrays.asList("group", "module", "version");
    private static final List<String> GRAB_OPTIONAL = Arrays.asList("classifier", "transitive", "conf", "ext");
    private static final Collection<String> GRAB_ALL = DefaultGroovyMethods.plus(GRAB_REQUIRED, GRAB_OPTIONAL);
    private static final Pattern IVY_PATTERN = Pattern.compile("([a-zA-Z0-9-/._+=]+)#([a-zA-Z0-9-/._+=]+)(;([a-zA-Z0-9-/.\\(\\)\\[\\]\\{\\}_+=,:@][a-zA-Z0-9-/.\\(\\)\\]\\{\\}_+=,:@]*))?(\\[([a-zA-Z0-9-/._+=,]*)\\])?");
    boolean allowShortGrab;
    Set<String> grabAliases;
    List<AnnotationNode> grabAnnotations;
    boolean allowShortGrabExcludes;
    Set<String> grabExcludeAliases;
    List<AnnotationNode> grabExcludeAnnotations;
    boolean allowShortGrabConfig;
    Set<String> grabConfigAliases;
    List<AnnotationNode> grabConfigAnnotations;
    boolean allowShortGrapes;
    Set<String> grapesAliases;
    List<AnnotationNode> grapesAnnotations;
    SourceUnit sourceUnit;
    ClassLoader loader;
    boolean initContextClassLoader;

    private static String dotName(String className) {
        return className.substring(className.lastIndexOf("."));
    }

    private static String shortName(String className) {
        return className.substring(1);
    }

    @Override
    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        this.loader = null;
        this.initContextClassLoader = false;
        ModuleNode mn = (ModuleNode)nodes[0];
        this.allowShortGrab = true;
        this.allowShortGrabExcludes = true;
        this.allowShortGrabConfig = true;
        this.allowShortGrapes = true;
        this.grabAliases = new HashSet<String>();
        this.grabExcludeAliases = new HashSet<String>();
        this.grabConfigAliases = new HashSet<String>();
        this.grapesAliases = new HashSet<String>();
        for (ImportNode im : mn.getImports()) {
            String alias = im.getAlias();
            String className = im.getClassName();
            if (className.endsWith(GRAB_DOT_NAME) && (alias == null || alias.length() == 0) || GRAB_CLASS_NAME.equals(alias)) {
                this.allowShortGrab = false;
            } else if (GRAB_CLASS_NAME.equals(className)) {
                this.grabAliases.add(im.getAlias());
            }
            if (className.endsWith(GRAPES_DOT_NAME) && (alias == null || alias.length() == 0) || GRAPES_CLASS_NAME.equals(alias)) {
                this.allowShortGrapes = false;
                continue;
            }
            if (!GRAPES_CLASS_NAME.equals(className)) continue;
            this.grapesAliases.add(im.getAlias());
        }
        ArrayList grabMaps = new ArrayList();
        ArrayList<Map<String, Object>> grabExcludeMaps = new ArrayList<Map<String, Object>>();
        for (ClassNode classNode : this.sourceUnit.getAST().getClasses()) {
            Expression member;
            this.grabAnnotations = new ArrayList<AnnotationNode>();
            this.grabExcludeAnnotations = new ArrayList<AnnotationNode>();
            this.grabConfigAnnotations = new ArrayList<AnnotationNode>();
            this.grapesAnnotations = new ArrayList<AnnotationNode>();
            this.visitClass(classNode);
            ClassNode grapeClassNode = new ClassNode(Grape.class);
            if (!this.grapesAnnotations.isEmpty()) {
                for (AnnotationNode node : this.grapesAnnotations) {
                    Expression init = node.getMember("initClass");
                    Expression value = node.getMember("value");
                    if (value instanceof ListExpression) {
                        for (Expression o : ((ListExpression)value).getExpressions()) {
                            if (!(o instanceof ConstantExpression)) continue;
                            this.extractGrab(init, (ConstantExpression)o);
                        }
                        continue;
                    }
                    if (!(value instanceof ConstantExpression)) continue;
                    this.extractGrab(init, (ConstantExpression)value);
                }
            }
            if (!this.grabConfigAnnotations.isEmpty()) {
                for (AnnotationNode node : this.grabConfigAnnotations) {
                    this.checkForClassLoader(node);
                    this.checkForInitContextClassLoader(node);
                }
                this.addInitContextClassLoaderIfNeeded(classNode);
            }
            if (!this.grabExcludeAnnotations.isEmpty()) {
                block7: for (AnnotationNode node : this.grabExcludeAnnotations) {
                    HashMap<String, Object> grabExcludeMap = new HashMap<String, Object>();
                    this.checkForConvenienceForm(node, true);
                    for (String s : GRABEXCLUDE_REQUIRED) {
                        member = node.getMember(s);
                        if (member == null) {
                            this.addError("The missing attribute \"" + s + "\" is required in @" + node.getClassNode().getNameWithoutPackage() + " annotations", node);
                            continue block7;
                        }
                        if (member != null && !(member instanceof ConstantExpression)) {
                            this.addError("Attribute \"" + s + "\" has value " + member.getText() + " but should be an inline constant in @" + node.getClassNode().getNameWithoutPackage() + " annotations", node);
                            continue block7;
                        }
                        grabExcludeMap.put(s, ((ConstantExpression)member).getValue());
                    }
                    grabExcludeMaps.add(grabExcludeMap);
                }
            }
            if (this.grabAnnotations.isEmpty()) continue;
            block9: for (AnnotationNode node : this.grabAnnotations) {
                HashMap<String, Object> grabMap = new HashMap<String, Object>();
                this.checkForConvenienceForm(node, false);
                for (String s : GRAB_ALL) {
                    member = node.getMember(s);
                    if (member == null && !GRAB_OPTIONAL.contains(s)) {
                        this.addError("The missing attribute \"" + s + "\" is required in @" + node.getClassNode().getNameWithoutPackage() + " annotations", node);
                        continue block9;
                    }
                    if (member != null && !(member instanceof ConstantExpression)) {
                        this.addError("Attribute \"" + s + "\" has value " + member.getText() + " but should be an inline constant in @" + node.getClassNode().getNameWithoutPackage() + " annotations", node);
                        continue block9;
                    }
                    if (node.getMember(s) == null) continue;
                    grabMap.put(s, ((ConstantExpression)member).getValue());
                }
                grabMaps.add(grabMap);
                this.callGrabAsStaticInitIfNeeded(classNode, grapeClassNode, node, grabExcludeMaps);
            }
        }
        if (!grabMaps.isEmpty()) {
            HashMap<String, Object> basicArgs = new HashMap<String, Object>();
            basicArgs.put("classLoader", this.loader != null ? this.loader : this.sourceUnit.getClassLoader());
            if (!grabExcludeMaps.isEmpty()) {
                basicArgs.put("excludes", grabExcludeMaps);
            }
            try {
                Grape.grab(basicArgs, grabMaps.toArray(new Map[grabMaps.size()]));
            }
            catch (RuntimeException re) {
                source.addException(re);
            }
        }
    }

    private void callGrabAsStaticInitIfNeeded(ClassNode classNode, ClassNode grapeClassNode, AnnotationNode node, List<Map<String, Object>> grabExcludeMaps) {
        if (node.getMember("initClass") == null || node.getMember("initClass") == ConstantExpression.TRUE) {
            ArgumentListExpression grabArgs;
            ArrayList<Statement> grabInitializers = new ArrayList<Statement>();
            MapExpression me = new MapExpression();
            for (String s : GRAB_REQUIRED) {
                me.addMapEntryExpression(new ConstantExpression(s), node.getMember(s));
            }
            for (String s : GRAB_OPTIONAL) {
                if (node.getMember(s) == null) continue;
                me.addMapEntryExpression(new ConstantExpression(s), node.getMember(s));
            }
            if (grabExcludeMaps.isEmpty()) {
                grabArgs = new ArgumentListExpression(me);
            } else {
                MapExpression args = new MapExpression();
                ListExpression list = new ListExpression();
                for (Map<String, Object> map : grabExcludeMaps) {
                    Set<Map.Entry<String, Object>> entries = map.entrySet();
                    MapExpression inner = new MapExpression();
                    for (Map.Entry<String, Object> entry : entries) {
                        inner.addMapEntryExpression(new ConstantExpression(entry.getKey()), new ConstantExpression(entry.getValue()));
                    }
                    list.addExpression(inner);
                }
                args.addMapEntryExpression(new ConstantExpression("excludes"), list);
                grabArgs = new ArgumentListExpression(args, me);
            }
            grabInitializers.add(new ExpressionStatement(new StaticMethodCallExpression(grapeClassNode, "grab", grabArgs)));
            classNode.addStaticInitializerStatements(grabInitializers, true);
        }
    }

    private void addInitContextClassLoaderIfNeeded(ClassNode classNode) {
        if (this.initContextClassLoader) {
            ExpressionStatement initStatement = new ExpressionStatement(new MethodCallExpression((Expression)new StaticMethodCallExpression(THREAD_CLASSNODE, "currentThread", ArgumentListExpression.EMPTY_ARGUMENTS), "setContextClassLoader", (Expression)new MethodCallExpression((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "getClass", MethodCallExpression.NO_ARGUMENTS), "getClassLoader", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
            classNode.addObjectInitializerStatements(initStatement);
        }
    }

    private void checkForClassLoader(AnnotationNode node) {
        Expression val = node.getMember("systemClassLoader");
        if (val == null || !(val instanceof ConstantExpression)) {
            return;
        }
        Object systemClassLoaderObject = ((ConstantExpression)val).getValue();
        if (!(systemClassLoaderObject instanceof Boolean)) {
            return;
        }
        Boolean systemClassLoader = (Boolean)systemClassLoaderObject;
        if (systemClassLoader.booleanValue()) {
            this.loader = ClassLoader.getSystemClassLoader();
        }
    }

    private void checkForInitContextClassLoader(AnnotationNode node) {
        Expression val = node.getMember("initContextClassLoader");
        if (val == null || !(val instanceof ConstantExpression)) {
            return;
        }
        Object initContextClassLoaderObject = ((ConstantExpression)val).getValue();
        if (!(initContextClassLoaderObject instanceof Boolean)) {
            return;
        }
        this.initContextClassLoader = (Boolean)initContextClassLoaderObject;
    }

    private void checkForConvenienceForm(AnnotationNode node, boolean exclude) {
        Expression val = node.getMember("value");
        if (val == null || !(val instanceof ConstantExpression)) {
            return;
        }
        Object allParts = ((ConstantExpression)val).getValue();
        if (!(allParts instanceof String)) {
            return;
        }
        String allstr = (String)allParts;
        if (allstr.contains("#")) {
            Matcher m = IVY_PATTERN.matcher(allstr);
            if (!m.find()) {
                return;
            }
            if (m.group(1) == null || m.group(2) == null) {
                return;
            }
            node.addMember("module", new ConstantExpression(m.group(2)));
            node.addMember("group", new ConstantExpression(m.group(1)));
            if (m.group(6) != null) {
                node.addMember("conf", new ConstantExpression(m.group(6)));
            }
            if (m.group(4) != null) {
                node.addMember("version", new ConstantExpression(m.group(4)));
            } else if (!exclude) {
                node.addMember("version", new ConstantExpression("*"));
            }
            node.getMembers().remove("value");
        } else if (allstr.contains(":")) {
            String[] parts;
            String ext = "";
            if (allstr.contains("@")) {
                parts = allstr.split("@");
                if (parts.length > 2) {
                    return;
                }
                allstr = parts[0];
                ext = parts[1];
            }
            if ((parts = allstr.split(":")).length > 4) {
                return;
            }
            if (parts.length > 3) {
                node.addMember("classifier", new ConstantExpression(parts[3]));
            }
            if (parts.length > 2) {
                node.addMember("version", new ConstantExpression(parts[2]));
            } else if (!exclude) {
                node.addMember("version", new ConstantExpression("*"));
            }
            if (ext.length() > 0) {
                node.addMember("ext", new ConstantExpression(ext));
            }
            node.addMember("module", new ConstantExpression(parts[1]));
            node.addMember("group", new ConstantExpression(parts[0]));
            node.getMembers().remove("value");
        }
    }

    private void extractGrab(Expression init, ConstantExpression ce) {
        if (ce.getValue() instanceof AnnotationNode) {
            String name;
            AnnotationNode annotation = (AnnotationNode)ce.getValue();
            if (init != null && annotation.getMember("initClass") != null) {
                annotation.setMember("initClass", init);
            }
            if (GRAB_CLASS_NAME.equals(name = annotation.getClassNode().getName()) || this.allowShortGrab && GRAB_SHORT_NAME.equals(name) || this.grabAliases.contains(name)) {
                this.grabAnnotations.add(annotation);
            }
            if (GRABEXCLUDE_CLASS_NAME.equals(name) || this.allowShortGrabExcludes && GRABEXCLUDE_SHORT_NAME.equals(name) || this.grabExcludeAliases.contains(name)) {
                this.grabExcludeAnnotations.add(annotation);
            }
            if (GRABCONFIG_CLASS_NAME.equals(name) || this.allowShortGrabConfig && GRABCONFIG_SHORT_NAME.equals(name) || this.grabConfigAliases.contains(name)) {
                this.grabConfigAnnotations.add(annotation);
            }
        }
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode an : node.getAnnotations()) {
            String name = an.getClassNode().getName();
            if (GRAB_CLASS_NAME.equals(name) || this.allowShortGrab && GRAB_SHORT_NAME.equals(name) || this.grabAliases.contains(name)) {
                this.grabAnnotations.add(an);
            }
            if (GRABEXCLUDE_CLASS_NAME.equals(name) || this.allowShortGrabExcludes && GRABEXCLUDE_SHORT_NAME.equals(name) || this.grabExcludeAliases.contains(name)) {
                this.grabExcludeAnnotations.add(an);
            }
            if (GRABCONFIG_CLASS_NAME.equals(name) || this.allowShortGrabConfig && GRABCONFIG_SHORT_NAME.equals(name) || this.grabConfigAliases.contains(name)) {
                this.grabConfigAnnotations.add(an);
            }
            if (!GRAPES_CLASS_NAME.equals(name) && (!this.allowShortGrapes || !GRAPES_SHORT_NAME.equals(name)) && !this.grapesAliases.contains(name)) continue;
            this.grapesAnnotations.add(an);
        }
    }
}

