/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.DeprecationException;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.Script;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.tools.gse.DependencyTracker;
import org.codehaus.groovy.tools.gse.StringSetMap;

public class GroovyScriptEngine
implements ResourceConnector {
    private static final ClassLoader CL_STUB = new ClassLoader(){};
    private static WeakReference<ThreadLocal<StringSetMap>> dependencyCache = new WeakReference<Object>(null);
    private URL[] roots;
    private ResourceConnector rc;
    private final ClassLoader parentLoader;
    private final GroovyClassLoader groovyLoader;
    private final Map<String, ScriptCacheEntry> scriptCache = new ConcurrentHashMap<String, ScriptCacheEntry>();
    private CompilerConfiguration config = new CompilerConfiguration(CompilerConfiguration.DEFAULT);

    private static StringSetMap getDepCache() {
        ThreadLocal local = (ThreadLocal)dependencyCache.get();
        if (local != null) {
            return (StringSetMap)local.get();
        }
        local = new ThreadLocal<StringSetMap>(){

            @Override
            protected StringSetMap initialValue() {
                return new StringSetMap();
            }
        };
        dependencyCache = new WeakReference<ThreadLocal>(local);
        return (StringSetMap)local.get();
    }

    public static void main(String[] urls) throws Exception {
        GroovyScriptEngine gse = new GroovyScriptEngine(urls);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("groovy> ");
            String line = br.readLine();
            if (line == null || line.equals("quit")) break;
            try {
                System.out.println(gse.run(line, new Binding()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private GroovyClassLoader initGroovyLoader() {
        return (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (GroovyScriptEngine.this.parentLoader instanceof GroovyClassLoader) {
                    return new ScriptClassLoader((GroovyClassLoader)GroovyScriptEngine.this.parentLoader);
                }
                return new ScriptClassLoader(GroovyScriptEngine.this.parentLoader);
            }
        });
    }

    public URLConnection getResourceConnection(String resourceName) throws ResourceException {
        URLConnection groovyScriptConn = null;
        ResourceException se = null;
        for (URL root : this.roots) {
            String message;
            URL scriptURL = null;
            try {
                scriptURL = new URL(root, resourceName);
                groovyScriptConn = scriptURL.openConnection();
                groovyScriptConn.getInputStream();
                break;
            }
            catch (MalformedURLException e) {
                message = "Malformed URL: " + root + ", " + resourceName;
                if (se == null) {
                    se = new ResourceException(message);
                    continue;
                }
                se = new ResourceException(message, se);
            }
            catch (IOException e1) {
                message = "Cannot open URL: " + scriptURL;
                se = se == null ? new ResourceException(message) : new ResourceException(message, se);
            }
        }
        if (groovyScriptConn == null) {
            throw se;
        }
        return groovyScriptConn;
    }

    private GroovyScriptEngine(URL[] roots, ClassLoader parent, ResourceConnector rc) {
        if (roots == null) {
            roots = new URL[]{};
        }
        this.roots = roots;
        if (rc == null) {
            rc = this;
        }
        this.rc = rc;
        if (parent == CL_STUB) {
            parent = this.getClass().getClassLoader();
        }
        this.parentLoader = parent;
        this.groovyLoader = this.initGroovyLoader();
        for (URL root : roots) {
            this.groovyLoader.addURL(root);
        }
    }

    public GroovyScriptEngine(URL[] roots) {
        this(roots, CL_STUB, null);
    }

    public GroovyScriptEngine(URL[] roots, ClassLoader parentClassLoader) {
        this(roots, parentClassLoader, null);
    }

    public GroovyScriptEngine(String[] urls) throws IOException {
        this(GroovyScriptEngine.createRoots(urls), CL_STUB, null);
    }

    private static URL[] createRoots(String[] urls) throws MalformedURLException {
        if (urls == null) {
            return null;
        }
        URL[] roots = new URL[urls.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = urls[i].indexOf("://") != -1 ? new URL(urls[i]) : new File(urls[i]).toURI().toURL();
        }
        return roots;
    }

    public GroovyScriptEngine(String[] urls, ClassLoader parentClassLoader) throws IOException {
        this(GroovyScriptEngine.createRoots(urls), parentClassLoader, null);
    }

    public GroovyScriptEngine(String url) throws IOException {
        this(new String[]{url});
    }

    public GroovyScriptEngine(String url, ClassLoader parentClassLoader) throws IOException {
        this(new String[]{url}, parentClassLoader);
    }

    public GroovyScriptEngine(ResourceConnector rc) {
        this(null, CL_STUB, rc);
    }

    public GroovyScriptEngine(ResourceConnector rc, ClassLoader parentClassLoader) {
        this(null, parentClassLoader, rc);
    }

    public ClassLoader getParentClassLoader() {
        return this.parentLoader;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        throw new DeprecationException("The method GroovyScriptEngine#setParentClassLoader(ClassLoader) is no longer supported. Specify a parentLoader in the constructor instead.");
    }

    public Class loadScriptByName(String scriptName) throws ResourceException, ScriptException {
        ScriptCacheEntry entry = this.scriptCache.get(scriptName);
        URLConnection conn = this.rc.getResourceConnection(scriptName);
        Class clazz = null;
        if (entry != null) {
            clazz = entry.scriptClass;
        }
        if (this.isSourceNewer(conn, entry)) {
            try {
                clazz = this.groovyLoader.parseClass(conn.getInputStream(), conn.getURL().getFile());
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
        return clazz;
    }

    public Class loadScriptByName(String scriptName, ClassLoader parentClassLoader) throws ResourceException, ScriptException {
        throw new DeprecationException("The method GroovyScriptEngine#loadScriptByName(String,ClassLoader) is no longer supported. Use GroovyScriptEngine#loadScriptByName(String) instead.");
    }

    public String run(String scriptName, String argument) throws ResourceException, ScriptException {
        Binding binding = new Binding();
        binding.setVariable("arg", argument);
        Object result = this.run(scriptName, binding);
        return result == null ? "" : result.toString();
    }

    public Object run(String scriptName, Binding binding) throws ResourceException, ScriptException {
        return this.createScript(scriptName, binding).run();
    }

    public Script createScript(String scriptName, Binding binding) throws ResourceException, ScriptException {
        return InvokerHelper.createScript(this.loadScriptByName(scriptName), binding);
    }

    protected boolean isSourceNewer(URLConnection conn, ScriptCacheEntry entry) throws ResourceException {
        long lastMod;
        if (entry == null) {
            return true;
        }
        long entryChangeTime = entry.lastModified + (long)this.config.getMinimumRecompilationInterval();
        if (entryChangeTime < System.currentTimeMillis()) {
            return false;
        }
        URL source = conn.getURL();
        if (source.getProtocol().equals("file")) {
            String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
            File file = new File(path);
            lastMod = file.lastModified();
        } else {
            lastMod = conn.getLastModified();
            try {
                conn.getInputStream().close();
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
        return entryChangeTime < lastMod;
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyLoader;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CompilerConfiguration config) {
        if (config == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.config = config;
    }

    private class ScriptClassLoader
    extends GroovyClassLoader {
        public ScriptClassLoader(GroovyClassLoader loader) {
            super(loader);
        }

        public ScriptClassLoader(ClassLoader loader) {
            super(loader);
        }

        private void setResLoader() {
            final GroovyResourceLoader rl = this.getResourceLoader();
            this.setResourceLoader(new GroovyResourceLoader(){

                public URL loadGroovySource(String className) throws MalformedURLException {
                    String filename = className.replace('.', File.separatorChar) + GroovyScriptEngine.this.config.getDefaultScriptExtension();
                    try {
                        URLConnection dependentScriptConn = GroovyScriptEngine.this.rc.getResourceConnection(filename);
                        return dependentScriptConn.getURL();
                    }
                    catch (ResourceException resourceException) {
                        return rl.loadGroovySource(className);
                    }
                }
            });
        }

        protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
            CompilationUnit cu = super.createCompilationUnit(config, source);
            final StringSetMap cache = GroovyScriptEngine.getDepCache();
            cu.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                    DependencyTracker dt = new DependencyTracker(source, cache);
                    dt.visitClass(classNode);
                }
            }, 7);
            return cu;
        }

        public Class parseClass(GroovyCodeSource codeSource, boolean shouldCacheSource) throws CompilationFailedException {
            Class answer = super.parseClass(codeSource, shouldCacheSource);
            StringSetMap cache = GroovyScriptEngine.getDepCache();
            cache.makeTransitiveHull();
            long time = System.currentTimeMillis();
            for (Map.Entry entry : cache.entrySet()) {
                String entryName = (String)entry.getKey();
                Class clazz = this.getClassCacheEntry(entryName);
                if (clazz == null) continue;
                ScriptCacheEntry cacheEntry = new ScriptCacheEntry(clazz, time, (Set)entry.getValue());
                GroovyScriptEngine.this.scriptCache.put(entryName, cacheEntry);
            }
            cache.clear();
            return answer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptCacheEntry {
        private final Class scriptClass;
        private final long lastModified;
        private final Set<String> dependencies;

        public ScriptCacheEntry(Class clazz, long modified, Set<String> depend) {
            this.scriptClass = clazz;
            this.lastModified = modified;
            this.dependencies = depend;
        }
    }
}

