/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassLoaderForClassArtifacts;
import org.codehaus.groovy.reflection.stdclasses.ArrayCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigDecimalCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigIntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BooleanCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ByteCachedClass;
import org.codehaus.groovy.reflection.stdclasses.CachedClosureClass;
import org.codehaus.groovy.reflection.stdclasses.CharacterCachedClass;
import org.codehaus.groovy.reflection.stdclasses.DoubleCachedClass;
import org.codehaus.groovy.reflection.stdclasses.FloatCachedClass;
import org.codehaus.groovy.reflection.stdclasses.IntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.LongCachedClass;
import org.codehaus.groovy.reflection.stdclasses.NumberCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ObjectCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ShortCachedClass;
import org.codehaus.groovy.reflection.stdclasses.StringCachedClass;
import org.codehaus.groovy.util.ConcurrentSoftMap;
import org.codehaus.groovy.util.ConcurrentWeakMap;
import org.codehaus.groovy.util.FinalizableRef;
import org.codehaus.groovy.util.LazySoftReference;
import org.codehaus.groovy.util.LockableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends ConcurrentSoftMap.Entry<Class, ClassInfo> {
    private final LazyCachedClassRef cachedClassRef;
    private MetaClass strongMetaClass;
    private SoftReference<MetaClass> weakMetaClass;
    private volatile int version;
    private final LazyClassLoaderRef artifactClassLoader;
    private static final HashSet<ClassInfo> modifiedExpandos = new HashSet();
    private final LockableObject lock = new LockableObject();
    MetaMethod[] dgmMetaMethods = CachedClass.EMPTY;
    MetaMethod[] newMetaMethods = CachedClass.EMPTY;
    public final int hash;
    private ConcurrentWeakMap perInstanceMetaClassMap;
    private static final ClassInfoSet globalClassSet = new ClassInfoSet();
    private static final ThreadLocal<LocalMap> localMap = new ThreadLocal<LocalMap>(){
        LocalMap recentThreadMap;

        @Override
        protected LocalMap initialValue() {
            return new LocalMap();
        }

        @Override
        public LocalMap get() {
            LocalMap res;
            LocalMap recent = this.recentThreadMap;
            if (recent != null && recent.myThread == Thread.currentThread()) {
                return recent;
            }
            this.recentThreadMap = res = (LocalMap)super.get();
            return res;
        }
    };

    ClassInfo(ConcurrentSoftMap.Segment segment, Class klazz, int hash) {
        super(segment, klazz, hash);
        this.hash = hash;
        this.cachedClassRef = new LazyCachedClassRef(this);
        this.artifactClassLoader = new LazyClassLoaderRef(this);
    }

    public int getVersion() {
        return this.version;
    }

    public ExpandoMetaClass getModifiedExpando() {
        return this.strongMetaClass == null ? null : (this.strongMetaClass instanceof ExpandoMetaClass ? (ExpandoMetaClass)this.strongMetaClass : null);
    }

    public static void clearModifiedExpandos() {
        Iterator<ClassInfo> it = modifiedExpandos.iterator();
        while (it.hasNext()) {
            ClassInfo info = it.next();
            it.remove();
            info.setStrongMetaClass(null);
        }
    }

    public CachedClass getCachedClass() {
        return (CachedClass)this.cachedClassRef.get();
    }

    public ClassLoaderForClassArtifacts getArtifactClassLoader() {
        return (ClassLoaderForClassArtifacts)this.artifactClassLoader.get();
    }

    public static ClassInfo getClassInfo(Class cls) {
        return localMap.get().get(cls);
    }

    public MetaClass getStrongMetaClass() {
        return this.strongMetaClass;
    }

    public void setStrongMetaClass(MetaClass answer) {
        ++this.version;
        if (this.strongMetaClass instanceof ExpandoMetaClass) {
            ((ExpandoMetaClass)this.strongMetaClass).inRegistry = false;
            modifiedExpandos.remove(this);
        }
        this.strongMetaClass = answer;
        if (this.strongMetaClass instanceof ExpandoMetaClass) {
            ((ExpandoMetaClass)this.strongMetaClass).inRegistry = true;
            modifiedExpandos.add(this);
        }
        this.weakMetaClass = null;
    }

    public MetaClass getWeakMetaClass() {
        return this.weakMetaClass == null ? null : this.weakMetaClass.get();
    }

    public void setWeakMetaClass(MetaClass answer) {
        ++this.version;
        this.strongMetaClass = null;
        this.weakMetaClass = answer == null ? null : new SoftReference<MetaClass>(answer);
    }

    public MetaClass getMetaClassForClass() {
        return this.strongMetaClass != null ? this.strongMetaClass : (this.weakMetaClass == null ? null : this.weakMetaClass.get());
    }

    private MetaClass getMetaClassUnderLock() {
        MetaClass answer = this.getMetaClassForClass();
        if (answer != null) {
            return answer;
        }
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        answer = metaClassRegistry.getMetaClassCreationHandler().create((Class)this.get(), metaClassRegistry);
        answer.initialize();
        if (GroovySystem.isKeepJavaMetaClasses()) {
            this.setStrongMetaClass(answer);
        } else {
            this.setWeakMetaClass(answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MetaClass getMetaClass() {
        MetaClass answer = this.getMetaClassForClass();
        if (answer != null) {
            return answer;
        }
        this.lock();
        try {
            MetaClass metaClass = this.getMetaClassUnderLock();
            return metaClass;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Object obj) {
        MetaClass instanceMetaClass = this.getPerInstanceMetaClass(obj);
        if (instanceMetaClass != null) {
            return instanceMetaClass;
        }
        this.lock();
        try {
            MetaClass metaClass = this.getMetaClassUnderLock();
            return metaClass;
        }
        finally {
            this.unlock();
        }
    }

    public static int size() {
        return globalClassSet.size();
    }

    public static int fullSize() {
        return globalClassSet.fullSize();
    }

    @Override
    public void finalizeRef() {
        this.setStrongMetaClass(null);
        this.cachedClassRef.set(null);
        this.artifactClassLoader.set(null);
        super.finalizeRef();
    }

    private static CachedClass createCachedClass(Class klazz, ClassInfo classInfo) {
        if (klazz == Object.class) {
            return new ObjectCachedClass(classInfo);
        }
        if (klazz == String.class) {
            return new StringCachedClass(classInfo);
        }
        CachedClass cachedClass = Number.class.isAssignableFrom(klazz) || klazz.isPrimitive() ? (klazz == Number.class ? new NumberCachedClass(klazz, classInfo) : (klazz == Integer.class || klazz == Integer.TYPE ? new IntegerCachedClass(klazz, classInfo, klazz == Integer.class) : (klazz == Double.class || klazz == Double.TYPE ? new DoubleCachedClass(klazz, classInfo, klazz == Double.class) : (klazz == BigDecimal.class ? new BigDecimalCachedClass(klazz, classInfo) : (klazz == Long.class || klazz == Long.TYPE ? new LongCachedClass(klazz, classInfo, klazz == Long.class) : (klazz == Float.class || klazz == Float.TYPE ? new FloatCachedClass(klazz, classInfo, klazz == Float.class) : (klazz == Short.class || klazz == Short.TYPE ? new ShortCachedClass(klazz, classInfo, klazz == Short.class) : (klazz == Boolean.TYPE ? new BooleanCachedClass(klazz, classInfo, false) : (klazz == Character.TYPE ? new CharacterCachedClass(klazz, classInfo, false) : (klazz == BigInteger.class ? new BigIntegerCachedClass(klazz, classInfo) : (klazz == Byte.class || klazz == Byte.TYPE ? new ByteCachedClass(klazz, classInfo, klazz == Byte.class) : new CachedClass(klazz, classInfo)))))))))))) : (klazz.getName().charAt(0) == '[' ? new ArrayCachedClass(klazz, classInfo) : (klazz == Boolean.class ? new BooleanCachedClass(klazz, classInfo, true) : (klazz == Character.class ? new CharacterCachedClass(klazz, classInfo, true) : (Closure.class.isAssignableFrom(klazz) ? new CachedClosureClass(klazz, classInfo) : new CachedClass(klazz, classInfo)))));
        return cachedClass;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public MetaClass getPerInstanceMetaClass(Object obj) {
        if (this.perInstanceMetaClassMap == null) {
            return null;
        }
        return (MetaClass)this.perInstanceMetaClassMap.get(obj);
    }

    public void setPerInstanceMetaClass(Object obj, MetaClass metaClass) {
        ++this.version;
        if (metaClass != null) {
            if (this.perInstanceMetaClassMap == null) {
                this.perInstanceMetaClassMap = new ConcurrentWeakMap();
            }
            this.perInstanceMetaClassMap.put(obj, metaClass);
        } else if (this.perInstanceMetaClassMap != null) {
            this.perInstanceMetaClassMap.remove(obj);
        }
    }

    public boolean hasPerInstanceMetaClasses() {
        return this.perInstanceMetaClassMap != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DebugRef
    extends FinalizableRef.DebugRef<Class> {
        public static final boolean debug = false;
        private static final AtomicInteger count = new AtomicInteger();
        final String name;

        public DebugRef(Class klazz) {
            super(klazz);
            this.name = klazz == null ? "<null>" : klazz.getName();
            count.incrementAndGet();
        }

        @Override
        public void finalizeRef() {
            System.out.println(this.name + " unloaded " + count.decrementAndGet() + " classes kept");
            super.finalizeRef();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyClassLoaderRef
    extends LazySoftReference<ClassLoaderForClassArtifacts> {
        private final ClassInfo info;

        LazyClassLoaderRef(ClassInfo info) {
            this.info = info;
        }

        @Override
        public ClassLoaderForClassArtifacts initValue() {
            return new ClassLoaderForClassArtifacts((Class)this.info.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyCachedClassRef
    extends LazySoftReference<CachedClass> {
        private final ClassInfo info;

        LazyCachedClassRef(ClassInfo info) {
            this.info = info;
        }

        @Override
        public CachedClass initValue() {
            return ClassInfo.createCachedClass((Class)this.info.get(), this.info);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalMap
    extends HashMap<Class, ClassInfo> {
        private static final int CACHE_SIZE = 5;
        public final Thread myThread = Thread.currentThread();
        private int nextCacheEntry;
        private final ClassInfo[] cache = new ClassInfo[5];
        private static final ClassInfo NOINFO = new ClassInfo(null, null, 0);

        private LocalMap() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = NOINFO;
            }
        }

        public ClassInfo get(Class key) {
            ClassInfo info = this.getFromCache(key);
            if (info != null) {
                return info;
            }
            info = (ClassInfo)super.get(key);
            if (info != null) {
                return this.putToCache(info);
            }
            return this.putToCache((ClassInfo)globalClassSet.getOrPut(key, null));
        }

        private ClassInfo getFromCache(Class klazz) {
            int i = 0;
            int k = this.nextCacheEntry - 1;
            while (i < this.cache.length) {
                ClassInfo info;
                if (k < 0) {
                    k += 5;
                }
                if (klazz == (info = this.cache[k]).get()) {
                    this.nextCacheEntry = k + 1;
                    if (this.nextCacheEntry == 5) {
                        this.nextCacheEntry = 0;
                    }
                    return info;
                }
                ++i;
                --k;
            }
            return null;
        }

        private ClassInfo putToCache(ClassInfo classInfo) {
            this.cache[this.nextCacheEntry++] = classInfo;
            if (this.nextCacheEntry == 5) {
                this.nextCacheEntry = 0;
            }
            return classInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassInfoSet
    extends ConcurrentSoftMap<Class, ClassInfo> {
        @Override
        protected Segment createSegment(int cap) {
            return new Segment(cap);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class Segment
        extends ConcurrentSoftMap.Segment<Class, ClassInfo> {
            Segment(int initialCapacity) {
                super(initialCapacity);
            }

            protected ClassInfo createEntry(Class key, int hash, ClassInfo unused) {
                return new ClassInfo((ConcurrentSoftMap.Segment)this, key, hash);
            }
        }
    }
}

