/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.GroovyClassLoader;
import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.Options;
import groovyjarjarcommonscli.PosixParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.codehaus.groovy.ant.LoggingHelper;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.ErrorReporter;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;

public class Groovyc
extends MatchingTask {
    private final LoggingHelper log = new LoggingHelper((Task)this);
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean stacktrace = false;
    private boolean verbose = false;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private boolean fork = false;
    private File forkJDK;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    protected boolean failOnError = true;
    protected boolean listFiles = false;
    protected File[] compileList = new File[0];
    private String updatedProperty;
    private String errorProperty;
    private boolean taskSuccess = true;
    private boolean includeDestClasses = true;
    protected CompilerConfiguration configuration;
    private Javac javac;
    private boolean jointCompilation;
    private List<File> temporaryFiles = new ArrayList<File>(2);

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path sourcepath) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = sourcepath;
        } else {
            this.compileSourcepath.append(sourcepath);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setListfiles(boolean list) {
        this.listFiles = list;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProceed(boolean proceed) {
        this.failOnError = !proceed;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setMemoryInitialSize(String memoryInitialSize) {
        this.memoryInitialSize = memoryInitialSize;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String memoryMaximumSize) {
        this.memoryMaximumSize = memoryMaximumSize;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean f) {
        this.fork = f;
    }

    public void setJavaHome(File home) {
        this.forkJDK = home;
    }

    public void setUpdatedProperty(String updatedProperty) {
        this.updatedProperty = updatedProperty;
    }

    public void setErrorProperty(String errorProperty) {
        this.errorProperty = errorProperty;
    }

    public void setIncludeDestClasses(boolean includeDestClasses) {
        this.includeDestClasses = includeDestClasses;
    }

    public boolean isIncludeDestClasses() {
        return this.includeDestClasses;
    }

    public boolean getTaskSuccess() {
        return this.taskSuccess;
    }

    public void addConfiguredJavac(Javac javac) {
        this.javac = javac;
        this.jointCompilation = true;
    }

    public void setStacktrace(boolean stacktrace) {
        this.stacktrace = stacktrace;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        if (this.javac != null) {
            this.jointCompilation = true;
        }
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File file = this.getProject().resolveFile(list[i]);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(file);
            String[] files = ds.getIncludedFiles();
            this.scanDir(file, this.destDir != null ? this.destDir : file, files);
        }
        this.compile();
        if (this.updatedProperty != null && this.taskSuccess && this.compileList.length != 0) {
            this.getProject().setNewProperty(this.updatedProperty, "true");
        }
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.groovy");
        m.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
        this.addToCompileList(newFiles);
        if (this.jointCompilation) {
            m.setFrom("*.java");
            m.setTo("*.class");
            newFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m);
            this.addToCompileList(newFiles);
        }
    }

    protected void addToCompileList(File[] newFiles) {
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        if (this.encoding != null && !Charset.isSupported(this.encoding)) {
            throw new BuildException("encoding \"" + this.encoding + "\" not supported.");
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (this.listFiles) {
                for (int i = 0; i < this.compileList.length; ++i) {
                    String filename = this.compileList[i].getAbsolutePath();
                    this.log(filename);
                }
            }
            Path classpath = this.getClasspath() != null ? this.getClasspath() : new Path(this.getProject());
            ArrayList<String> jointOptions = new ArrayList<String>();
            if (this.jointCompilation) {
                for (Map.Entry e : this.javac.getRuntimeConfigurableWrapper().getAttributeMap().entrySet()) {
                    String key = e.getKey().toString();
                    String value = e.getValue().toString();
                    if (key.indexOf("debug") != -1) {
                        String level = "";
                        if (this.javac.getDebugLevel() != null) {
                            level = ":" + this.javac.getDebugLevel();
                        }
                        jointOptions.add("-Fg" + level);
                        continue;
                    }
                    if (key.indexOf("debugLevel") != -1) continue;
                    if ((key.indexOf("nowarn") != -1 || key.indexOf("verbose") != -1 || key.indexOf("deprecation") != -1) && ("on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase("value"))) {
                        jointOptions.add("-F" + key);
                        continue;
                    }
                    if (key.indexOf("classpath") != -1) {
                        classpath.add(this.javac.getClasspath());
                        continue;
                    }
                    if (key.indexOf("depend") != -1 || key.indexOf("extdirs") != -1 || key.indexOf("encoding") != -1 || key.indexOf("source") != -1 || key.indexOf("target") != -1 || key.indexOf("verbose") != -1 || key.indexOf("depend") != -1) {
                        jointOptions.add("-J" + key + "=" + value);
                        continue;
                    }
                    this.log("The option " + key + " cannot be set on the contained <javac> element. The option will be ignored", 1);
                }
            }
            String separator = System.getProperty("file.separator");
            ArrayList<String> commandLineList = new ArrayList<String>();
            if (this.fork) {
                String javaHome = this.forkJDK != null ? this.forkJDK.getPath() : System.getProperty("java.home");
                if (this.includeAntRuntime) {
                    classpath.addExisting(new Path(this.getProject()).concatSystemClasspath("last"));
                }
                if (this.includeJavaRuntime) {
                    classpath.addJavaRuntime();
                }
                commandLineList.add(javaHome + separator + "bin" + separator + "java");
                commandLineList.add("-classpath");
                commandLineList.add(classpath.toString());
                if (this.memoryInitialSize != null && !this.memoryInitialSize.equals("")) {
                    commandLineList.add("-Xms" + this.memoryInitialSize);
                }
                if (this.memoryMaximumSize != null && !this.memoryMaximumSize.equals("")) {
                    commandLineList.add("-Xmx" + this.memoryMaximumSize);
                }
                commandLineList.add("org.codehaus.groovy.tools.FileSystemCompiler");
            }
            commandLineList.add("--classpath");
            commandLineList.add(classpath.toString());
            if (this.jointCompilation) {
                commandLineList.add("-j");
                commandLineList.addAll(jointOptions);
            }
            commandLineList.add("-d");
            commandLineList.add(this.destDir.getPath());
            if (this.encoding != null) {
                commandLineList.add("--encoding");
                commandLineList.add(this.encoding);
            }
            if (this.stacktrace) {
                commandLineList.add("-e");
            }
            int count = 0;
            if (this.fork) {
                for (int i = 0; i < this.compileList.length; ++i) {
                    count += this.compileList[i].getPath().length();
                }
                Iterator iter = commandLineList.iterator();
                while (iter.hasNext()) {
                    count += iter.next().toString().length();
                }
                count += this.compileList.length;
                count += commandLineList.size();
            }
            if (this.fork && count > Short.MAX_VALUE) {
                try {
                    File tempFile = File.createTempFile("groovyc-files-", ".txt");
                    this.temporaryFiles.add(tempFile);
                    PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
                    for (int i = 0; i < this.compileList.length; ++i) {
                        pw.println(this.compileList[i].getPath());
                    }
                    pw.close();
                    commandLineList.add("@" + tempFile.getPath());
                }
                catch (IOException e) {
                    this.log("Error createing file list", e, 0);
                }
            } else {
                for (int i = 0; i < this.compileList.length; ++i) {
                    commandLineList.add(this.compileList[i].getPath());
                }
            }
            String[] commandLine = new String[commandLineList.size()];
            for (int i = 0; i < commandLine.length; ++i) {
                commandLine[i] = (String)commandLineList.get(i);
            }
            if (this.fork) {
                Execute executor = new Execute();
                executor.setAntRun(this.getProject());
                executor.setWorkingDirectory(this.getProject().getBaseDir());
                executor.setCommandline(commandLine);
                try {
                    executor.execute();
                }
                catch (IOException ioe) {
                    throw new BuildException("Error running forked groovyc.", (Throwable)ioe);
                }
                int returnCode = executor.getExitValue();
                if (returnCode != 0) {
                    if (this.failOnError) {
                        throw new BuildException("Forked groovyc returned error code: " + returnCode);
                    }
                    this.log("Forked groovyc returned error code: " + returnCode, 0);
                }
            } else {
                try {
                    Options options = FileSystemCompiler.createCompilationOptions();
                    PosixParser cliParser = new PosixParser();
                    CommandLine cli = cliParser.parse(options, commandLine);
                    this.configuration = FileSystemCompiler.generateCompilerConfigurationFromOptions(cli);
                    String[] filenames = FileSystemCompiler.generateFileNamesFromOptions(cli);
                    boolean fileNameErrors = filenames == null;
                    boolean bl = fileNameErrors = fileNameErrors && !FileSystemCompiler.validateFiles(filenames);
                    if (!fileNameErrors) {
                        FileSystemCompiler.doCompilation(this.configuration, this.makeCompileUnit(), filenames);
                    }
                }
                catch (Exception re) {
                    Throwable t = re;
                    if (re.getClass() == RuntimeException.class && re.getCause() != null) {
                        t = re.getCause();
                    }
                    StringWriter writer = new StringWriter();
                    new ErrorReporter(t, false).write(new PrintWriter(writer));
                    String message = writer.toString();
                    if (this.failOnError) {
                        this.log(message, 2);
                        throw new BuildException("Compilation Failed", t, this.getLocation());
                    }
                    this.log(message, 0);
                }
            }
            Iterator<File> files = this.temporaryFiles.iterator();
            while (files.hasNext()) {
                FileSystemCompiler.deleteRecursive(files.next());
                files.remove();
            }
        }
    }

    protected CompilationUnit makeCompileUnit() {
        if (this.configuration.getJointCompilationOptions() != null) {
            if (!this.configuration.getJointCompilationOptions().containsKey("stubDir")) {
                try {
                    File tempStubDir = FileSystemCompiler.createTempDir();
                    this.temporaryFiles.add(tempStubDir);
                    this.configuration.getJointCompilationOptions().put("stubDir", tempStubDir);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
            return new JavaAwareCompilationUnit(this.configuration, this.buildClassLoaderFor());
        }
        return new CompilationUnit(this.configuration, null, this.buildClassLoaderFor());
    }

    protected GroovyClassLoader buildClassLoaderFor() {
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        if (parent instanceof AntClassLoader) {
            AntClassLoader antLoader = (AntClassLoader)parent;
            String[] pathElm = antLoader.getClasspath().split(File.pathSeparator);
            List classpath = this.configuration.getClasspath();
            for (String cpEntry : classpath) {
                boolean found = false;
                for (int i = 0; i < pathElm.length; ++i) {
                    if (!cpEntry.equals(pathElm[i])) continue;
                    found = true;
                    break;
                }
                if (found || !new File(cpEntry).exists()) continue;
                antLoader.addPathElement(cpEntry);
            }
        }
        return new GroovyClassLoader(parent, this.configuration);
    }
}

