/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.util.Node;
import groovy.xml.QName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class NodeList
extends ArrayList {
    public NodeList() {
    }

    public NodeList(Collection collection) {
        super(collection);
    }

    public NodeList(int size) {
        super(size);
    }

    private static void setMetaClass(MetaClass metaClass) {
        DelegatingMetaClass newMetaClass = new DelegatingMetaClass(metaClass){

            public Object getAttribute(Object object, String attribute) {
                NodeList nl = (NodeList)object;
                Iterator it = nl.iterator();
                ArrayList result = new ArrayList();
                while (it.hasNext()) {
                    Node node = (Node)it.next();
                    result.add(node.attributes().get(attribute));
                }
                return result;
            }

            public void setAttribute(Object object, String attribute, Object newValue) {
                NodeList nl = (NodeList)object;
                for (Node node : nl) {
                    node.attributes().put(attribute, newValue);
                }
            }

            public Object getProperty(Object object, String property) {
                if (object instanceof NodeList) {
                    NodeList nl = (NodeList)object;
                    return nl.getAt(property);
                }
                return super.getProperty(object, property);
            }
        };
        GroovySystem.getMetaClassRegistry().setMetaClass(NodeList.class, newMetaClass);
    }

    public NodeList getAt(String name) {
        NodeList answer = new NodeList();
        for (Object child : this) {
            if (!(child instanceof Node)) continue;
            Node childNode = (Node)child;
            Object temp = childNode.get(name);
            if (temp instanceof Collection) {
                answer.addAll((Collection)temp);
                continue;
            }
            answer.add(temp);
        }
        return answer;
    }

    public NodeList getAt(QName name) {
        NodeList answer = new NodeList();
        for (Object child : this) {
            if (!(child instanceof Node)) continue;
            Node childNode = (Node)child;
            NodeList temp = childNode.getAt(name);
            answer.addAll(temp);
        }
        return answer;
    }

    public String text() {
        String previousText = null;
        StringBuffer buffer = null;
        for (Object child : this) {
            String text = null;
            if (child instanceof String) {
                text = (String)child;
            } else if (child instanceof Node) {
                text = ((Node)child).text();
            }
            if (text == null) continue;
            if (previousText == null) {
                previousText = text;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer();
                buffer.append(previousText);
            }
            buffer.append(text);
        }
        if (buffer != null) {
            return buffer.toString();
        }
        if (previousText != null) {
            return previousText;
        }
        return "";
    }

    static {
        NodeList.setMetaClass(GroovySystem.getMetaClassRegistry().getMetaClass(NodeList.class));
    }
}

