/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class GroovyCollections {
    public static List combinations(Object[] lists) {
        return GroovyCollections.combinations(Arrays.asList(lists));
    }

    public static List combinations(Collection lists) {
        ArrayList combinations = new ArrayList();
        for (Object candidateList : lists) {
            List list = (List)DefaultTypeTransformation.castToType(candidateList, List.class);
            if (combinations.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    ArrayList l = new ArrayList();
                    l.add(list.get(i));
                    combinations.add(l);
                }
                continue;
            }
            ArrayList savedCombinations = new ArrayList(combinations);
            ArrayList newCombinations = new ArrayList();
            for (Object value : list) {
                Iterator combos = savedCombinations.iterator();
                while (combos.hasNext()) {
                    ArrayList oldlist = new ArrayList((List)combos.next());
                    oldlist.add(value);
                    newCombinations.add(oldlist);
                }
            }
            combinations = newCombinations;
        }
        return combinations;
    }

    public static List transpose(Object[] lists) {
        return GroovyCollections.transpose(Arrays.asList(lists));
    }

    public static List transpose(Collection lists) {
        List list;
        ArrayList result = new ArrayList();
        if (lists.isEmpty() || lists.size() == 0) {
            return result;
        }
        int minSize = Integer.MAX_VALUE;
        for (Object candidateList : lists) {
            list = (List)DefaultTypeTransformation.castToType(candidateList, List.class);
            if (list.size() >= minSize) continue;
            minSize = list.size();
        }
        if (minSize == 0) {
            return result;
        }
        for (int i = 0; i < minSize; ++i) {
            result.add(new ArrayList());
        }
        for (Object candidateList : lists) {
            list = (List)DefaultTypeTransformation.castToType(candidateList, List.class);
            for (int i = 0; i < minSize; ++i) {
                List resultList = (List)result.get(i);
                resultList.add(list.get(i));
            }
        }
        return result;
    }

    public static Object min(Object[] items) {
        return GroovyCollections.min(Arrays.asList(items));
    }

    public static Object min(Collection items) {
        Object answer = null;
        for (Object value : items) {
            if (value == null || answer != null && !ScriptBytecodeAdapter.compareLessThan(value, answer)) continue;
            answer = value;
        }
        return answer;
    }

    public static Object max(Object[] items) {
        return GroovyCollections.max(Arrays.asList(items));
    }

    public static Object max(Collection items) {
        Object answer = null;
        for (Object value : items) {
            if (value == null || answer != null && !ScriptBytecodeAdapter.compareGreaterThan(value, answer)) continue;
            answer = value;
        }
        return answer;
    }

    public static Object sum(Object[] items) {
        return DefaultGroovyMethods.sum(Arrays.asList(items));
    }

    public static Object sum(Collection items) {
        return DefaultGroovyMethods.sum(items);
    }
}

