/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.reflection.FastArray;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewStaticMetaMethod;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class MetaClassRegistryImpl
implements MetaClassRegistry {
    private boolean useAccessible;
    private FastArray instanceMethods = new FastArray();
    private FastArray staticMethods = new FastArray();
    private AtomicInteger version = new AtomicInteger();
    public static final int LOAD_DEFAULT = 0;
    public static final int DONT_LOAD_DEFAULT = 1;
    private static MetaClassRegistry instanceInclude;
    private static MetaClassRegistry instanceExclude;
    private MetaClassRegistry.MetaClassCreationHandle metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();

    public MetaClassRegistryImpl() {
        this(0, true);
    }

    public MetaClassRegistryImpl(int loadDefault) {
        this(loadDefault, true);
    }

    public MetaClassRegistryImpl(boolean useAccessible) {
        this(0, useAccessible);
    }

    public MetaClassRegistryImpl(int loadDefault, boolean useAccessible) {
        this.useAccessible = useAccessible;
        if (loadDefault == 0) {
            HashMap map = new HashMap();
            this.registerMethods(DefaultGroovyMethods.class, true, true, map);
            Class[] pluginDGMs = VMPluginFactory.getPlugin().getPluginDefaultGroovyMethods();
            for (int i = 0; i < pluginDGMs.length; ++i) {
                this.registerMethods(pluginDGMs[i], false, true, map);
            }
            this.registerMethods(DefaultGroovyStaticMethods.class, false, false, map);
            for (Map.Entry e : map.entrySet()) {
                CachedClass cls = (CachedClass)e.getKey();
                ArrayList list = (ArrayList)e.getValue();
                cls.setNewMopMethods(list);
            }
        }
        this.installMetaClassCreationHandle();
        MetaClass emcMetaClass = this.metaClassCreationHandle.create(ExpandoMetaClass.class, this);
        emcMetaClass.initialize();
        ClassInfo.getClassInfo(ExpandoMetaClass.class).setStrongMetaClass(emcMetaClass);
    }

    private void installMetaClassCreationHandle() {
        try {
            Class<?> customMetaClassHandle = Class.forName("groovy.runtime.metaclass.CustomMetaClassCreationHandle");
            Constructor<?> customMetaClassHandleConstructor = customMetaClassHandle.getConstructor(new Class[0]);
            this.metaClassCreationHandle = (MetaClassRegistry.MetaClassCreationHandle)customMetaClassHandleConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not instantiate custom Metaclass creation handle: " + e, e);
        }
    }

    private void registerMethods(Class theClass, boolean useMethodrapper, boolean useInstanceMethods, Map map) {
        CachedMethod[] methods = ReflectionCache.getCachedClass(theClass).getMethods();
        if (useMethodrapper) {
            int i = 0;
            while (true) {
                try {
                    String className = "org.codehaus.groovy.runtime.dgm$" + i;
                    Class<?> aClass = Class.forName(className);
                    this.createMetaMethodFromClass(map, aClass);
                }
                catch (ClassNotFoundException e) {
                    break;
                }
                ++i;
            }
            Class[] additionals = DefaultGroovyMethods.additionals;
            for (int i2 = 0; i2 != additionals.length; ++i2) {
                this.createMetaMethodFromClass(map, additionals[i2]);
            }
        } else {
            for (int i = 0; i < methods.length; ++i) {
                NewMetaMethod metaMethod;
                CachedClass[] paramTypes;
                CachedMethod method = methods[i];
                int mod = method.getModifiers();
                if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
                ArrayList<NewInstanceMetaMethod> arr = (ArrayList<NewInstanceMetaMethod>)map.get(paramTypes[0]);
                if (arr == null) {
                    arr = new ArrayList<NewInstanceMetaMethod>(4);
                    map.put(paramTypes[0], arr);
                }
                if (useInstanceMethods) {
                    metaMethod = new NewInstanceMetaMethod(method);
                    arr.add((NewInstanceMetaMethod)metaMethod);
                    this.instanceMethods.add(metaMethod);
                    continue;
                }
                metaMethod = new NewStaticMetaMethod(method);
                arr.add((NewInstanceMetaMethod)metaMethod);
                this.staticMethods.add(metaMethod);
            }
        }
    }

    private void createMetaMethodFromClass(Map map, Class aClass) {
        try {
            MetaMethod method = (MetaMethod)aClass.newInstance();
            CachedClass declClass = method.getDeclaringClass();
            ArrayList<MetaMethod> arr = (ArrayList<MetaMethod>)map.get(declClass);
            if (arr == null) {
                arr = new ArrayList<MetaMethod>(4);
                map.put(declClass, arr);
            }
            arr.add(method);
            this.instanceMethods.add(method);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MetaClass getMetaClass(Class theClass) {
        ClassInfo info = ClassInfo.getClassInfo(theClass);
        MetaClass answer = info.getMetaClassForClass();
        if (answer != null) {
            return answer;
        }
        info.lock();
        try {
            answer = info.getMetaClassForClass();
            if (answer != null) {
                MetaClass metaClass = answer;
                return metaClass;
            }
            answer = this.metaClassCreationHandle.create(theClass, this);
            answer.initialize();
            if (GroovySystem.isKeepJavaMetaClasses()) {
                info.setStrongMetaClass(answer);
            } else {
                info.setWeakMetaClass(answer);
            }
            MetaClass metaClass = answer;
            return metaClass;
        }
        finally {
            info.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaClass(Class theClass) {
        this.version.incrementAndGet();
        ClassInfo info = ClassInfo.getClassInfo(theClass);
        info.lock();
        try {
            info.setStrongMetaClass(null);
        }
        finally {
            info.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaClass(Class theClass, MetaClass theMetaClass) {
        this.version.incrementAndGet();
        ClassInfo info = ClassInfo.getClassInfo(theClass);
        info.lock();
        try {
            info.setStrongMetaClass(theMetaClass);
        }
        finally {
            info.unlock();
        }
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    public MetaClassRegistry.MetaClassCreationHandle getMetaClassCreationHandler() {
        return this.metaClassCreationHandle;
    }

    public void setMetaClassCreationHandle(MetaClassRegistry.MetaClassCreationHandle handle) {
        if (handle == null) {
            throw new IllegalArgumentException("Cannot set MetaClassCreationHandle to null value!");
        }
        this.metaClassCreationHandle = handle;
    }

    public static MetaClassRegistry getInstance(int includeExtension) {
        if (includeExtension != 1) {
            if (instanceInclude == null) {
                instanceInclude = new MetaClassRegistryImpl();
            }
            return instanceInclude;
        }
        if (instanceExclude == null) {
            instanceExclude = new MetaClassRegistryImpl(1);
        }
        return instanceExclude;
    }

    public FastArray getInstanceMethods() {
        return this.instanceMethods;
    }

    public FastArray getStaticMethods() {
        return this.staticMethods;
    }
}

