/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.callsite;

import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.callsite.MetaClassConstructorSite;
import org.codehaus.groovy.runtime.callsite.PogoInterceptableSite;
import org.codehaus.groovy.runtime.callsite.PogoMetaClassSite;
import org.codehaus.groovy.runtime.callsite.PojoMetaClassSite;
import org.codehaus.groovy.runtime.callsite.StaticMetaClassSite;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public abstract class CallSite {
    protected final int index;
    public final String name;
    protected final CallSiteArray array;
    public final AtomicInteger usage;

    public CallSite(CallSiteArray array, int index, String name) {
        this.name = name;
        this.index = index;
        this.array = array;
        this.usage = GroovyCategorySupport.getCategoryNameUsage(name);
    }

    public CallSite(CallSite prev) {
        this.name = prev.name;
        this.index = prev.index;
        this.array = prev.array;
        this.usage = prev.usage;
    }

    public Object invoke(Object receiver, Object[] args) {
        throw new UnsupportedOperationException();
    }

    public Object invokeBinop(Object receiver, Object arg) {
        if (receiver == null) {
            receiver = NullObject.getNullObject();
        }
        return this.invoke(receiver, new Object[]{arg});
    }

    public CallSite acceptCall(Object receiver, Object[] args) {
        throw new UnsupportedOperationException();
    }

    public CallSite acceptCurrent(Object receiver, Object[] args) {
        throw new UnsupportedOperationException();
    }

    public CallSite acceptCurrentTyped(Object receiver, Object[] args, Class[] types) {
        return this.acceptCurrent(receiver, args);
    }

    public CallSite acceptConstructor(Object receiver, Object[] args) {
        throw new UnsupportedOperationException();
    }

    public CallSite acceptStatic(Object receiver, Object[] args) {
        throw new UnsupportedOperationException();
    }

    public CallSite acceptBinop(Object receiver, Object arg) {
        try {
            Object[] args = new Object[]{arg};
            return this.acceptCall(receiver, args);
        }
        catch (NullPointerException e) {
            if (receiver == null) {
                return this.acceptBinop(NullObject.getNullObject(), arg);
            }
            throw e;
        }
    }

    public final Object callSafe(Object receiver, Object[] args) throws Throwable {
        if (receiver == null) {
            return null;
        }
        return this.acceptCall(receiver, args).invoke(receiver, args);
    }

    public Object call(Object receiver, Object[] args) {
        return this.acceptCall(receiver, args).invoke(receiver, args);
    }

    public Object callCurrent(Object receiver, Object[] args) throws Throwable {
        return this.acceptCurrent(receiver, args).invoke(receiver, args);
    }

    public Object callStatic(Object receiver, Object[] args) {
        return this.acceptStatic(receiver, args).invoke(receiver, args);
    }

    public Object callBinop(Object receiver, Object arg) {
        return this.acceptBinop(receiver, arg).invokeBinop(receiver, arg);
    }

    public final Object callConstructor(Object receiver, Object[] args) throws Throwable {
        return this.acceptConstructor(receiver, args).invoke(receiver, args);
    }

    final CallSite createCallStaticSite(Class receiver, Object[] args) {
        MetaClass metaClass = InvokerHelper.getMetaClass(receiver);
        CallSite site = metaClass instanceof MetaClassImpl ? ((MetaClassImpl)metaClass).createStaticSite(this, args) : new StaticMetaClassSite(this, metaClass);
        this.array.array[this.index] = site;
        return site;
    }

    protected final CallSite createCallConstructorSite(Class receiver, Object[] args) {
        MetaClass metaClass = InvokerHelper.getMetaClass(receiver);
        CallSite site = metaClass instanceof MetaClassImpl ? ((MetaClassImpl)metaClass).createConstructorSite(this, args) : new MetaClassConstructorSite(this, metaClass);
        this.array.array[this.index] = site;
        return site;
    }

    protected final CallSite createCallCurrentSite(Object receiver, Object[] args, Class sender) {
        MetaClass metaClass;
        CallSite site = receiver instanceof GroovyInterceptable ? new PogoInterceptableSite(this) : ((metaClass = ((GroovyObject)receiver).getMetaClass()) instanceof MetaClassImpl ? ((MetaClassImpl)metaClass).createPogoCallCurrentSite(this, sender, args) : new PogoMetaClassSite(this, metaClass));
        this.array.array[this.index] = site;
        return site;
    }

    final CallSite createPojoSite(Object receiver, Object[] args) {
        MetaClass metaClass = InvokerHelper.getMetaClass(receiver.getClass());
        if (this.usage.get() == 0 && metaClass instanceof MetaClassImpl) {
            return ((MetaClassImpl)metaClass).createPojoCallSite(this, receiver, args);
        }
        return new PojoMetaClassSite(this, metaClass);
    }

    final CallSite createPogoSite(Object receiver, Object[] args) {
        if (receiver instanceof GroovyInterceptable) {
            return new PogoInterceptableSite(this);
        }
        MetaClass metaClass = ((GroovyObject)receiver).getMetaClass();
        if (metaClass instanceof MetaClassImpl) {
            return ((MetaClassImpl)metaClass).createPogoCallSite(this, args);
        }
        return new PogoMetaClassSite(this, metaClass);
    }

    static boolean noCoerce(ParameterTypes metaMethod, Object[] args) {
        CachedClass[] paramClasses = metaMethod.getParameterTypes();
        if (paramClasses.length != args.length) {
            return false;
        }
        for (int i = 0; i < paramClasses.length; ++i) {
            CachedClass paramClass = paramClasses[i];
            if (args[i] == null || paramClass.isDirectlyAssignable(args[i])) continue;
            return true;
        }
        return false;
    }

    static boolean noWrappers(Object[] args) {
        for (int i = 0; i != args.length; ++i) {
            if (!(args[i] instanceof Wrapper)) continue;
            return false;
        }
        return true;
    }

    public boolean wantProvideCallSite() {
        return false;
    }

    protected final CallSite createCallSite(Object receiver, Object[] args) {
        if (receiver == null) {
            return new CallSite(this){

                public Object invoke(Object receiver, Object[] args) {
                    return InvokerHelper.invokeMethod(NullObject.getNullObject(), this.name, args);
                }
            };
        }
        CallSite site = receiver instanceof Class ? this.createCallStaticSite((Class)receiver, args) : (receiver instanceof GroovyObject ? this.createPogoSite(receiver, args) : this.createPojoSite(receiver, args));
        this.array.array[this.index] = site;
        return site;
    }

    public Object callGetProperty(Object receiver) {
        return this.acceptGetProperty(receiver).getProperty(receiver);
    }

    public Object callGroovyObjectGetProperty(Object receiver) {
        return this.acceptGroovyObjectGetProperty(receiver).getProperty(receiver);
    }

    public CallSite acceptGetProperty(Object receiver) {
        return this.createGetPropertySite(receiver);
    }

    public CallSite acceptGroovyObjectGetProperty(Object receiver) {
        return this.createGroovyObjectGetPropertySite(receiver);
    }

    protected final CallSite createGetPropertySite(Object receiver) {
        if (receiver instanceof GroovyObject) {
            return this.createGroovyObjectGetPropertySite(receiver);
        }
        if (receiver instanceof Class) {
            return this.createClassMetaClassGetPropertySite((Class)receiver);
        }
        return this.createPojoMetaClassGetPropertySite(receiver);
    }

    protected final CallSite createGroovyObjectGetPropertySite(Object receiver) {
        Class<?> aClass = receiver.getClass();
        try {
            Method method = aClass.getMethod("getProperty", String.class);
            if (method != null && method.isSynthetic()) {
                return this.createPogoMetaClassGetPropertySite((GroovyObject)receiver);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.createPogoGetPropertySite(aClass);
    }

    public Object getProperty(Object receiver) {
        throw new UnsupportedOperationException();
    }

    private CallSite createPojoMetaClassGetPropertySite(Object receiver) {
        MetaProperty effective;
        Class<?> aClass = receiver.getClass();
        MetaClass metaClass = InvokerHelper.getMetaClass(aClass);
        CallSite site = metaClass.getClass() != MetaClassImpl.class || GroovyCategorySupport.hasCategoryInCurrentThread() ? new PojoMetaClassGetPropertySite(this, metaClass) : ((effective = ((MetaClassImpl)metaClass).getEffectiveGetMetaProperty(aClass, receiver, this.name, false)) != null ? (effective instanceof CachedField ? new GetEffectivePojoFieldSite(this, metaClass, (CachedField)effective) : new GetEffectivePojoPropertySite(this, metaClass, effective)) : new PojoMetaClassGetPropertySite(this, metaClass));
        this.array.array[this.index] = site;
        return site;
    }

    private CallSite createClassMetaClassGetPropertySite(Class aClass) {
        ClassMetaClassGetPropertySite site = new ClassMetaClassGetPropertySite(this, aClass);
        this.array.array[this.index] = site;
        return site;
    }

    private CallSite createPogoMetaClassGetPropertySite(GroovyObject receiver) {
        MetaProperty effective;
        MetaClass metaClass = receiver.getMetaClass();
        CallSite site = metaClass.getClass() != MetaClassImpl.class || GroovyCategorySupport.hasCategoryInCurrentThread() ? new PogoMetaClassGetPropertySite(this, metaClass) : ((effective = ((MetaClassImpl)metaClass).getEffectiveGetMetaProperty(metaClass.getClass(), receiver, this.name, false)) != null ? (effective instanceof CachedField ? new GetEffectivePogoFieldSite(this, metaClass, (CachedField)effective) : new GetEffectivePogoPropertySite(this, metaClass, effective)) : new PogoMetaClassGetPropertySite(this, metaClass));
        this.array.array[this.index] = site;
        return site;
    }

    private CallSite createPogoGetPropertySite(Class aClass) {
        PogoGetPropertySite site = new PogoGetPropertySite(this, aClass);
        this.array.array[this.index] = site;
        return site;
    }

    public final Object callGetPropertySafe(Object receiver) {
        if (receiver == null) {
            return null;
        }
        return this.callGetProperty(receiver);
    }

    public final Object callGroovyObjectGetPropertySafe(Object receiver) {
        if (receiver == null) {
            return null;
        }
        return this.callGroovyObjectGetProperty(receiver);
    }

    private static class PogoGetPropertySite
    extends CallSite {
        private final Class aClass;

        public PogoGetPropertySite(CallSite parent, Class aClass) {
            super(parent);
            this.aClass = aClass;
        }

        public CallSite acceptGetProperty(Object receiver) {
            if (receiver.getClass() != this.aClass) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public CallSite acceptGroovyObjectGetProperty(Object receiver) {
            if (receiver.getClass() != this.aClass) {
                return this.createGroovyObjectGetPropertySite(receiver);
            }
            return this;
        }

        public Object getProperty(Object receiver) {
            return ((GroovyObject)receiver).getProperty(this.name);
        }
    }

    private static class PojoMetaClassGetPropertySite
    extends CallSite {
        private final MetaClass metaClass;

        public PojoMetaClassGetPropertySite(CallSite parent, MetaClass metaClass) {
            super(parent);
            this.metaClass = metaClass;
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (receiver.getClass() != this.metaClass.getTheClass()) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            return this.metaClass.getProperty(receiver, this.name);
        }
    }

    private static class PogoMetaClassGetPropertySite
    extends CallSite {
        private final MetaClass metaClass;

        public PogoMetaClassGetPropertySite(CallSite parent, MetaClass metaClass) {
            super(parent);
            this.metaClass = metaClass;
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (!(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final CallSite acceptGroovyObjectGetProperty(Object receiver) {
            if (!(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGroovyObjectGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            return this.metaClass.getProperty(receiver, this.name);
        }
    }

    private static class ClassMetaClassGetPropertySite
    extends CallSite {
        final MetaClass metaClass;
        private final Class aClass;

        public ClassMetaClassGetPropertySite(CallSite parent, Class aClass) {
            super(parent);
            this.aClass = aClass;
            this.metaClass = InvokerHelper.getMetaClass(aClass);
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (receiver != this.aClass) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            return this.metaClass.getProperty(this.aClass, this.name);
        }
    }

    private static class GetEffectivePojoFieldSite
    extends CallSite {
        private final MetaClass metaClass;
        private final Field effective;

        public GetEffectivePojoFieldSite(CallSite site, MetaClass metaClass, CachedField effective) {
            super(site);
            this.metaClass = metaClass;
            this.effective = effective.field;
        }

        public final Object callGetProperty(Object receiver) {
            return this.acceptGetProperty(receiver).getProperty(receiver);
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || receiver.getClass() != this.metaClass.getTheClass()) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            try {
                return this.effective.get(receiver);
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", e);
            }
        }
    }

    private static class GetEffectivePogoFieldSite
    extends CallSite {
        private final MetaClass metaClass;
        private final Field effective;

        public GetEffectivePogoFieldSite(CallSite site, MetaClass metaClass, CachedField effective) {
            super(site);
            this.metaClass = metaClass;
            this.effective = effective.field;
        }

        public final Object callGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver).getProperty(receiver);
            }
            return this.getProperty(receiver);
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final Object callGroovyObjectGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGroovyObjectGetPropertySite(receiver).getProperty(receiver);
            }
            return this.getProperty(receiver);
        }

        public final CallSite acceptGroovyObjectGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGroovyObjectGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            try {
                return this.effective.get(receiver);
            }
            catch (IllegalAccessException e) {
                throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", e);
            }
        }
    }

    private static class GetEffectivePojoPropertySite
    extends CallSite {
        private final MetaClass metaClass;
        private final MetaProperty effective;

        public GetEffectivePojoPropertySite(CallSite site, MetaClass metaClass, MetaProperty effective) {
            super(site);
            this.metaClass = metaClass;
            this.effective = effective;
        }

        public final Object callGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || receiver.getClass() != this.metaClass.getTheClass()) {
                return this.createGetPropertySite(receiver).getProperty(receiver);
            }
            return this.effective.getProperty(receiver);
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            return this.effective.getProperty(receiver);
        }
    }

    private static class GetEffectivePogoPropertySite
    extends CallSite {
        private final MetaClass metaClass;
        private final MetaProperty effective;

        public GetEffectivePogoPropertySite(CallSite site, MetaClass metaClass, MetaProperty effective) {
            super(site);
            this.metaClass = metaClass;
            this.effective = effective;
        }

        public final Object callGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver).getProperty(receiver);
            }
            return this.effective.getProperty(receiver);
        }

        public final CallSite acceptGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver);
            }
            return this;
        }

        public final Object callGroovyObjectGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGetPropertySite(receiver).getProperty(receiver);
            }
            return this.effective.getProperty(receiver);
        }

        public final CallSite acceptGroovyObjectGetProperty(Object receiver) {
            if (GroovyCategorySupport.hasCategoryInCurrentThread() || !(receiver instanceof GroovyObject) || ((GroovyObject)receiver).getMetaClass() != this.metaClass) {
                return this.createGroovyObjectGetPropertySite(receiver);
            }
            return this;
        }

        public final Object getProperty(Object receiver) {
            return this.effective.getProperty(receiver);
        }
    }

    public static class DummyCallSite
    extends CallSite {
        public DummyCallSite(CallSiteArray array, int index, String name) {
            super(array, index, name);
        }

        public Object invoke(Object receiver, Object[] args) {
            return null;
        }

        public final CallSite acceptCall(Object receiver, Object[] args) {
            return this.createCallSite(receiver, args);
        }

        public final CallSite acceptCurrent(Object receiver, Object[] args) {
            return this.createCallCurrentSite(receiver, args, this.array.owner);
        }

        public final CallSite acceptConstructor(Object receiver, Object[] args) {
            return this.createCallConstructorSite((Class)receiver, args);
        }

        public final CallSite acceptStatic(Object receiver, Object[] args) {
            return this.createCallStaticSite((Class)receiver, args);
        }
    }
}

