/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection.stdclasses;

import groovy.lang.GString;
import java.math.BigDecimal;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class ArrayCachedClass
extends CachedClass {
    public ArrayCachedClass(Class klazz, ClassInfo classInfo) {
        super(klazz, classInfo);
    }

    public Object coerceArgument(Object argument) {
        Class<?> argumentClass = argument.getClass();
        if (argumentClass.getName().charAt(0) != '[') {
            return argument;
        }
        Class<?> argumentComponent = argumentClass.getComponentType();
        Class<?> paramComponent = this.getTheClass().getComponentType();
        if (paramComponent.isPrimitive()) {
            if (paramComponent == Boolean.TYPE && argumentClass == Boolean[].class) {
                argument = DefaultTypeTransformation.convertToBooleanArray(argument);
            } else if (paramComponent == Byte.TYPE && argumentClass == Byte[].class) {
                argument = DefaultTypeTransformation.convertToByteArray(argument);
            } else if (paramComponent == Character.TYPE && argumentClass == Character[].class) {
                argument = DefaultTypeTransformation.convertToCharArray(argument);
            } else if (paramComponent == Short.TYPE && argumentClass == Short[].class) {
                argument = DefaultTypeTransformation.convertToShortArray(argument);
            } else if (paramComponent == Integer.TYPE && argumentClass == Integer[].class) {
                argument = DefaultTypeTransformation.convertToIntArray(argument);
            } else if (paramComponent == Long.TYPE && (argumentClass == Long[].class || argumentClass == Integer[].class)) {
                argument = DefaultTypeTransformation.convertToLongArray(argument);
            } else if (paramComponent == Float.TYPE && (argumentClass == Float[].class || argumentClass == Integer[].class)) {
                argument = DefaultTypeTransformation.convertToFloatArray(argument);
            } else if (paramComponent == Double.TYPE && (argumentClass == Double[].class || argumentClass == Float[].class || BigDecimal[].class.isAssignableFrom(argumentClass))) {
                argument = DefaultTypeTransformation.convertToDoubleArray(argument);
            }
        } else if (paramComponent == String.class && argument instanceof GString[]) {
            GString[] strings = (GString[])argument;
            String[] ret = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ret[i] = strings[i].toString();
            }
            argument = ret;
        } else if (paramComponent == Object.class && argumentComponent.isPrimitive()) {
            argument = DefaultTypeTransformation.primitiveArrayBox(argument);
        }
        return argument;
    }
}

