/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.LazySoftReference;
import org.codehaus.groovy.reflection.LockableObject;
import org.codehaus.groovy.reflection.stdclasses.ArrayCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigDecimalCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigIntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BooleanCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ByteCachedClass;
import org.codehaus.groovy.reflection.stdclasses.CharacterCachedClass;
import org.codehaus.groovy.reflection.stdclasses.DoubleCachedClass;
import org.codehaus.groovy.reflection.stdclasses.FloatCachedClass;
import org.codehaus.groovy.reflection.stdclasses.IntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.LongCachedClass;
import org.codehaus.groovy.reflection.stdclasses.NumberCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ObjectCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ShortCachedClass;
import org.codehaus.groovy.reflection.stdclasses.StringCachedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends SoftReference<Class> {
    private final LazyCachedClassRef cachedClassRef;
    private MetaClass strongMetaClass;
    private SoftReference<MetaClass> weakMetaClass;
    private static final Object NONE = new Object();
    private volatile int version;
    private ExpandoMetaClass modifiedExpando;
    private final LazySoftReference staticMetaClassField;
    private static final HashSet<ClassInfo> modifiedExpandos = new HashSet();
    private final LockableObject lock = new LockableObject();
    MetaMethod[] dgmMetaMethods = CachedClass.EMPTY;
    MetaMethod[] newMetaMethods = CachedClass.EMPTY;
    public final int hash;
    public ClassInfo next;
    private static final ClassSet globalClassSet = new ClassSet();
    private static final ThreadLocal<LocalMap> localMap = new ThreadLocal<LocalMap>(){
        LocalMap recentThreadMap;

        @Override
        protected LocalMap initialValue() {
            return new LocalMap();
        }

        @Override
        public LocalMap get() {
            LocalMap res;
            LocalMap recent = this.recentThreadMap;
            if (recent != null && recent.myThread == Thread.currentThread()) {
                return recent;
            }
            this.recentThreadMap = res = (LocalMap)super.get();
            return res;
        }
    };

    ClassInfo(Class klazz, int hash, ClassInfo next) {
        super(klazz);
        this.next = next;
        this.hash = hash;
        this.cachedClassRef = new LazyCachedClassRef(this);
        this.staticMetaClassField = new LazyStaticMetaClassFieldRef(this);
    }

    ClassInfo(ClassInfo src, ClassInfo next) {
        super(src.get());
        this.next = next;
        this.hash = src.hash;
        this.cachedClassRef = new LazyCachedClassRef(this, src);
        this.weakMetaClass = src.weakMetaClass;
        this.strongMetaClass = src.strongMetaClass;
        this.version = src.version;
        this.modifiedExpando = src.modifiedExpando;
        this.staticMetaClassField = new LazyStaticMetaClassFieldRef(this);
        this.dgmMetaMethods = src.dgmMetaMethods;
        this.newMetaMethods = src.newMetaMethods;
    }

    public int getVersion() {
        return this.version;
    }

    public ExpandoMetaClass getModifiedExpando() {
        return this.modifiedExpando;
    }

    public void setModifiedExpando(ExpandoMetaClass modifiedExpando) {
        this.modifiedExpando = modifiedExpando;
        if (modifiedExpando != null) {
            modifiedExpandos.add(this);
        }
    }

    public static void clearModifiedExpandos() {
        for (ClassInfo info : modifiedExpandos) {
            info.setModifiedExpando(null);
        }
        modifiedExpandos.clear();
    }

    public CachedClass getCachedClass() {
        return (CachedClass)this.cachedClassRef.get();
    }

    public static ClassInfo getClassInfo(Class cls) {
        return localMap.get().get(cls);
    }

    public MetaClass getStrongMetaClass() {
        return this.strongMetaClass;
    }

    public void setStrongMetaClass(MetaClass answer) {
        ++this.version;
        this.strongMetaClass = answer;
        this.weakMetaClass = null;
        this.updateMetaClass();
    }

    private void updateMetaClass() {
        Object smf = this.staticMetaClassField.get();
        if (smf != null && smf != NONE) {
            ((CachedField)smf).setProperty(null, null);
        }
    }

    public MetaClass getWeakMetaClass() {
        return this.weakMetaClass == null ? null : this.weakMetaClass.get();
    }

    public void setWeakMetaClass(MetaClass answer) {
        ++this.version;
        this.strongMetaClass = null;
        this.weakMetaClass = answer == null ? null : new SoftReference<MetaClass>(answer);
        this.updateMetaClass();
    }

    public MetaClass getMetaClassForClass() {
        return this.strongMetaClass != null ? this.strongMetaClass : (this.weakMetaClass == null ? null : this.weakMetaClass.get());
    }

    public static int size() {
        return globalClassSet.size();
    }

    public static int fullSize() {
        return globalClassSet.fullSize();
    }

    private static CachedClass createCachedClass(Class klazz, ClassInfo classInfo) {
        if (klazz == Object.class) {
            return new ObjectCachedClass(classInfo);
        }
        if (klazz == String.class) {
            return new StringCachedClass(classInfo);
        }
        CachedClass cachedClass = Number.class.isAssignableFrom(klazz) || klazz.isPrimitive() ? (klazz == Number.class ? new NumberCachedClass(klazz, classInfo) : (klazz == Integer.class || klazz == Integer.TYPE ? new IntegerCachedClass(klazz, classInfo) : (klazz == Double.class || klazz == Double.TYPE ? new DoubleCachedClass(klazz, classInfo) : (klazz == BigDecimal.class ? new BigDecimalCachedClass(klazz, classInfo) : (klazz == Long.class || klazz == Long.TYPE ? new LongCachedClass(klazz, classInfo) : (klazz == Float.class || klazz == Float.TYPE ? new FloatCachedClass(klazz, classInfo) : (klazz == Short.class || klazz == Short.TYPE ? new ShortCachedClass(klazz, classInfo) : (klazz == Boolean.TYPE ? new BooleanCachedClass(klazz, classInfo) : (klazz == Character.TYPE ? new CharacterCachedClass(klazz, classInfo) : (klazz == BigInteger.class ? new BigIntegerCachedClass(klazz, classInfo) : (klazz == Byte.class ? new ByteCachedClass(klazz, classInfo) : new CachedClass(klazz, classInfo)))))))))))) : (klazz.getName().charAt(0) == '[' ? new ArrayCachedClass(klazz, classInfo) : (klazz == Boolean.class ? new BooleanCachedClass(klazz, classInfo) : (klazz == Character.class ? new CharacterCachedClass(klazz, classInfo) : new CachedClass(klazz, classInfo))));
        return cachedClass;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    private static class LazyStaticMetaClassFieldRef
    extends LazySoftReference {
        private final ClassInfo info;

        LazyStaticMetaClassFieldRef(ClassInfo info) {
            this.info = info;
        }

        public Object initValue() {
            CachedField[] cachedFields;
            CachedClass aClass = this.info.getCachedClass();
            for (CachedField cachedField : cachedFields = aClass.getFields()) {
                if (!cachedField.getName().startsWith("$staticMetaClass") || cachedField.getType() != SoftReference.class || !cachedField.isStatic()) continue;
                return cachedField;
            }
            return NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyCachedClassRef
    extends LazySoftReference<CachedClass> {
        private final ClassInfo info;

        LazyCachedClassRef(ClassInfo info) {
            this.info = info;
        }

        LazyCachedClassRef(ClassInfo info, ClassInfo src) {
            this.info = info;
            CachedClass cc = (CachedClass)src.cachedClassRef.getNullable();
            if (cc != null) {
                cc.classInfo = info;
                this.set(cc);
            }
        }

        @Override
        public CachedClass initValue() {
            return ClassInfo.createCachedClass((Class)this.info.get(), this.info);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalMap
    extends HashMap<Class, ClassInfo> {
        private static final int CACHE_SIZE = 5;
        public final Thread myThread = Thread.currentThread();
        private int nextCacheEntry;
        private final ClassInfo[] cache = new ClassInfo[5];
        private static final ClassInfo NOINFO = new ClassInfo(null, 0, null);

        private LocalMap() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = NOINFO;
            }
        }

        public ClassInfo get(Class key) {
            ClassInfo info = this.getFromCache(key);
            if (info != null) {
                return info;
            }
            info = (ClassInfo)super.get(key);
            if (info != null) {
                return this.putToCache(info);
            }
            return this.putToCache(globalClassSet.get(key));
        }

        private ClassInfo getFromCache(Class klazz) {
            int i = 0;
            int k = this.nextCacheEntry - 1;
            while (i < this.cache.length) {
                ClassInfo info;
                if (k < 0) {
                    k += 5;
                }
                if (klazz == (info = this.cache[k]).get()) {
                    this.nextCacheEntry = k + 1;
                    if (this.nextCacheEntry == 5) {
                        this.nextCacheEntry = 0;
                    }
                    return info;
                }
                ++i;
                --k;
            }
            return null;
        }

        private ClassInfo putToCache(ClassInfo classInfo) {
            this.cache[this.nextCacheEntry++] = classInfo;
            if (this.nextCacheEntry == 5) {
                this.nextCacheEntry = 0;
            }
            return classInfo;
        }
    }

    public static class ClassSet {
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final int MAX_SEGMENTS = 65536;
        static final int RETRIES_BEFORE_LOCK = 2;
        final int segmentMask;
        final int segmentShift;
        final Segment[] segments;

        public ClassSet() {
            int cap;
            int ssize;
            int sshift = 0;
            for (ssize = 1; ssize < 16; ssize <<= 1) {
                ++sshift;
            }
            this.segmentShift = 32 - sshift;
            this.segmentMask = ssize - 1;
            this.segments = new Segment[ssize];
            int c = 512 / ssize;
            if (c * ssize < 512) {
                ++c;
            }
            for (cap = 1; cap < c; cap <<= 1) {
            }
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(cap);
            }
        }

        static int hash(Class x) {
            int h = x.getName().hashCode();
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        final Segment segmentFor(int hash) {
            return this.segments[hash >>> this.segmentShift & this.segmentMask];
        }

        public int fullSize() {
            int count = 0;
            for (int i = 0; i < this.segments.length; ++i) {
                for (int j = 0; j < this.segments[i].table.length; ++j) {
                    ClassInfo e = this.segments[i].table[j];
                    while (e != null) {
                        ++count;
                        e = e.next;
                    }
                }
            }
            return count;
        }

        public int size() {
            int count = 0;
            for (int i = 0; i < this.segments.length; ++i) {
                for (int j = 0; j < this.segments[i].table.length; ++j) {
                    ClassInfo e = this.segments[i].table[j];
                    while (e != null) {
                        if (e.get() != null) {
                            ++count;
                        }
                        e = e.next;
                    }
                }
            }
            return count;
        }

        public ClassInfo get(Class key) {
            int hash = ClassSet.hash(key);
            return this.segmentFor(hash).get(key, hash);
        }

        public ClassInfo get(Class key, int hash) {
            return this.segmentFor(hash).get(key, hash);
        }

        static final class Segment
        extends LockableObject {
            volatile int count;
            int threshold;
            volatile ClassInfo[] table;

            Segment(int initialCapacity) {
                this.setTable(new ClassInfo[initialCapacity]);
            }

            void setTable(ClassInfo[] newTable) {
                this.threshold = (int)((float)newTable.length * 0.75f);
                this.table = newTable;
            }

            ClassInfo getFirst(int hash) {
                ClassInfo[] tab = this.table;
                return tab[hash & tab.length - 1];
            }

            ClassInfo get(Class key, int hash) {
                ClassInfo e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && e.get() == key) {
                        return e;
                    }
                    e = e.next;
                }
                return this.put(key, hash);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            ClassInfo put(Class key, int hash) {
                this.lock();
                try {
                    ClassInfo first;
                    int c = this.count;
                    if (c++ > this.threshold) {
                        this.rehash();
                    }
                    ClassInfo[] tab = this.table;
                    int index = hash & tab.length - 1;
                    ClassInfo e = first = tab[index];
                    while (e != null) {
                        if (e.hash == hash && e.get() == key) {
                            ClassInfo classInfo = e;
                            return classInfo;
                        }
                        e = e.next;
                    }
                    tab[index] = e = new ClassInfo(key, hash, first);
                    this.count = c;
                    ClassInfo classInfo = e;
                    return classInfo;
                }
                finally {
                    this.unlock();
                }
            }

            void rehash() {
                ClassInfo[] oldTable = this.table;
                int oldCapacity = oldTable.length;
                if (oldCapacity >= 0x40000000) {
                    return;
                }
                int newCount = 0;
                for (int i = 0; i < oldCapacity; ++i) {
                    ClassInfo first = null;
                    ClassInfo e = oldTable[i];
                    while (e != null) {
                        if (e.get() != null) {
                            if (first == null) {
                                first = e;
                            }
                            ClassInfo ee = e.next;
                            while (ee != null && ee.get() == null) {
                                ee = ee.next;
                            }
                            e.next = ee;
                            e = ee;
                            ++newCount;
                            continue;
                        }
                        e = e.next;
                    }
                    oldTable[i] = first;
                }
                if (newCount + 1 < this.threshold) {
                    this.count = newCount;
                    return;
                }
                ClassInfo[] newTable = new ClassInfo[oldCapacity << 1];
                int sizeMask = newTable.length - 1;
                newCount = 0;
                for (int i = 0; i < oldCapacity; ++i) {
                    ClassInfo e = oldTable[i];
                    while (e != null) {
                        int idx = e.hash & sizeMask;
                        ClassInfo next = newTable[idx];
                        newTable[idx] = next == null && e.next == null ? e : new ClassInfo(e, next);
                        ++newCount;
                        e = e.next;
                    }
                }
                this.threshold = (int)((float)newTable.length * 0.75f);
                this.table = newTable;
                this.count = newCount;
            }
        }
    }
}

