/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import groovyjarjarasm.asm.ClassWriter;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.LinkedBlockingQueue;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.PogoMetaMethodSite;
import org.codehaus.groovy.runtime.metaclass.MethodHelper;

public class CachedMethod
extends MetaMethod
implements Comparable,
Opcodes {
    public final CachedClass cachedClass;
    private final Method cachedMethod;
    private int methodIndex;
    private int hashCode;
    private static MyComparator comparator = new MyComparator();
    private SoftReference<Constructor> pogoCallSiteConstructor;
    private SoftReference<Constructor> pojoCallSiteConstructor;
    private SoftReference<Constructor> staticCallSiteConstructor;
    private WeakReference staticMetaMethodLoader;

    public CachedMethod(CachedClass clazz, Method method) {
        this.cachedMethod = method;
        this.cachedClass = clazz;
    }

    public CachedMethod(Method method) {
        this(ReflectionCache.getCachedClass(method.getDeclaringClass()), method);
    }

    public static CachedMethod find(Method method) {
        CachedMethod[] methods = ReflectionCache.getCachedClass(method.getDeclaringClass()).getMethods();
        int i = Arrays.binarySearch(methods, method, comparator);
        if (i < 0) {
            return null;
        }
        return methods[i];
    }

    protected Class[] getPT() {
        return this.cachedMethod.getParameterTypes();
    }

    public String getName() {
        return this.cachedMethod.getName();
    }

    public String getDescriptor() {
        return BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
    }

    public CachedClass getDeclaringClass() {
        return this.cachedClass;
    }

    public final Object invoke(Object object, Object[] arguments) {
        try {
            return this.cachedMethod.invoke(object, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvokerInvocationException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
    }

    public ParameterTypes getParamTypes() {
        return null;
    }

    public Class getReturnType() {
        return this.cachedMethod.getReturnType();
    }

    public int getParamsCount() {
        return this.getParameterTypes().length;
    }

    public int getModifiers() {
        return this.cachedMethod.getModifiers();
    }

    public String getSignature() {
        return this.getName() + this.getDescriptor();
    }

    public final Method setAccessible() {
        return this.cachedMethod;
    }

    public boolean isStatic() {
        return MethodHelper.isStatic(this.cachedMethod);
    }

    public void setMethodIndex(int i) {
        this.methodIndex = i;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public boolean canBeCalledByReflector() {
        if (!Modifier.isPublic(this.cachedClass.getModifiers())) {
            return false;
        }
        if (!Modifier.isPublic(this.getModifiers())) {
            return false;
        }
        this.getParameterTypes();
        for (int i = 0; i != this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i].isPrimitive || Modifier.isPublic(this.parameterTypes[i].getModifiers())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof CachedMethod) {
            return this.compareToCachedMethod((CachedMethod)o);
        }
        return this.compareToMethod((Method)o);
    }

    private int compareToCachedMethod(CachedMethod m) {
        CachedClass[] mparams;
        if (m == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i = 0; i != params.length; ++i) {
            int nameComp = params[i].getName().compareTo(mparams[i].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        throw new RuntimeException("Should never happen");
    }

    private int compareToMethod(Method m) {
        Class<?>[] mparams;
        if (m == null) {
            return -1;
        }
        int strComp = this.getName().compareTo(m.getName());
        if (strComp != 0) {
            return strComp;
        }
        int retComp = this.getReturnType().getName().compareTo(m.getReturnType().getName());
        if (retComp != 0) {
            return retComp;
        }
        CachedClass[] params = this.getParameterTypes();
        int pd = params.length - (mparams = m.getParameterTypes()).length;
        if (pd != 0) {
            return pd;
        }
        for (int i = 0; i != params.length; ++i) {
            int nameComp = params[i].getName().compareTo(mparams[i].getName());
            if (nameComp == 0) continue;
            return nameComp;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof CachedMethod && this.cachedMethod.equals(((CachedMethod)o).cachedMethod) || o instanceof Method && this.cachedMethod.equals(o);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.cachedMethod.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = -889274690;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return this.cachedMethod.toString();
    }

    private byte[] genPogoMetaMethodSite(ClassWriter cw, String name) {
        cw.visit(48, 1, name.replace('.', '/'), null, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/codehaus/groovy/runtime/callsite/CallSite;Lgroovy/lang/MetaClassImpl;Lgroovy/lang/MetaMethod;[Ljava/lang/Class;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(183, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", "<init>", "(Lorg/codehaus/groovy/runtime/callsite/CallSite;Lgroovy/lang/MetaClassImpl;Lgroovy/lang/MetaMethod;[Ljava/lang/Class;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "callCurrent", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Throwable"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", "checkCall", "(Ljava/lang/Object;[Ljava/lang/Object;)Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        BytecodeHelper helper = new BytecodeHelper(mv);
        Class callClass = this.getDeclaringClass().getTheClass();
        boolean useInterface = callClass.isInterface();
        String type = BytecodeHelper.getClassInternalName(callClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
        if (this.isStatic()) {
            this.genLoadParameters(2, mv, helper);
            mv.visitMethodInsn(184, type, this.getName(), descriptor);
        } else {
            mv.visitVarInsn(25, 1);
            helper.doCast(callClass);
            this.genLoadParameters(2, mv, helper);
            mv.visitMethodInsn(useInterface ? 185 : 182, type, this.getName(), descriptor);
        }
        helper.box(this.getReturnType());
        if (this.getReturnType() == Void.TYPE) {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", "array", "Lorg/codehaus/groovy/runtime/callsite/CallSiteArray;");
        mv.visitFieldInsn(180, "org/codehaus/groovy/runtime/callsite/CallSiteArray", "owner", "Ljava/lang/Class;");
        mv.visitMethodInsn(182, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", "createCallCurrentSite", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/Class;)Lorg/codehaus/groovy/runtime/callsite/CallSite;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/codehaus/groovy/runtime/callsite/CallSite", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "call", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Throwable"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", "checkCall", "(Ljava/lang/Object;[Ljava/lang/Object;)Z");
        l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        helper = new BytecodeHelper(mv);
        callClass = this.getDeclaringClass().getTheClass();
        useInterface = callClass.isInterface();
        type = BytecodeHelper.getClassInternalName(callClass.getName());
        descriptor = BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
        if (this.isStatic()) {
            this.genLoadParameters(2, mv, helper);
            mv.visitMethodInsn(184, type, this.getName(), descriptor);
        } else {
            mv.visitVarInsn(25, 1);
            helper.doCast(callClass);
            this.genLoadParameters(2, mv, helper);
            mv.visitMethodInsn(useInterface ? 185 : 182, type, this.getName(), descriptor);
        }
        helper.box(this.getReturnType());
        if (this.getReturnType() == Void.TYPE) {
            mv.visitInsn(1);
        }
        mv.visitInsn(176);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/codehaus/groovy/runtime/callsite/PogoMetaMethodSite", "createCallSite", "(Ljava/lang/Object;[Ljava/lang/Object;)Lorg/codehaus/groovy/runtime/callsite/CallSite;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "org/codehaus/groovy/runtime/callsite/CallSite", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
        mv = cw.visitMethod(17, "wantProvideCallSite", "()Z", null, null);
        mv.visitCode();
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        return bytes;
    }

    public PogoMetaMethodSite createPogoMetaMethodSite(CallSite site, MetaClassImpl metaClass, Class[] params) {
        Constructor constructor;
        if (this.pogoCallSiteConstructor != null && (constructor = this.pogoCallSiteConstructor.get()) != null) {
            try {
                return (PogoMetaMethodSite)constructor.newInstance(site, metaClass, this, params);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (InstantiationException e) {
                // empty catch block
            }
        }
        return new PogoMetaMethodSite.PogoCachedMethodSiteNoUnwrapNoCoerce(site, metaClass, this, params);
    }

    private byte[] genStaticMetaMethodSite(ClassWriter cw, String name) {
        cw.visit(48, 1, name, null, "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/codehaus/groovy/runtime/callsite/CallSite;Lgroovy/lang/MetaClassImpl;Lgroovy/lang/MetaMethod;[Ljava/lang/Class;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(183, "org/codehaus/groovy/runtime/callsite/StaticMetaMethodSite", "<init>", "(Lorg/codehaus/groovy/runtime/callsite/CallSite;Lgroovy/lang/MetaClassImpl;Lgroovy/lang/MetaMethod;[Ljava/lang/Class;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(17, "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        this.genInvokeMethod(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        return bytes;
    }

    public boolean hasPogoCallSiteConstructor() {
        return this.pogoCallSiteConstructor != null && this.pogoCallSiteConstructor.get() != null;
    }

    protected void genInvokeMethod(MethodVisitor mv) {
        BytecodeHelper helper = new BytecodeHelper(mv);
        Class callClass = this.getDeclaringClass().getTheClass();
        boolean useInterface = callClass.isInterface();
        String type = BytecodeHelper.getClassInternalName(callClass.getName());
        String descriptor = BytecodeHelper.getMethodDescriptor(this.getReturnType(), this.getNativeParameterTypes());
        if (this.isStatic()) {
            this.genLoadParameters(2, mv, helper);
            mv.visitMethodInsn(184, type, this.getName(), descriptor);
        } else {
            mv.visitVarInsn(25, 1);
            helper.doCast(callClass);
            this.genLoadParameters(2, mv, helper);
            mv.visitMethodInsn(useInterface ? 185 : 182, type, this.getName(), descriptor);
        }
        helper.box(this.getReturnType());
        if (this.getReturnType() == Void.TYPE) {
            mv.visitInsn(1);
        }
    }

    protected void genLoadParameters(int argumentIndex, MethodVisitor mv, BytecodeHelper helper) {
        CachedClass[] parameters = this.getParameterTypes();
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            mv.visitVarInsn(25, argumentIndex);
            helper.pushConstant(i);
            mv.visitInsn(50);
            Class type = parameters[i].getTheClass();
            if (type.isPrimitive()) {
                helper.unbox(type);
                continue;
            }
            helper.doCast(type);
        }
    }

    private boolean isCompilable() {
        if (this.getName().startsWith("java.")) {
            return this.isPublic() && this.publicParams();
        }
        return this.isPublic() && this.publicParams();
    }

    private boolean publicParams() {
        for (Class nativeParamType : this.nativeParamTypes) {
            if (Modifier.isPublic(nativeParamType.getModifiers())) continue;
            return false;
        }
        return true;
    }

    private static class MyClassLoader
    extends ClassLoader {
        final Class cls;

        private MyClassLoader(ClassLoader parent, String name, byte[] bytes) {
            super(parent);
            this.cls = this.defineClass(name, bytes, 0, bytes.length);
            this.resolveClass(this.cls);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("org.codehaus.groovy.runtime") || name.startsWith("groovy.lang")) {
                return this.getClass().getClassLoader().loadClass(name);
            }
            return super.loadClass(name, resolve);
        }
    }

    private static class CompileThread
    extends Thread {
        static final LinkedBlockingQueue queue = new LinkedBlockingQueue();

        private CompileThread() {
            this.setDaemon(true);
        }

        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        CachedMethod method;
                        if ((method = (CachedMethod)queue.take()) == null) {
                            continue;
                        }
                        ClassWriter cw = new ClassWriter(true);
                        CachedClass declClass = method.getDeclaringClass();
                        Class acls = declClass.getTheClass();
                        String name = declClass.getName().startsWith("java.") ? acls.getName().replace('.', '_') + "$" + method.getName() : declClass.getName() + "$" + method.getName();
                        byte[] bytes = method.genPogoMetaMethodSite(cw, name);
                        Class pogoSiteClass = new MyClassLoader((ClassLoader)acls.getClassLoader(), (String)name, (byte[])bytes).cls;
                        if (pogoSiteClass == null) continue;
                        try {
                            Constructor constructor = pogoSiteClass.getConstructor(CallSite.class, MetaClassImpl.class, MetaMethod.class, Class[].class);
                            method.pogoCallSiteConstructor = new SoftReference(constructor);
                            continue block4;
                        }
                        catch (NoSuchMethodException e) {
                            method.pogoCallSiteConstructor = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }

        public static void addMethod(CachedMethod method) {
            try {
                queue.put(method);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class MyComparator
    implements Comparator {
        private MyComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CachedMethod) {
                return ((CachedMethod)o1).compareTo(o2);
            }
            if (o2 instanceof CachedMethod) {
                return -((CachedMethod)o2).compareTo(o1);
            }
            throw new ClassCastException("One of the two comperables must be a CachedMethod");
        }
    }
}

