/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import groovy.lang.MetaProperty;
import groovy.util.AbstractFactory;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;

public class ObjectGraphBuilder
extends FactoryBuilderSupport {
    public static final String NODE_CLASS = "_NODE_CLASS_";
    public static final String NODE_NAME = "_NODE_NAME_";
    public static final String OBJECT_ID = "_OBJECT_ID_";
    private ChildPropertySetter childPropertySetter;
    private ClassNameResolver classNameResolver;
    private IdentifierResolver identifierResolver;
    private NewInstanceResolver newInstanceResolver;
    private ObjectFactory objectFactory = new ObjectFactory();
    private ObjectRefFactory objectRefFactory = new ObjectRefFactory();
    private ReferenceResolver referenceResolver;
    private RelationNameResolver relationNameResolver;
    private Map resolvedClasses = new HashMap();
    private ClassLoader classLoader;

    public ObjectGraphBuilder() {
        this.classNameResolver = new DefaultClassNameResolver();
        this.newInstanceResolver = new DefaultNewInstanceResolver();
        this.relationNameResolver = new DefaultRelationNameResolver();
        this.childPropertySetter = new DefaultChildPropertySetter();
        this.identifierResolver = new DefaultIdentifierResolver();
        this.referenceResolver = new DefaultReferenceResolver();
    }

    public ChildPropertySetter getChildPropertySetter() {
        return this.childPropertySetter;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassNameResolver getClassNameResolver() {
        return this.classNameResolver;
    }

    public NewInstanceResolver getNewInstanceResolver() {
        return this.newInstanceResolver;
    }

    public RelationNameResolver getRelationNameResolver() {
        return this.relationNameResolver;
    }

    public void setChildPropertySetter(final Object childPropertySetter) {
        this.childPropertySetter = childPropertySetter instanceof ChildPropertySetter ? (ChildPropertySetter)childPropertySetter : (childPropertySetter instanceof Closure ? new ChildPropertySetter(){

            public void setChild(Object parent, Object child, String parentName, String propertyName) {
                ((Closure)childPropertySetter).call(new Object[]{parent, child, parentName, propertyName});
            }
        } : new DefaultChildPropertySetter());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassNameResolver(final Object classNameResolver) {
        this.classNameResolver = classNameResolver instanceof ClassNameResolver ? (ClassNameResolver)classNameResolver : (classNameResolver instanceof String ? new ClassNameResolver(){

            public String resolveClassname(String classname) {
                return classNameResolver + "." + classname.substring(0, 1).toUpperCase() + classname.substring(1);
            }
        } : (classNameResolver instanceof Closure ? new ClassNameResolver(){

            public String resolveClassname(String classname) {
                return (String)((Closure)classNameResolver).call(new Object[]{classname});
            }
        } : new DefaultClassNameResolver()));
    }

    public void setIdentifierResolver(final Object identifierResolver) {
        this.identifierResolver = identifierResolver instanceof IdentifierResolver ? (IdentifierResolver)identifierResolver : (identifierResolver instanceof Closure ? new IdentifierResolver(){

            public String getIdentifierFor(String nodeName) {
                return (String)((Closure)identifierResolver).call(new Object[]{nodeName});
            }
        } : new DefaultIdentifierResolver());
    }

    public void setNewInstanceResolver(final Object newInstanceResolver) {
        this.newInstanceResolver = newInstanceResolver instanceof NewInstanceResolver ? (NewInstanceResolver)newInstanceResolver : (newInstanceResolver instanceof Closure ? new NewInstanceResolver(){

            public Object newInstance(Class klass, Map attributes) throws InstantiationException, IllegalAccessException {
                return ((Closure)newInstanceResolver).call(new Object[]{klass, attributes});
            }
        } : new DefaultNewInstanceResolver());
    }

    public void setReferenceResolver(final Object referenceResolver) {
        this.referenceResolver = referenceResolver instanceof ReferenceResolver ? (ReferenceResolver)referenceResolver : (referenceResolver instanceof Closure ? new ReferenceResolver(){

            public String getReferenceFor(String nodeName) {
                return (String)((Closure)referenceResolver).call(new Object[]{nodeName});
            }
        } : new DefaultReferenceResolver());
    }

    public void setRelationNameResolver(RelationNameResolver relationNameResolver) {
        this.relationNameResolver = relationNameResolver != null ? relationNameResolver : new DefaultRelationNameResolver();
    }

    protected void postInstantiate(Object name, Map attributes, Object node) {
        super.postInstantiate(name, attributes, node);
        Map<String, Object> context = this.getContext();
        String objectId = (String)context.get(OBJECT_ID);
        if (objectId != null && node != null) {
            this.setVariable(objectId, node);
        }
    }

    protected void preInstantiate(Object name, Map attributes, Object value) {
        super.preInstantiate(name, attributes, value);
        Map<String, Object> context = this.getContext();
        context.put(OBJECT_ID, attributes.remove(this.identifierResolver.getIdentifierFor((String)name)));
    }

    protected Factory resolveFactory(Object name, Map attributes, Object value) {
        Factory factory = super.resolveFactory(name, attributes, value);
        if (factory != null) {
            return factory;
        }
        if (attributes.get(this.referenceResolver.getReferenceFor((String)name)) != null) {
            return this.objectRefFactory;
        }
        return this.objectFactory;
    }

    private static class ObjectRefFactory
    extends ObjectFactory {
        private ObjectRefFactory() {
        }

        public boolean isLeaf() {
            return true;
        }

        public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            ObjectGraphBuilder ogbuilder = (ObjectGraphBuilder)builder;
            String refProperty = ogbuilder.referenceResolver.getReferenceFor((String)name);
            String refId = (String)properties.remove(refProperty);
            Object object = ogbuilder.getProperty(refId);
            if (object == null) {
                throw new IllegalArgumentException("There is no previous node with " + ogbuilder.identifierResolver.getIdentifierFor((String)name) + "=" + refId);
            }
            if (!properties.isEmpty()) {
                throw new IllegalArgumentException("You can not modify the properties of a referenced object.");
            }
            Map<String, Object> context = ogbuilder.getContext();
            context.put(ObjectGraphBuilder.NODE_NAME, name);
            context.put(ObjectGraphBuilder.NODE_CLASS, object.getClass());
            return object;
        }
    }

    private static class ObjectFactory
    extends AbstractFactory {
        private ObjectFactory() {
        }

        public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
            ObjectGraphBuilder ogbuilder = (ObjectGraphBuilder)builder;
            String classname = ogbuilder.classNameResolver.resolveClassname((String)name);
            Class klass = (Class)ogbuilder.resolvedClasses.get(classname);
            if (klass == null) {
                klass = this.loadClass(ogbuilder.classLoader, classname);
                if (klass == null) {
                    klass = this.loadClass(ogbuilder.getClass().getClassLoader(), classname);
                }
                if (klass == null) {
                    try {
                        klass = Class.forName(classname);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (klass == null) {
                    klass = this.loadClass(Thread.currentThread().getContextClassLoader(), classname);
                }
                if (klass == null) {
                    throw new RuntimeException(new ClassNotFoundException(classname));
                }
                ogbuilder.resolvedClasses.put(classname, klass);
            }
            Map<String, Object> context = ogbuilder.getContext();
            context.put(ObjectGraphBuilder.NODE_NAME, name);
            context.put(ObjectGraphBuilder.NODE_CLASS, klass);
            return ogbuilder.newInstanceResolver.newInstance(klass, properties);
        }

        public void setChild(FactoryBuilderSupport builder, Object parent, Object child) {
            ObjectGraphBuilder ogbuilder = (ObjectGraphBuilder)builder;
            if (parent != null) {
                Map<String, Object> context = ogbuilder.getContext();
                Map parentContext = ogbuilder.getParentContext();
                String parentName = null;
                String childName = (String)context.get(ObjectGraphBuilder.NODE_NAME);
                Class parentClass = null;
                Class childClass = (Class)context.get(ObjectGraphBuilder.NODE_CLASS);
                if (parentContext != null) {
                    parentName = (String)parentContext.get(ObjectGraphBuilder.NODE_NAME);
                    parentClass = (Class)parentContext.get(ObjectGraphBuilder.NODE_CLASS);
                }
                String propertyName = ogbuilder.relationNameResolver.resolveParentRelationName(parentName, parent, childName, child);
                MetaProperty metaProperty = InvokerHelper.getMetaClass(child).hasProperty(child, propertyName);
                if (metaProperty != null) {
                    metaProperty.setProperty(child, parent);
                }
            }
        }

        public void setParent(FactoryBuilderSupport builder, Object parent, Object child) {
            ObjectGraphBuilder ogbuilder = (ObjectGraphBuilder)builder;
            if (parent != null) {
                Map<String, Object> context = ogbuilder.getContext();
                Map parentContext = ogbuilder.getParentContext();
                String parentName = null;
                String childName = (String)context.get(ObjectGraphBuilder.NODE_NAME);
                Class parentClass = null;
                Class childClass = (Class)context.get(ObjectGraphBuilder.NODE_CLASS);
                if (parentContext != null) {
                    parentName = (String)parentContext.get(ObjectGraphBuilder.NODE_NAME);
                    parentClass = (Class)parentContext.get(ObjectGraphBuilder.NODE_CLASS);
                }
                ogbuilder.childPropertySetter.setChild(parent, child, parentName, ogbuilder.relationNameResolver.resolveChildRelationName(parentName, parent, childName, child));
            }
        }

        private Class loadClass(ClassLoader classLoader, String classname) {
            if (classLoader == null || classname == null) {
                return null;
            }
            try {
                return classLoader.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    public static interface RelationNameResolver {
        public String resolveChildRelationName(String var1, Object var2, String var3, Object var4);

        public String resolveParentRelationName(String var1, Object var2, String var3, Object var4);
    }

    public static interface ReferenceResolver {
        public String getReferenceFor(String var1);
    }

    public static interface NewInstanceResolver {
        public Object newInstance(Class var1, Map var2) throws InstantiationException, IllegalAccessException;
    }

    public static interface IdentifierResolver {
        public String getIdentifierFor(String var1);
    }

    public static class DefaultRelationNameResolver
    implements RelationNameResolver {
        public String resolveChildRelationName(String parentName, Object parent, String childName, Object child) {
            MetaProperty metaProperty = InvokerHelper.getMetaClass(parent).hasProperty(parent, childName + "s");
            if (metaProperty != null) {
                return childName + "s";
            }
            return childName;
        }

        public String resolveParentRelationName(String parentName, Object parent, String childName, Object child) {
            return parentName;
        }
    }

    public static class DefaultReferenceResolver
    implements ReferenceResolver {
        public String getReferenceFor(String nodeName) {
            return "refId";
        }
    }

    public static class DefaultNewInstanceResolver
    implements NewInstanceResolver {
        public Object newInstance(Class klass, Map attributes) throws InstantiationException, IllegalAccessException {
            return klass.newInstance();
        }
    }

    public static class DefaultIdentifierResolver
    implements IdentifierResolver {
        public String getIdentifierFor(String nodeName) {
            return "id";
        }
    }

    public static class DefaultClassNameResolver
    implements ClassNameResolver {
        public String resolveClassname(String classname) {
            if (classname.length() == 1) {
                return classname.toUpperCase();
            }
            return classname.substring(0, 1).toUpperCase() + classname.substring(1);
        }
    }

    public static class DefaultChildPropertySetter
    implements ChildPropertySetter {
        public void setChild(Object parent, Object child, String parentName, String propertyName) {
            Object property = InvokerHelper.getProperty(parent, propertyName);
            if (property != null && Collection.class.isAssignableFrom(property.getClass())) {
                ((Collection)property).add(child);
            } else {
                InvokerHelper.setProperty(parent, propertyName, child);
            }
        }
    }

    public static interface ClassNameResolver {
        public String resolveClassname(String var1);
    }

    public static interface ChildPropertySetter {
        public void setChild(Object var1, Object var2, String var3, String var4);
    }
}

