/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.util.AbstractFactory;
import groovy.util.Factory;
import groovy.util.FactoryInterceptorMetaClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FactoryBuilderSupport
extends Binding {
    public static final String CURRENT_FACTORY = "_CURRENT_FACTORY_";
    public static final String PARENT_FACTORY = "_PARENT_FACTORY_";
    public static final String PARENT_NODE = "_PARENT_NODE_";
    public static final String CURRENT_NODE = "_CURRENT_NODE_";
    public static final String PARENT_CONTEXT = "_PARENT_CONTEXT_";
    public static final String PARENT_NAME = "_PARENT_NAME_";
    public static final String CURRENT_NAME = "_CURRENT_NAME_";
    public static final String OWNER = "owner";
    public static final String PARENT_BUILDER = "_PARENT_BUILDER_";
    public static final String CURRENT_BUILDER = "_CURRENT_BUILDER_";
    public static final String CHILD_BUILDER = "_CHILD_BUILDER_";
    private static final Logger LOG = Logger.getLogger(FactoryBuilderSupport.class.getName());
    private LinkedList<Map<String, Object>> contexts = new LinkedList();
    private LinkedList<Closure> attributeDelegates = new LinkedList();
    private List<Closure> disposalClosures = new ArrayList<Closure>();
    private Map<String, Factory> factories = new HashMap<String, Factory>();
    private Closure nameMappingClosure;
    private FactoryBuilderSupport proxyBuilder;
    private LinkedList<Closure> preInstantiateDelegates = new LinkedList();
    private LinkedList<Closure> postInstantiateDelegates = new LinkedList();
    private LinkedList<Closure> postNodeCompletionDelegates = new LinkedList();

    public static void checkValueIsNull(Object value, Object name) {
        if (value != null) {
            throw new RuntimeException("'" + name + "' elements do not accept a value argument.");
        }
    }

    public static boolean checkValueIsType(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName());
        }
        return false;
    }

    public static boolean checkValueIsTypeNotString(Object value, Object name, Class type) {
        if (value != null) {
            if (type.isAssignableFrom(value.getClass())) {
                return true;
            }
            if (value instanceof String) {
                return false;
            }
            throw new RuntimeException("The value argument of '" + name + "' must be of type " + type.getName() + " or a String.");
        }
        return false;
    }

    public FactoryBuilderSupport() {
        this.proxyBuilder = this;
    }

    public FactoryBuilderSupport(Closure nameMappingClosure) {
        this.nameMappingClosure = nameMappingClosure;
        this.proxyBuilder = this;
    }

    @Override
    public Object getVariable(String name) {
        return this.proxyBuilder.doGetVariable(name);
    }

    private Object doGetVariable(String name) {
        return super.getVariable(name);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.proxyBuilder.doSetVariable(name, value);
    }

    private void doSetVariable(String name, Object value) {
        super.setVariable(name, value);
    }

    @Override
    public Map getVariables() {
        return this.proxyBuilder.doGetVariables();
    }

    private Map doGetVariables() {
        return super.getVariables();
    }

    @Override
    public Object getProperty(String property) {
        try {
            return this.proxyBuilder.doGetProperty(property);
        }
        catch (MissingPropertyException mpe) {
            if (this.getContext() != null && this.getContext().containsKey(property)) {
                return this.getContext().get(property);
            }
            return this.getMetaClass().getProperty(this, property);
        }
    }

    private Object doGetProperty(String property) {
        return super.getProperty(property);
    }

    @Override
    public void setProperty(String property, Object newValue) {
        this.proxyBuilder.doSetProperty(property, newValue);
    }

    private void doSetProperty(String property, Object newValue) {
        super.setProperty(property, newValue);
    }

    public Map<String, Factory> getFactories() {
        return Collections.unmodifiableMap(this.proxyBuilder.factories);
    }

    public List<Closure> getAttributeDelegates() {
        return Collections.unmodifiableList(this.attributeDelegates);
    }

    public List<Closure> getPreInstantiateDelegates() {
        return Collections.unmodifiableList(this.preInstantiateDelegates);
    }

    public List<Closure> getPostInstantiateDelegates() {
        return Collections.unmodifiableList(this.postInstantiateDelegates);
    }

    public List<Closure> getPostNodeCompletionDelegates() {
        return Collections.unmodifiableList(this.postNodeCompletionDelegates);
    }

    public Map<String, Object> getContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            return this.proxyBuilder.contexts.getFirst();
        }
        return null;
    }

    public Object getCurrent() {
        return this.getContextAttribute(CURRENT_NODE);
    }

    public Factory getCurrentFactory() {
        return (Factory)this.getContextAttribute(CURRENT_FACTORY);
    }

    public String getCurrentName() {
        return (String)this.getContextAttribute(CURRENT_NAME);
    }

    public FactoryBuilderSupport getCurrentBuilder() {
        return (FactoryBuilderSupport)this.getContextAttribute(CURRENT_BUILDER);
    }

    public Object getParentNode() {
        return this.getContextAttribute(PARENT_NODE);
    }

    public Factory getParentFactory() {
        return (Factory)this.getContextAttribute(PARENT_FACTORY);
    }

    public Map getParentContext() {
        return (Map)this.getContextAttribute(PARENT_CONTEXT);
    }

    public String getParentName() {
        return (String)this.getContextAttribute(PARENT_NAME);
    }

    public FactoryBuilderSupport getChildBuilder() {
        return (FactoryBuilderSupport)this.getContextAttribute(CHILD_BUILDER);
    }

    private Object getContextAttribute(String key) {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            Map<String, Object> context = this.proxyBuilder.contexts.getFirst();
            return context.get(key);
        }
        return null;
    }

    public Object invokeMethod(String methodName) {
        return this.proxyBuilder.invokeMethod(methodName, null);
    }

    @Override
    public Object invokeMethod(String methodName, Object args) {
        Object result;
        Object name = this.proxyBuilder.getName(methodName);
        Map<String, Object> previousContext = this.proxyBuilder.getContext();
        try {
            result = this.proxyBuilder.doInvokeMethod(methodName, name, args);
        }
        catch (RuntimeException e) {
            if (this.proxyBuilder.contexts.contains(previousContext)) {
                while (this.proxyBuilder.getContext() != previousContext) {
                    this.proxyBuilder.popContext();
                }
            }
            throw e;
        }
        return result;
    }

    public Closure addAttributeDelegate(Closure attrDelegate) {
        this.proxyBuilder.attributeDelegates.addFirst(attrDelegate);
        return attrDelegate;
    }

    public void removeAttributeDelegate(Closure attrDelegate) {
        this.proxyBuilder.attributeDelegates.remove(attrDelegate);
    }

    public Closure addPreInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.preInstantiateDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePreInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.preInstantiateDelegates.remove(delegate);
    }

    public Closure addPostInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.postInstantiateDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePostInstantiateDelegate(Closure delegate) {
        this.proxyBuilder.postInstantiateDelegates.remove(delegate);
    }

    public Closure addPostNodeCompletionDelegate(Closure delegate) {
        this.proxyBuilder.postNodeCompletionDelegates.addFirst(delegate);
        return delegate;
    }

    public void removePostNodeCompletionDelegate(Closure delegate) {
        this.proxyBuilder.postNodeCompletionDelegates.remove(delegate);
    }

    public void registerBeanFactory(String theName, final Class beanClass) {
        this.proxyBuilder.registerFactory(theName, new AbstractFactory(){

            public Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map properties) throws InstantiationException, IllegalAccessException {
                if (FactoryBuilderSupport.checkValueIsTypeNotString(value, name, beanClass)) {
                    return value;
                }
                return beanClass.newInstance();
            }
        });
    }

    public void registerFactory(String name, Factory factory) {
        this.proxyBuilder.factories.put(name, factory);
        factory.onFactoryRegistration(this, name);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object node;
        Factory factory = this.proxyBuilder.resolveFactory(name, attributes, value);
        if (factory == null) {
            LOG.log(Level.WARNING, "Could not find match for name '" + name + "'");
            return null;
        }
        this.proxyBuilder.getContext().put(CURRENT_FACTORY, factory);
        this.proxyBuilder.getContext().put(CURRENT_NAME, String.valueOf(name));
        this.proxyBuilder.preInstantiate(name, attributes, value);
        try {
            node = factory.newInstance(this.proxyBuilder.getChildBuilder(), name, value, attributes);
            if (node == null) {
                LOG.log(Level.WARNING, "Factory for name '" + name + "' returned null");
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("For name: " + name + " created node: " + node);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create component for '" + name + "' reason: " + e, e);
        }
        this.proxyBuilder.postInstantiate(name, attributes, node);
        this.proxyBuilder.handleNodeAttributes(node, attributes);
        return node;
    }

    protected Factory resolveFactory(Object name, Map attributes, Object value) {
        this.proxyBuilder.getContext().put(CHILD_BUILDER, this.proxyBuilder);
        return this.proxyBuilder.factories.get(name);
    }

    private Object doInvokeMethod(String methodName, Object name, Object args) {
        Object node;
        Closure closure = null;
        List list = InvokerHelper.asList(args);
        if (this.proxyBuilder.getContexts().isEmpty()) {
            this.proxyBuilder.newContext();
        }
        switch (list.size()) {
            case 0: {
                node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, null);
                break;
            }
            case 1: {
                Object object = list.get(0);
                if (object instanceof Map) {
                    node = this.proxyBuilder.createNode(name, (Map)object, null);
                    break;
                }
                if (object instanceof Closure) {
                    closure = (Closure)object;
                    node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, null);
                    break;
                }
                node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, object);
                break;
            }
            case 2: {
                Object object1 = list.get(0);
                Object object2 = list.get(1);
                if (object1 instanceof Map) {
                    if (object2 instanceof Closure) {
                        closure = (Closure)object2;
                        node = this.proxyBuilder.createNode(name, (Map)object1, null);
                        break;
                    }
                    node = this.proxyBuilder.createNode(name, (Map)object1, object2);
                    break;
                }
                if (object2 instanceof Closure) {
                    closure = (Closure)object2;
                    node = this.proxyBuilder.createNode(name, Collections.EMPTY_MAP, object1);
                    break;
                }
                if (object2 instanceof Map) {
                    node = this.proxyBuilder.createNode(name, (Map)object2, object1);
                    break;
                }
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
            case 3: {
                Object arg0 = list.get(0);
                Object arg1 = list.get(1);
                Object arg2 = list.get(2);
                if (arg0 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    node = this.proxyBuilder.createNode(name, (Map)arg0, arg1);
                    break;
                }
                if (arg1 instanceof Map && arg2 instanceof Closure) {
                    closure = (Closure)arg2;
                    node = this.proxyBuilder.createNode(name, (Map)arg1, arg0);
                    break;
                }
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
            default: {
                throw new MissingMethodException(name.toString(), this.getClass(), list.toArray(), false);
            }
        }
        if (node == null) {
            if (this.proxyBuilder.getContexts().size() == 1) {
                this.proxyBuilder.popContext();
            }
            return node;
        }
        Object current = this.proxyBuilder.getCurrent();
        if (current != null) {
            this.proxyBuilder.setParent(current, node);
        }
        if (closure != null) {
            Factory parentFactory = this.proxyBuilder.getCurrentFactory();
            if (parentFactory.isLeaf()) {
                throw new RuntimeException("'" + name + "' doesn't support nesting.");
            }
            boolean processContent = true;
            if (parentFactory.isHandlesNodeChildren()) {
                processContent = parentFactory.onNodeChildren(this, node, closure);
            }
            if (processContent) {
                String parentName = this.proxyBuilder.getCurrentName();
                Map<String, Object> parentContext = this.proxyBuilder.getContext();
                this.proxyBuilder.newContext();
                this.proxyBuilder.getContext().put(OWNER, closure.getOwner());
                this.proxyBuilder.getContext().put(CURRENT_NODE, node);
                this.proxyBuilder.getContext().put(PARENT_FACTORY, parentFactory);
                this.proxyBuilder.getContext().put(PARENT_NODE, current);
                this.proxyBuilder.getContext().put(PARENT_CONTEXT, parentContext);
                this.proxyBuilder.getContext().put(PARENT_NAME, parentName);
                this.proxyBuilder.getContext().put(PARENT_BUILDER, parentContext.get(CURRENT_BUILDER));
                this.proxyBuilder.getContext().put(CURRENT_BUILDER, parentContext.get(CHILD_BUILDER));
                this.proxyBuilder.setClosureDelegate(closure, node);
                closure.call();
                this.proxyBuilder.popContext();
            }
        }
        this.proxyBuilder.nodeCompleted(current, node);
        node = this.proxyBuilder.postNodeCompletion(current, node);
        if (this.proxyBuilder.getContexts().size() == 1) {
            this.proxyBuilder.popContext();
        }
        return node;
    }

    public Object getName(String methodName) {
        if (this.proxyBuilder.nameMappingClosure != null) {
            return this.proxyBuilder.nameMappingClosure.call(methodName);
        }
        return methodName;
    }

    protected FactoryBuilderSupport getProxyBuilder() {
        return this.proxyBuilder;
    }

    protected void handleNodeAttributes(Object node, Map attributes) {
        if (node == null) {
            return;
        }
        for (Closure attrDelegate : this.proxyBuilder.attributeDelegates) {
            FactoryBuilderSupport builder = this;
            if (attrDelegate.getOwner() instanceof FactoryBuilderSupport) {
                builder = (FactoryBuilderSupport)attrDelegate.getOwner();
            } else if (attrDelegate.getDelegate() instanceof FactoryBuilderSupport) {
                builder = (FactoryBuilderSupport)attrDelegate.getDelegate();
            }
            attrDelegate.call(new Object[]{builder, node, attributes});
        }
        if (this.proxyBuilder.getCurrentFactory().onHandleNodeAttributes(this.proxyBuilder.getChildBuilder(), node, attributes)) {
            this.proxyBuilder.setNodeAttributes(node, attributes);
        }
    }

    protected void newContext() {
        this.proxyBuilder.contexts.addFirst(new HashMap());
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.proxyBuilder.getCurrentFactory().onNodeCompleted(this.proxyBuilder.getChildBuilder(), parent, node);
    }

    protected Map<String, Object> popContext() {
        if (!this.proxyBuilder.contexts.isEmpty()) {
            return this.proxyBuilder.contexts.removeFirst();
        }
        return null;
    }

    protected void postInstantiate(Object name, Map attributes, Object node) {
        for (Closure postInstantiateDelegate : this.proxyBuilder.postInstantiateDelegates) {
            postInstantiateDelegate.call(new Object[]{this, node, attributes});
        }
    }

    protected Object postNodeCompletion(Object parent, Object node) {
        for (Closure postNodeCompletionDelegate : this.proxyBuilder.postNodeCompletionDelegates) {
            postNodeCompletionDelegate.call(new Object[]{this, parent, node});
        }
        return node;
    }

    protected void preInstantiate(Object name, Map attributes, Object value) {
        for (Closure preInstantiateDelegate : this.proxyBuilder.preInstantiateDelegates) {
            preInstantiateDelegate.call(new Object[]{this, value, attributes});
        }
    }

    protected void reset() {
        this.proxyBuilder.contexts.clear();
    }

    protected void setClosureDelegate(Closure closure, Object node) {
        closure.setDelegate(this);
    }

    protected void setNodeAttributes(Object node, Map attributes) {
        for (Map.Entry entry : attributes.entrySet()) {
            String property = entry.getKey().toString();
            Object value = entry.getValue();
            InvokerHelper.setProperty(node, property, value);
        }
    }

    protected void setParent(Object parent, Object child) {
        this.proxyBuilder.getCurrentFactory().setParent(this.proxyBuilder.getChildBuilder(), parent, child);
        Factory parentFactory = this.proxyBuilder.getParentFactory();
        if (parentFactory != null) {
            parentFactory.setChild(this.proxyBuilder.getCurrentBuilder(), parent, child);
        }
    }

    protected void setProxyBuilder(FactoryBuilderSupport proxyBuilder) {
        this.proxyBuilder = proxyBuilder;
    }

    protected LinkedList<? extends Map<String, Object>> getContexts() {
        return this.proxyBuilder.contexts;
    }

    public Object build(Class viewClass) {
        if (Script.class.isAssignableFrom(viewClass)) {
            Script script = InvokerHelper.createScript(viewClass, this);
            return this.build(script);
        }
        throw new RuntimeException("Only scripts can be executed via build(Class)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object build(Script script) {
        Script script2 = script;
        synchronized (script2) {
            MetaClass scriptMetaClass = script.getMetaClass();
            script.setMetaClass(new FactoryInterceptorMetaClass(scriptMetaClass, this));
            script.setBinding(this);
            return script.run();
        }
    }

    public Object build(String script, GroovyClassLoader loader) {
        return this.build(loader.parseClass(script));
    }

    public Object withBuilder(FactoryBuilderSupport builder, Closure closure) {
        if (builder == null || closure == null) {
            return null;
        }
        Object result = null;
        Map<String, Object> previousContext = this.proxyBuilder.getContext();
        FactoryBuilderSupport previousProxyBuilder = this.proxyBuilder;
        try {
            this.proxyBuilder = builder;
            closure.setDelegate(builder);
            result = closure.call();
        }
        catch (RuntimeException e) {
            this.proxyBuilder = previousProxyBuilder;
            if (this.proxyBuilder.contexts.contains(previousContext)) {
                while (this.proxyBuilder.getContext() != previousContext) {
                    this.proxyBuilder.popContext();
                }
            }
            throw e;
        }
        finally {
            this.proxyBuilder = previousProxyBuilder;
        }
        return result;
    }

    public Object withBuilder(FactoryBuilderSupport builder, String name, Closure closure) {
        if (name == null) {
            return null;
        }
        Object result = this.proxyBuilder.withBuilder(builder, closure);
        return this.proxyBuilder.invokeMethod(name, new Object[]{result});
    }

    public Object withBuilder(Map attributes, FactoryBuilderSupport builder, String name, Closure closure) {
        if (name == null) {
            return null;
        }
        Object result = this.proxyBuilder.withBuilder(builder, closure);
        return this.proxyBuilder.invokeMethod(name, new Object[]{attributes, result});
    }

    public void addDisposalClosure(Closure closure) {
        this.disposalClosures.add(closure);
    }

    public void dispose() {
        for (int i = this.disposalClosures.size() - 1; i >= 0; --i) {
            this.disposalClosures.get(i).call();
        }
    }
}

