/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.codehaus.groovy.binding.AbstractFullBinding;
import org.codehaus.groovy.binding.PropertyBinding;
import org.codehaus.groovy.binding.SourceBinding;
import org.codehaus.groovy.binding.TargetBinding;

class JScrollBarValueBinding
extends AbstractFullBinding
implements PropertyChangeListener,
ChangeListener {
    boolean bound = false;
    JScrollBar boundScrollBar;

    public JScrollBarValueBinding(PropertyBinding source, TargetBinding target) {
        this.setSourceBinding(source);
        this.setTargetBinding(target);
    }

    public synchronized void bind() {
        if (!this.bound) {
            this.boundScrollBar = (JScrollBar)((PropertyBinding)this.sourceBinding).getBean();
            try {
                this.boundScrollBar.addPropertyChangeListener("model", this);
                this.boundScrollBar.getModel().addChangeListener(this);
                this.bound = true;
            }
            catch (RuntimeException re) {
                try {
                    this.boundScrollBar.removePropertyChangeListener("model", this);
                    this.boundScrollBar.getModel().removeChangeListener(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw re;
            }
        }
    }

    public synchronized void unbind() {
        if (this.bound) {
            this.bound = false;
            this.boundScrollBar.removePropertyChangeListener("model", this);
            this.boundScrollBar.getModel().removeChangeListener(this);
            this.boundScrollBar = null;
        }
    }

    public void rebind() {
        if (this.bound) {
            this.unbind();
            this.bind();
        }
    }

    public void setSourceBinding(SourceBinding source) {
        if (!(source instanceof PropertyBinding)) {
            throw new IllegalArgumentException("Only PropertySourceBindings are accepted");
        }
        if (!"value".equals(((PropertyBinding)source).getPropertyName())) {
            throw new IllegalArgumentException("PropertyName must be 'value'");
        }
        if (!(((PropertyBinding)source).getBean() instanceof JScrollBar)) {
            throw new IllegalArgumentException("SourceBean must be an JScrollBar");
        }
        super.setSourceBinding(source);
    }

    public void setTargetBinding(TargetBinding target) {
        super.setTargetBinding(target);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.update();
        ((BoundedRangeModel)event.getOldValue()).removeChangeListener(this);
        ((BoundedRangeModel)event.getNewValue()).addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        this.update();
    }
}

