/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.codehaus.groovy.tools.shell.util.ANSI;

public class IO {
    public final InputStream inputStream;
    public final OutputStream outputStream;
    public final OutputStream errorStream;
    public final Reader in;
    public final PrintWriter out;
    public final PrintWriter err;
    public boolean verbose;
    public boolean quiet;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IO(InputStream inputStream, OutputStream outputStream, OutputStream errorStream) {
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && errorStream == null) {
            throw new AssertionError();
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.errorStream = errorStream;
        this.in = new InputStreamReader(inputStream);
        this.out = new ANSI.RenderWriter(outputStream, true);
        this.err = new ANSI.RenderWriter(errorStream, true);
        Preferences prefs = Preferences.userRoot().node("/org/codehaus/groovy/tools/shell");
        this.verbose = prefs.getBoolean("verbose", false);
        prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent event) {
                if (event.getKey().equals("verbose")) {
                    IO.this.verbose = event.getNode().getBoolean("verbose", false);
                }
            }
        });
        this.quiet = prefs.getBoolean("quiet", false);
        prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent event) {
                if (event.getKey().equals("quiet")) {
                    IO.this.verbose = event.getNode().getBoolean("quiet", false);
                }
            }
        });
    }

    public IO() {
        this(System.in, System.out, System.err);
    }

    public void flush() throws IOException {
        this.out.flush();
        this.err.flush();
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.err.close();
    }

    static {
        $assertionsDisabled = !IO.class.desiredAssertionStatus();
    }
}

