/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ComplexKeyHashMap;
import org.codehaus.groovy.reflection.DoubleKeyHashMap;
import org.codehaus.groovy.reflection.TripleKeyHashMap;

public class ReflectionCache {
    private static Map primitiveTypesMap = new HashMap();
    static TripleKeyHashMap mopNames;
    static final Map CACHED_CLASS_MAP;
    private static Map CACHED_METHOD_MAP;
    private static final Map CACHED_CONSTRUCTOR_MAP;
    static DoubleKeyHashMap assignableMap;
    private static final CachedClass OBJECT_CLASS;

    public static Class autoboxType(Class type) {
        Class res = (Class)primitiveTypesMap.get(type);
        return res == null ? type : res;
    }

    public static String getMOPMethodName(Class declaringClass, String name, boolean useThis) {
        MopNameEntry mopNameEntry = (MopNameEntry)mopNames.getOrPut(declaringClass, name, useThis);
        if (mopNameEntry.value == null) {
            mopNameEntry.value = (useThis ? "this$" : "super$") + ReflectionCache.getSuperClassDistance(declaringClass) + "$" + name;
        }
        return mopNameEntry.value;
    }

    public static boolean isArray(Class klazz) {
        CachedClass cachedClass = ReflectionCache.getCachedClass(klazz);
        return cachedClass.isArray;
    }

    public static boolean isAssignableFrom(Class klazz, Class aClass) {
        IsAssignableEntry val = (IsAssignableEntry)assignableMap.getOrPut(klazz, aClass);
        if (val.value == null) {
            val.value = klazz.isAssignableFrom(aClass);
        }
        return val.value;
    }

    static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getSuperClassDistance(Class klazz) {
        CachedClass cachedClass;
        CachedClass cachedClass2 = cachedClass = ReflectionCache.getCachedClass(klazz);
        synchronized (cachedClass2) {
            if (cachedClass.distance == -1) {
                int distance = 0;
                while (klazz != null) {
                    ++distance;
                    klazz = klazz.getSuperclass();
                }
                cachedClass.distance = distance;
            }
            return cachedClass.distance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedClass getCachedClass(Class klazz) {
        CachedClass cachedClass;
        if (klazz == null) {
            return null;
        }
        if (klazz == Object.class) {
            return OBJECT_CLASS;
        }
        Map map = CACHED_CLASS_MAP;
        synchronized (map) {
            SoftReference ref = (SoftReference)CACHED_CLASS_MAP.get(klazz);
            if (ref == null || (cachedClass = (CachedClass)ref.get()) == null) {
                cachedClass = new CachedClass(klazz);
                CACHED_CLASS_MAP.put(klazz, new SoftReference<CachedClass>(cachedClass));
            }
        }
        return cachedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedMethod getCachedMethod(Method method) {
        CachedMethod cachedMethod;
        Map map = CACHED_METHOD_MAP;
        synchronized (map) {
            SoftReference ref = (SoftReference)CACHED_METHOD_MAP.get(method);
            if (ref == null || (cachedMethod = (CachedMethod)ref.get()) == null) {
                cachedMethod = new CachedMethod(method);
                CACHED_METHOD_MAP.put(method, new SoftReference<CachedMethod>(cachedMethod));
            }
        }
        return cachedMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedConstructor getCachedConstructor(Constructor c) {
        CachedConstructor cachedConstructor;
        Map map = CACHED_CONSTRUCTOR_MAP;
        synchronized (map) {
            SoftReference ref = (SoftReference)CACHED_CONSTRUCTOR_MAP.get(c);
            if (ref == null || (cachedConstructor = (CachedConstructor)ref.get()) == null) {
                cachedConstructor = new CachedConstructor(c);
                CACHED_CONSTRUCTOR_MAP.put(c, new SoftReference<CachedConstructor>(cachedConstructor));
            }
        }
        return cachedConstructor;
    }

    public static CachedMethod[] getDeclaredMethodsCached(Class klazz) {
        return ReflectionCache.getCachedClass(klazz).getMethods();
    }

    static {
        primitiveTypesMap.put(Byte.TYPE, Byte.class);
        primitiveTypesMap.put(Boolean.TYPE, Boolean.class);
        primitiveTypesMap.put(Character.TYPE, Character.class);
        primitiveTypesMap.put(Double.TYPE, Double.class);
        primitiveTypesMap.put(Float.TYPE, Float.class);
        primitiveTypesMap.put(Integer.TYPE, Integer.class);
        primitiveTypesMap.put(Long.TYPE, Long.class);
        primitiveTypesMap.put(Short.TYPE, Short.class);
        mopNames = new TripleKeyHashMap(){

            public boolean checkEquals(TripleKeyHashMap.Entry e, Object key1, Object key2, Object key3) {
                MopNameEntry ee = (MopNameEntry)e;
                return ee.key1 == key1 && ee.key2.equals(key2) && ee.key3 == key3;
            }

            public TripleKeyHashMap.Entry createEntry() {
                return new MopNameEntry();
            }
        };
        CACHED_CLASS_MAP = new WeakHashMap();
        CACHED_METHOD_MAP = new WeakHashMap();
        CACHED_CONSTRUCTOR_MAP = new WeakHashMap();
        assignableMap = new DoubleKeyHashMap(){

            public boolean checkEquals(ComplexKeyHashMap.Entry e, Object key1, Object key2) {
                IsAssignableEntry ee = (IsAssignableEntry)e;
                return ee.key1 == key1 && ee.key2 == key2;
            }

            public DoubleKeyHashMap.Entry createEntry() {
                return new IsAssignableEntry();
            }
        };
        OBJECT_CLASS = new CachedClass(Object.class){

            public synchronized CachedClass getCachedSuperClass() {
                return null;
            }
        };
    }

    public static class IsAssignableEntry
    extends DoubleKeyHashMap.Entry {
        Boolean value;
    }

    private static class MopNameEntry
    extends TripleKeyHashMap.Entry {
        String value;

        private MopNameEntry() {
        }
    }
}

