/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Byte;;
import [Ljava.lang.Character;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import [Ljava.math.BigDecimal;;
import groovy.lang.GString;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class CachedClass {
    private CachedClass cachedSuperClass;
    private CachedMethod[] methods;
    public final Class cachedClass;
    public final boolean isArray;
    public final boolean isPrimitive;
    public final int modifiers;
    int distance = -1;
    public final boolean isInterface;
    public final boolean isNumber;

    CachedClass(Class klazz) {
        this.cachedClass = klazz;
        this.isArray = klazz.isArray();
        this.isPrimitive = klazz.isPrimitive();
        this.modifiers = klazz.getModifiers();
        this.isInterface = klazz.isInterface();
        this.isNumber = Number.class.isAssignableFrom(klazz);
    }

    public synchronized CachedClass getCachedSuperClass() {
        if (this.cachedSuperClass == null) {
            this.cachedSuperClass = ReflectionCache.getCachedClass(this.cachedClass.getSuperclass());
        }
        return this.cachedSuperClass;
    }

    public synchronized CachedMethod[] getMethods() {
        if (this.methods == null) {
            Method[] declaredMethods = this.cachedClass.getDeclaredMethods();
            this.methods = new CachedMethod[declaredMethods.length];
            for (int i = 0; i != this.methods.length; ++i) {
                this.methods[i] = ReflectionCache.getCachedMethod(declaredMethods[i]);
            }
        }
        return this.methods;
    }

    public Method searchMethods(String name, CachedClass[] parameterTypes) {
        CachedMethod[] methods = this.getMethods();
        Method res = null;
        for (int i = 0; i < methods.length; ++i) {
            CachedMethod m = methods[i];
            if (!m.cachedMethod.getName().equals(name) || !ReflectionCache.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.cachedMethod.getReturnType())) continue;
            res = m.cachedMethod;
        }
        return res;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    protected Object coerceGString(Object argument) {
        if (this.cachedClass != String.class) {
            return argument;
        }
        if (!(argument instanceof GString)) {
            return argument;
        }
        return argument.toString();
    }

    protected Object coerceNumber(Object argument) {
        if (argument instanceof Number && (this.isNumber || this.isPrimitive)) {
            Object oldArgument = argument;
            boolean wasDouble = false;
            boolean wasFloat = false;
            Class param = this.cachedClass;
            if (param == Byte.class || param == Byte.TYPE) {
                argument = new Byte(((Number)argument).byteValue());
            } else if (param == Double.class || param == Double.TYPE) {
                wasDouble = true;
                argument = new Double(((Number)argument).doubleValue());
            } else if (param == Float.class || param == Float.TYPE) {
                wasFloat = true;
                argument = new Float(((Number)argument).floatValue());
            } else if (param == Integer.class || param == Integer.TYPE) {
                argument = new Integer(((Number)argument).intValue());
            } else if (param == Long.class || param == Long.TYPE) {
                argument = new Long(((Number)argument).longValue());
            } else if (param == Short.class || param == Short.TYPE) {
                argument = new Short(((Number)argument).shortValue());
            } else if (param == BigDecimal.class) {
                argument = new BigDecimal(String.valueOf((Number)argument));
            } else if (param == BigInteger.class) {
                argument = new BigInteger(String.valueOf((Number)argument));
            }
            if (oldArgument instanceof BigDecimal) {
                BigDecimal oldbd = (BigDecimal)oldArgument;
                boolean throwException = false;
                if (wasDouble) {
                    Double d = (Double)argument;
                    if (d.isInfinite()) {
                        throwException = true;
                    }
                } else if (wasFloat) {
                    Float f = (Float)argument;
                    if (f.isInfinite()) {
                        throwException = true;
                    }
                } else {
                    BigDecimal newbd = new BigDecimal(String.valueOf((Number)argument));
                    boolean bl = throwException = !oldArgument.equals(newbd);
                }
                if (throwException) {
                    throw new IllegalArgumentException(param + " out of range while converting from BigDecimal");
                }
            }
        }
        return argument;
    }

    protected Object coerceArray(Object argument) {
        if (!this.isArray) {
            return argument;
        }
        Class<?> argumentClass = argument.getClass();
        if (!argumentClass.isArray()) {
            return argument;
        }
        Class<?> paramComponent = this.cachedClass.getComponentType();
        if (paramComponent.isPrimitive()) {
            if (paramComponent == Boolean.TYPE && argumentClass == Boolean;.class) {
                argument = DefaultTypeTransformation.convertToBooleanArray(argument);
            } else if (paramComponent == Byte.TYPE && argumentClass == Byte;.class) {
                argument = DefaultTypeTransformation.convertToByteArray(argument);
            } else if (paramComponent == Character.TYPE && argumentClass == Character;.class) {
                argument = DefaultTypeTransformation.convertToCharArray(argument);
            } else if (paramComponent == Short.TYPE && argumentClass == Short;.class) {
                argument = DefaultTypeTransformation.convertToShortArray(argument);
            } else if (paramComponent == Integer.TYPE && argumentClass == Integer;.class) {
                argument = DefaultTypeTransformation.convertToIntArray(argument);
            } else if (paramComponent == Long.TYPE && (argumentClass == Long;.class || argumentClass == Integer;.class)) {
                argument = DefaultTypeTransformation.convertToLongArray(argument);
            } else if (paramComponent == Float.TYPE && (argumentClass == Float;.class || argumentClass == Integer;.class)) {
                argument = DefaultTypeTransformation.convertToFloatArray(argument);
            } else if (paramComponent == Double.TYPE && (argumentClass == Double;.class || argumentClass == Float;.class || BigDecimal;.class.isAssignableFrom(argumentClass))) {
                argument = DefaultTypeTransformation.convertToDoubleArray(argument);
            }
        } else if (paramComponent == String.class && argument instanceof GString[]) {
            GString[] strings = (GString[])argument;
            String[] ret = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ret[i] = strings[i].toString();
            }
            argument = ret;
        }
        return argument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuperClassDistance() {
        Class clazz = this.cachedClass;
        synchronized (clazz) {
            if (this.distance == -1) {
                int distance = 0;
                for (Class klazz = this.cachedClass; klazz != null; klazz = klazz.getSuperclass()) {
                    ++distance;
                }
                this.distance = distance;
            }
            return this.distance;
        }
    }
}

