/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.binding;

import groovy.lang.MissingMethodException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.codehaus.groovy.binding.AbstractFullBinding;
import org.codehaus.groovy.binding.FullBinding;
import org.codehaus.groovy.binding.SourceBinding;
import org.codehaus.groovy.binding.TargetBinding;
import org.codehaus.groovy.binding.TriggerBinding;
import org.codehaus.groovy.runtime.InvokerHelper;

public class PropertyBinding
implements SourceBinding,
TargetBinding,
TriggerBinding {
    Object bean;
    String propertyName;

    public PropertyBinding(Object bean, String propertyName) {
        this.bean = bean;
        this.propertyName = propertyName;
    }

    public void updateTargetValue(Object newValue) {
        InvokerHelper.setProperty(this.bean, this.propertyName, newValue);
    }

    public Object getSourceValue() {
        return InvokerHelper.getPropertySafe(this.bean, this.propertyName);
    }

    public FullBinding createBinding(SourceBinding source, TargetBinding target) {
        return new PropertyFullBinding(source, target);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    class PropertyFullBinding
    extends AbstractFullBinding
    implements PropertyChangeListener {
        Object boundBean;
        Object boundProperty;
        boolean bound;

        PropertyFullBinding(SourceBinding source, TargetBinding target) {
            this.setSourceBinding(source);
            this.setTargetBinding(target);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals(this.boundProperty)) {
                this.update();
            }
        }

        public void bind() {
            if (!this.bound) {
                this.bound = true;
                this.boundBean = PropertyBinding.this.bean;
                this.boundProperty = PropertyBinding.this.propertyName;
                try {
                    InvokerHelper.invokeMethodSafe(this.boundBean, "addPropertyChangeListener", new Object[]{this.boundProperty, this});
                }
                catch (MissingMethodException mme) {
                    try {
                        InvokerHelper.invokeMethodSafe(this.boundBean, "addPropertyChangeListener", new Object[]{this});
                    }
                    catch (MissingMethodException mme2) {
                        throw new RuntimeException("Properties in beans of type " + PropertyBinding.this.bean.getClass().getName() + " are not observable in any capacity (no PropertyChangeListener support).");
                    }
                }
            }
        }

        public void unbind() {
            if (this.bound) {
                try {
                    InvokerHelper.invokeMethodSafe(this.boundBean, "removePropertyChangeListener", new Object[]{this.boundProperty, this});
                }
                catch (MissingMethodException mme) {
                    mme.printStackTrace();
                    try {
                        InvokerHelper.invokeMethodSafe(this.boundBean, "removePropertyChangeListener", new Object[]{this});
                    }
                    catch (MissingMethodException mme2) {
                        mme2.printStackTrace();
                    }
                }
                this.boundBean = null;
                this.boundProperty = null;
                this.bound = false;
            }
        }

        public void rebind() {
            if (this.bound) {
                this.unbind();
                this.bind();
            }
        }
    }
}

