/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.Reflector;

public class MetaMethod
implements Cloneable {
    private String name;
    private Class callClass;
    private Class declaringClass;
    private Class interfaceClass;
    private Class returnType;
    private int modifiers;
    private Reflector reflector;
    private int methodIndex;
    private Method method;
    protected ParameterTypes paramTypes;

    public MetaMethod(String name, Class declaringClass, CachedClass[] parameterTypes, Class returnType, int modifiers) {
        this.name = name;
        this.callClass = declaringClass;
        this.declaringClass = declaringClass;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.paramTypes = new ParameterTypes(parameterTypes);
    }

    public MetaMethod(Method method, CachedClass[] parameterTypes) {
        this(method.getName(), method.getDeclaringClass(), parameterTypes, method.getReturnType(), method.getModifiers());
        this.method = method;
    }

    public MetaMethod(MetaMethod metaMethod) {
        this(metaMethod.method, metaMethod.getParameterTypes());
    }

    public void checkParameters(Class[] arguments) {
        if (!MetaClassHelper.isValidMethod(this.getParameterTypes(), arguments, false)) {
            throw new IllegalArgumentException("Parameters to method: " + this.getName() + " do not match types: " + InvokerHelper.toString(this.getParameterTypes()) + " for arguments: " + InvokerHelper.toString(arguments));
        }
    }

    public Object invoke(Object object, Object[] arguments) {
        try {
            if (this.reflector != null) {
                return this.reflector.invoke(this, object, arguments);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MetaMethod.this.method.setAccessible(true);
                    return null;
                }
            });
            return this.method.invoke(object, arguments);
        }
        catch (InvocationTargetException ite) {
            throw new InvokerInvocationException(ite.getCause());
        }
        catch (Exception e) {
            throw new InvokerInvocationException(e);
        }
    }

    public Class getCallClass() {
        return this.callClass;
    }

    public void setCallClass(Class c) {
        this.callClass = c;
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public void setMethodIndex(int methodIndex) {
        this.methodIndex = methodIndex;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    public boolean isMethod(Method method) {
        return this.name.equals(method.getName()) && this.modifiers == method.getModifiers() && this.returnType.equals(method.getReturnType()) && this.equal(this.getParameterTypes(), method.getParameterTypes());
    }

    protected boolean equal(CachedClass[] a, Class[] b) {
        if (a.length == b.length) {
            int size = a.length;
            for (int i = 0; i < size; ++i) {
                if (a[i].cachedClass.equals(b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean equal(CachedClass[] a, CachedClass[] b) {
        if (a.length == b.length) {
            int size = a.length;
            for (int i = 0; i < size; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[name: " + this.name + " params: " + InvokerHelper.toString(this.getParameterTypes()) + " returns: " + this.returnType + " owner: " + this.callClass + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new GroovyRuntimeException("This should never happen", e);
        }
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isSame(MetaMethod method) {
        return this.name.equals(method.getName()) && this.compatibleModifiers(this.modifiers, method.getModifiers()) && this.returnType.equals(method.getReturnType()) && this.equal(this.getParameterTypes(), method.getParameterTypes());
    }

    protected boolean compatibleModifiers(int modifiersA, int modifiersB) {
        int mask = 15;
        return (modifiersA & mask) == (modifiersB & mask);
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public boolean isCacheable() {
        return true;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public final CachedClass[] getParameterTypes() {
        return this.paramTypes.getParameterTypes();
    }

    public final ParameterTypes getParamTypes() {
        return this.paramTypes;
    }

    public Class[] getNativeParameterTypes() {
        return this.paramTypes.getNativeParameterTypes();
    }
}

