/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.ClassCompletionVerifier;
import org.codehaus.groovy.classgen.ExtendedVerifier;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.LabelVerifier;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.GroovyClass;

public class CompilationUnit
extends ProcessingUnit {
    protected HashMap sources;
    protected Map summariesBySourceName;
    protected Map summariesByPublicClassName;
    protected Map classSourcesByPublicClassName;
    protected ArrayList names;
    protected LinkedList queuedSources;
    protected CompileUnit ast;
    protected ArrayList generatedClasses;
    protected Verifier verifier;
    protected boolean debug;
    protected boolean configured;
    protected ClassgenCallback classgenCallback;
    protected ProgressCallback progressCallback;
    protected ResolveVisitor resolveVisitor;
    LinkedList[] phaseOperations;
    private SourceUnitOperation resolve = new SourceUnitOperation(){

        public void call(SourceUnit source) throws CompilationFailedException {
            List classes = source.ast.getClasses();
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                ClassNode node = (ClassNode)it.next();
                VariableScopeVisitor scopeVisitor = new VariableScopeVisitor(source);
                scopeVisitor.visitClass(node);
                CompilationUnit.this.resolveVisitor.startResolving(node, source);
            }
        }
    };
    private SourceUnitOperation convert = new SourceUnitOperation(){

        public void call(SourceUnit source) throws CompilationFailedException {
            source.convert();
            CompilationUnit.this.ast.addModule(source.getAST());
            if (CompilationUnit.this.progressCallback != null) {
                CompilationUnit.this.progressCallback.call(source, CompilationUnit.this.phase);
            }
        }
    };
    private GroovyClassOperation output = new GroovyClassOperation(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(GroovyClass gclass) throws CompilationFailedException {
            boolean failures = false;
            String name = gclass.getName().replace('.', File.separatorChar) + ".class";
            File path = new File(CompilationUnit.this.configuration.getTargetDirectory(), name);
            File directory = path.getParentFile();
            if (directory != null && !directory.exists()) {
                directory.mkdirs();
            }
            byte[] bytes = gclass.getBytes();
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(path);
                stream.write(bytes, 0, bytes.length);
            }
            catch (IOException e) {
                CompilationUnit.this.getErrorCollector().addError(Message.create(e.getMessage(), CompilationUnit.this));
                failures = true;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    };
    private SourceUnitOperation compileCompleteCheck = new SourceUnitOperation(){

        public void call(SourceUnit source) throws CompilationFailedException {
            List classes = source.ast.getClasses();
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                ClassNode node = (ClassNode)it.next();
                CompileUnit cu = node.getCompileUnit();
                Iterator iter = cu.iterateClassNodeToCompile();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    SourceUnit su = CompilationUnit.this.ast.getScriptSourceLocation(name);
                    List classesInSourceUnit = su.ast.getClasses();
                    StringBuffer message = new StringBuffer();
                    message.append("Compilation incomplete: expected to find the class ").append(name).append(" in ").append(su.getName());
                    if (classesInSourceUnit.size() == 0) {
                        message.append(", but the file seems not to contain any classes");
                    } else {
                        message.append(", but the file contains the classes: ");
                        boolean first = true;
                        Iterator suClassesIter = classesInSourceUnit.iterator();
                        while (suClassesIter.hasNext()) {
                            ClassNode cn = (ClassNode)suClassesIter.next();
                            if (!first) {
                                message.append(", ");
                            } else {
                                first = false;
                            }
                            message.append(cn.getName());
                        }
                    }
                    CompilationUnit.this.getErrorCollector().addErrorAndContinue(new SimpleMessage(message.toString(), CompilationUnit.this));
                    iter.remove();
                }
            }
        }
    };
    private PrimaryClassNodeOperation classgen = new PrimaryClassNodeOperation(){

        public boolean needSortedInput() {
            return true;
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            String sourceName;
            try {
                CompilationUnit.this.verifier.visitClass(classNode);
            }
            catch (GroovyRuntimeException rpe) {
                ASTNode node = rpe.getNode();
                CompilationUnit.this.getErrorCollector().addError(new SyntaxException(rpe.getMessage(), null, node.getLineNumber(), node.getColumnNumber()), source);
            }
            LabelVerifier lv = new LabelVerifier(source);
            lv.visitClass(classNode);
            ClassCompletionVerifier completionVerifier = new ClassCompletionVerifier(source);
            completionVerifier.visitClass(classNode);
            ExtendedVerifier xverifier = new ExtendedVerifier(source);
            xverifier.visitClass(classNode);
            CompilationUnit.this.getErrorCollector().failIfErrors();
            ClassVisitor visitor = CompilationUnit.this.createClassVisitor();
            String string = sourceName = source == null ? classNode.getModule().getDescription() : source.getName();
            if (sourceName != null) {
                sourceName = sourceName.substring(Math.max(sourceName.lastIndexOf(92), sourceName.lastIndexOf(47)) + 1);
            }
            AsmClassGenerator generator = new AsmClassGenerator(context, visitor, CompilationUnit.this.classLoader, sourceName);
            ((ClassCodeVisitorSupport)generator).visitClass(classNode);
            byte[] bytes = ((ClassWriter)visitor).toByteArray();
            CompilationUnit.this.generatedClasses.add(new GroovyClass(classNode.getName(), bytes));
            if (CompilationUnit.this.classgenCallback != null) {
                CompilationUnit.this.classgenCallback.call(visitor, classNode);
            }
            LinkedList innerClasses = generator.getInnerClasses();
            while (!innerClasses.isEmpty()) {
                CompilationUnit.this.classgen.call(source, context, (ClassNode)innerClasses.removeFirst());
            }
        }
    };
    private SourceUnitOperation mark = new SourceUnitOperation(){

        public void call(SourceUnit source) throws CompilationFailedException {
            if (source.phase < CompilationUnit.this.phase) {
                source.gotoPhase(CompilationUnit.this.phase);
            }
            if (source.phase == CompilationUnit.this.phase && CompilationUnit.this.phaseComplete && !source.phaseComplete) {
                source.completePhase();
            }
        }
    };

    public CompilationUnit() {
        this((CompilerConfiguration)null, (CodeSource)null, (GroovyClassLoader)null);
    }

    public CompilationUnit(GroovyClassLoader loader) {
        this(null, null, loader);
    }

    public CompilationUnit(CompilerConfiguration configuration) {
        this(configuration, (CodeSource)null, (GroovyClassLoader)null);
    }

    public CompilationUnit(CompilerConfiguration configuration, CodeSource security, GroovyClassLoader loader) {
        super(configuration, loader, null);
        this.names = new ArrayList();
        this.queuedSources = new LinkedList();
        this.sources = new HashMap();
        this.summariesBySourceName = new HashMap();
        this.summariesByPublicClassName = new HashMap();
        this.classSourcesByPublicClassName = new HashMap();
        this.ast = new CompileUnit(this.classLoader, security, this.configuration);
        this.generatedClasses = new ArrayList();
        this.verifier = new Verifier();
        this.resolveVisitor = new ResolveVisitor(this);
        this.phaseOperations = new LinkedList[10];
        for (int i = 0; i < this.phaseOperations.length; ++i) {
            this.phaseOperations[i] = new LinkedList();
        }
        this.addPhaseOperation(new SourceUnitOperation(){

            public void call(SourceUnit source) throws CompilationFailedException {
                source.parse();
            }
        }, 2);
        this.addPhaseOperation(this.convert, 3);
        this.addPhaseOperation(this.resolve, 4);
        this.addPhaseOperation(this.compileCompleteCheck, 5);
        this.addPhaseOperation(this.classgen, 7);
        this.addPhaseOperation(this.output);
        this.classgenCallback = null;
    }

    public void addPhaseOperation(SourceUnitOperation op, int phase) {
        if (phase < 0 || phase > 9) {
            throw new IllegalArgumentException("phase " + phase + " is unknown");
        }
        this.phaseOperations[phase].add(op);
    }

    public void addPhaseOperation(PrimaryClassNodeOperation op, int phase) {
        if (phase < 0 || phase > 9) {
            throw new IllegalArgumentException("phase " + phase + " is unknown");
        }
        this.phaseOperations[phase].add(op);
    }

    public void addPhaseOperation(GroovyClassOperation op) {
        this.phaseOperations[8].addFirst(op);
    }

    public void configure(CompilerConfiguration configuration) {
        super.configure(configuration);
        this.debug = configuration.getDebug();
        if (!this.configured && this.classLoader instanceof GroovyClassLoader) {
            this.appendCompilerConfigurationClasspathToClassLoader(configuration, this.classLoader);
        }
        this.configured = true;
    }

    private void appendCompilerConfigurationClasspathToClassLoader(CompilerConfiguration configuration, GroovyClassLoader classLoader) {
    }

    public CompileUnit getAST() {
        return this.ast;
    }

    public Map getSummariesBySourceName() {
        return this.summariesBySourceName;
    }

    public Map getSummariesByPublicClassName() {
        return this.summariesByPublicClassName;
    }

    public Map getClassSourcesByPublicClassName() {
        return this.classSourcesByPublicClassName;
    }

    public boolean isPublicClass(String className) {
        return this.summariesByPublicClassName.containsKey(className);
    }

    public List getClasses() {
        return this.generatedClasses;
    }

    public ClassNode getFirstClassNode() {
        return (ClassNode)((ModuleNode)this.ast.getModules().get(0)).getClasses().get(0);
    }

    public ClassNode getClassNode(final String name) {
        ClassNode[] result;
        block2: {
            result = new ClassNode[]{null};
            PrimaryClassNodeOperation handler = new PrimaryClassNodeOperation(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
                    if (classNode.getName().equals(name)) {
                        result[0] = classNode;
                    }
                }
            };
            try {
                this.applyToPrimaryClassNodes(handler);
            }
            catch (CompilationFailedException e) {
                if (!this.debug) break block2;
                e.printStackTrace();
            }
        }
        return result[0];
    }

    public void addSources(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            this.addSource(file);
        }
    }

    public void addSources(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addSource(files[i]);
        }
    }

    public SourceUnit addSource(File file) {
        return this.addSource(new SourceUnit(file, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(URL url) {
        return this.addSource(new SourceUnit(url, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(String name, InputStream stream) {
        InputStreamReaderSource source = new InputStreamReaderSource(stream, this.configuration);
        return this.addSource(new SourceUnit(name, source, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(SourceUnit source) {
        String name = source.getName();
        source.setClassLoader(this.classLoader);
        Iterator iter = this.queuedSources.iterator();
        while (iter.hasNext()) {
            SourceUnit su = (SourceUnit)iter.next();
            if (!name.equals(su.getName())) continue;
            return su;
        }
        this.queuedSources.add(source);
        return source;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator nameIterator;
            {
                this.nameIterator = CompilationUnit.this.names.iterator();
            }

            public boolean hasNext() {
                return this.nameIterator.hasNext();
            }

            public Object next() {
                String name = (String)this.nameIterator.next();
                return CompilationUnit.this.sources.get(name);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addClassNode(ClassNode node) {
        ModuleNode module = new ModuleNode(this.ast);
        this.ast.addModule(module);
        module.addClass(node);
    }

    public void setClassgenCallback(ClassgenCallback visitor) {
        this.classgenCallback = visitor;
    }

    public void setProgressCallback(ProgressCallback callback) {
        this.progressCallback = callback;
    }

    public void compile() throws CompilationFailedException {
        this.compile(9);
    }

    public void compile(int throughPhase) throws CompilationFailedException {
        this.gotoPhase(1);
        throughPhase = Math.min(throughPhase, 9);
        while (throughPhase >= this.phase && this.phase <= 9) {
            Iterator it = this.phaseOperations[this.phase].iterator();
            while (it.hasNext()) {
                Object operation = it.next();
                if (operation instanceof PrimaryClassNodeOperation) {
                    this.applyToPrimaryClassNodes((PrimaryClassNodeOperation)operation);
                    continue;
                }
                if (operation instanceof SourceUnitOperation) {
                    this.applyToSourceUnits((SourceUnitOperation)operation);
                    continue;
                }
                this.applyToGeneratedGroovyClasses((GroovyClassOperation)operation);
            }
            if (this.progressCallback != null) {
                this.progressCallback.call(this, this.phase);
            }
            this.completePhase();
            this.applyToSourceUnits(this.mark);
            if (this.dequeued()) continue;
            this.gotoPhase(this.phase + 1);
            if (this.phase != 7) continue;
            this.sortClasses();
        }
        this.errorCollector.failIfErrors();
    }

    private void sortClasses() throws CompilationFailedException {
        Iterator modules = this.ast.getModules().iterator();
        while (modules.hasNext()) {
            ModuleNode module = (ModuleNode)modules.next();
            List classes = module.getClasses();
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                ClassNode start;
                ClassNode cn = start = (ClassNode)iter.next();
                HashSet<String> parents = new HashSet<String>();
                do {
                    if (parents.contains(cn.getName())) {
                        this.getErrorCollector().addErrorAndContinue(new SimpleMessage("cyclic inheritance involving " + cn.getName() + " in class " + start.getName(), this));
                        cn = null;
                        continue;
                    }
                    parents.add(cn.getName());
                    cn = cn.getSuperClass();
                } while (cn != null);
            }
            this.errorCollector.failIfErrors();
            module.sortClasses();
        }
    }

    protected boolean dequeued() throws CompilationFailedException {
        boolean dequeue;
        boolean bl = dequeue = !this.queuedSources.isEmpty();
        while (!this.queuedSources.isEmpty()) {
            SourceUnit su = (SourceUnit)this.queuedSources.removeFirst();
            String name = su.getName();
            this.names.add(name);
            this.sources.put(name, su);
        }
        if (dequeue) {
            this.gotoPhase(1);
        }
        return dequeue;
    }

    protected ClassVisitor createClassVisitor() {
        return new ClassWriter(true);
    }

    protected void mark() throws CompilationFailedException {
        this.applyToSourceUnits(this.mark);
    }

    public void applyToSourceUnits(SourceUnitOperation body) throws CompilationFailedException {
        Iterator keys = this.names.iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            SourceUnit source = (SourceUnit)this.sources.get(name);
            if (source.phase >= this.phase && (source.phase != this.phase || source.phaseComplete)) continue;
            try {
                body.call(source);
            }
            catch (CompilationFailedException e) {
                throw e;
            }
            catch (Exception e) {
                GroovyBugError gbe = new GroovyBugError(e);
                this.changeBugText(gbe, source);
                throw gbe;
            }
            catch (GroovyBugError e) {
                this.changeBugText(e, source);
                throw e;
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    private List getPrimaryClassNodes(boolean sort) {
        ArrayList<ClassNode> unsorted = new ArrayList<ClassNode>();
        Iterator modules = this.ast.getModules().iterator();
        while (modules.hasNext()) {
            ModuleNode module = (ModuleNode)modules.next();
            Iterator classNodes = module.getClasses().iterator();
            while (classNodes.hasNext()) {
                ClassNode classNode = (ClassNode)classNodes.next();
                unsorted.add(classNode);
            }
        }
        if (!sort) {
            return unsorted;
        }
        int[] indexClass = new int[unsorted.size()];
        int[] indexInterface = new int[unsorted.size()];
        int i = 0;
        Iterator iter = unsorted.iterator();
        while (iter.hasNext()) {
            ClassNode node = (ClassNode)iter.next();
            int count = 0;
            for (ClassNode element = node; element != null; element = element.getSuperClass()) {
                ++count;
            }
            if (node.isInterface()) {
                indexInterface[i] = count;
                indexClass[i] = -1;
            } else {
                indexClass[i] = count;
                indexInterface[i] = -1;
            }
            ++i;
        }
        List sorted = this.getSorted(indexInterface, unsorted);
        sorted.addAll(this.getSorted(indexClass, unsorted));
        return sorted;
    }

    private List getSorted(int[] index, List unsorted) {
        ArrayList sorted = new ArrayList(unsorted.size());
        boolean start = false;
        for (int i = 0; i < unsorted.size(); ++i) {
            int min = -1;
            for (int j = 0; j < unsorted.size(); ++j) {
                if (index[j] == -1) continue;
                if (min == -1) {
                    min = j;
                    continue;
                }
                if (index[j] >= index[min]) continue;
                min = j;
            }
            if (min == -1) break;
            sorted.add(unsorted.get(min));
            index[min] = -1;
        }
        return sorted;
    }

    public void applyToPrimaryClassNodes(PrimaryClassNodeOperation body) throws CompilationFailedException {
        Iterator classNodes = this.getPrimaryClassNodes(body.needSortedInput()).iterator();
        while (classNodes.hasNext()) {
            SourceUnit context = null;
            try {
                ClassNode classNode = (ClassNode)classNodes.next();
                context = classNode.getModule().getContext();
                if (context != null && context.phase > this.phase) continue;
                body.call(context, new GeneratorContext(this.ast), classNode);
            }
            catch (CompilationFailedException e) {
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (GroovyBugError e) {
                this.changeBugText(e, context);
                throw e;
            }
            catch (Exception e) {
                ErrorCollector nestedCollector = null;
                for (Throwable next = e.getCause(); next != e && next != null; next = next.getCause()) {
                    if (!(next instanceof MultipleCompilationErrorsException)) continue;
                    MultipleCompilationErrorsException mcee = (MultipleCompilationErrorsException)next;
                    nestedCollector = mcee.collector;
                    break;
                }
                if (nestedCollector != null) {
                    this.getErrorCollector().addCollectorContents(nestedCollector);
                    continue;
                }
                this.getErrorCollector().addError(new ExceptionMessage(e, this.configuration.getDebug(), this));
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    public void applyToGeneratedGroovyClasses(GroovyClassOperation body) throws CompilationFailedException {
        if (!(this.phase == 8 || this.phase == 7 && this.phaseComplete)) {
            throw new GroovyBugError("CompilationUnit not ready for output(). Current phase=" + this.getPhaseDescription());
        }
        boolean failures = false;
        Iterator iterator = this.generatedClasses.iterator();
        while (iterator.hasNext()) {
            GroovyClass gclass = (GroovyClass)iterator.next();
            try {
                body.call(gclass);
            }
            catch (CompilationFailedException e) {
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (GroovyBugError e) {
                this.changeBugText(e, null);
                throw e;
            }
            catch (Exception e) {
                GroovyBugError gbe = new GroovyBugError(e);
                throw gbe;
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    private void changeBugText(GroovyBugError e, SourceUnit context) {
        e.setBugText("exception in phase '" + this.getPhaseDescription() + "' in source unit '" + (context != null ? context.getName() : "?") + "' " + e.getBugText());
    }

    public static abstract class GroovyClassOperation {
        public abstract void call(GroovyClass var1) throws CompilationFailedException;
    }

    public static abstract class PrimaryClassNodeOperation {
        public abstract void call(SourceUnit var1, GeneratorContext var2, ClassNode var3) throws CompilationFailedException;

        public boolean needSortedInput() {
            return false;
        }
    }

    public static abstract class SourceUnitOperation {
        public abstract void call(SourceUnit var1) throws CompilationFailedException;
    }

    public static abstract class ProgressCallback {
        public abstract void call(ProcessingUnit var1, int var2) throws CompilationFailedException;
    }

    public static abstract class ClassgenCallback {
        public abstract void call(ClassVisitor var1, ClassNode var2) throws CompilationFailedException;
    }
}

