/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx.controller;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.controller.ActionFactory;
import griffon.core.controller.ActionMetadataFactory;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.TypeUtils;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.controller.AbstractActionManager;
import org.codehaus.griffon.runtime.javafx.controller.JavaFXGriffonControllerAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFXActionManager
extends AbstractActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFXActionManager.class);
    private static final String EMPTY_STRING = "";
    private static final String DOT = ".";
    private static final String EQUALS = " = ";
    private static final String KEY_NAME = "name";
    private static final String KEY_ACCELERATOR = "accelerator";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ICON = "icon";
    private static final String KEY_IMAGE = "image";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_SELECTED = "selected";
    private static final String KEY_VISIBLE = "visible";
    private static final String KEY_STYLE_CLASS = "styleclass";
    private static final String KEY_STYLE = "style";
    private static final String KEY_GRAPHIC_STYLE_CLASS = "graphic_styleclass";
    private static final String KEY_GRAPHIC_STYLE = "graphic_style";
    private static final String KEY_CTRL = "ctrl";
    private static final String KEY_META = "meta";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    @Inject
    public JavaFXActionManager(@Nonnull GriffonApplication application, @Nonnull ActionFactory actionFactory, @Nonnull ActionMetadataFactory actionMetadataFactory) {
        super(application, actionFactory, actionMetadataFactory);
    }

    protected void doConfigureAction(@Nonnull Action action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        controller.getApplication().addPropertyChangeListener("locale", evt -> this.configureAction((JavaFXGriffonControllerAction)action, controller, normalizeNamed, keyPrefix));
        this.configureAction((JavaFXGriffonControllerAction)action, controller, normalizeNamed, keyPrefix);
    }

    protected void configureAction(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        this.resolveName(action, controller, normalizeNamed, keyPrefix);
        this.resolveAccelerator(action, controller, normalizeNamed, keyPrefix);
        this.resolveDescription(action, controller, normalizeNamed, keyPrefix);
        this.resolveIcon(action, controller, normalizeNamed, keyPrefix);
        this.resolveImage(action, controller, normalizeNamed, keyPrefix);
        this.resolveEnabled(action, controller, normalizeNamed, keyPrefix);
        this.resolveSelected(action, controller, normalizeNamed, keyPrefix);
        this.resolveVisible(action, controller, normalizeNamed, keyPrefix);
        this.resolveStyleClass(action, controller, normalizeNamed, keyPrefix);
        this.resolveStyle(action, controller, normalizeNamed, keyPrefix);
        this.resolveGraphicStyleClass(action, controller, normalizeNamed, keyPrefix);
        this.resolveGraphicStyle(action, controller, normalizeNamed, keyPrefix);
    }

    protected void resolveName(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsActionName = this.msg(keyPrefix, normalizeNamed, KEY_NAME, GriffonNameUtils.getNaturalName((String)normalizeNamed));
        if (GriffonNameUtils.isNotBlank((String)rsActionName)) {
            this.trace(keyPrefix + normalizeNamed, KEY_NAME, rsActionName);
            action.setName(rsActionName);
        }
    }

    protected void resolveAccelerator(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsAccelerator = this.msg(keyPrefix, normalizeNamed, KEY_ACCELERATOR, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsAccelerator)) {
            if (!GriffonApplicationUtils.isMacOSX() && rsAccelerator.contains(KEY_META) && !rsAccelerator.contains(KEY_CTRL)) {
                rsAccelerator = rsAccelerator.replace(KEY_META, KEY_CTRL);
            }
            this.trace(keyPrefix + normalizeNamed, KEY_ACCELERATOR, rsAccelerator);
            action.setAccelerator(rsAccelerator);
        }
    }

    protected void resolveDescription(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsDescription = this.msg(keyPrefix, normalizeNamed, KEY_DESCRIPTION, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsDescription)) {
            this.trace(keyPrefix + normalizeNamed, KEY_DESCRIPTION, rsDescription);
            action.setDescription(rsDescription);
        }
    }

    protected void resolveIcon(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsIcon = this.msg(keyPrefix, normalizeNamed, KEY_ICON, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsIcon)) {
            this.trace(keyPrefix + normalizeNamed, KEY_ICON, rsIcon);
            action.setIcon(rsIcon);
        }
    }

    protected void resolveImage(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsImage = this.msg(keyPrefix, normalizeNamed, KEY_IMAGE, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsImage)) {
            this.trace(keyPrefix + normalizeNamed, KEY_IMAGE, rsImage);
            action.setImage(rsImage);
        }
    }

    protected void resolveEnabled(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsEnabled = this.msg(keyPrefix, normalizeNamed, KEY_ENABLED, TRUE);
        if (GriffonNameUtils.isNotBlank((String)rsEnabled)) {
            this.trace(keyPrefix + normalizeNamed, KEY_ENABLED, rsEnabled);
            action.setEnabled(TypeUtils.castToBoolean((Object)rsEnabled));
        }
    }

    protected void resolveSelected(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsSelected = this.msg(keyPrefix, normalizeNamed, KEY_SELECTED, FALSE);
        if (GriffonNameUtils.isNotBlank((String)rsSelected)) {
            this.trace(keyPrefix + normalizeNamed, KEY_SELECTED, rsSelected);
            action.setSelected(TypeUtils.castToBoolean((Object)rsSelected));
        }
    }

    protected void resolveVisible(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsVisible = this.msg(keyPrefix, normalizeNamed, KEY_VISIBLE, TRUE);
        if (GriffonNameUtils.isNotBlank((String)rsVisible)) {
            this.trace(keyPrefix + normalizeNamed, KEY_VISIBLE, rsVisible);
            action.setVisible(TypeUtils.castToBoolean((Object)rsVisible));
        }
    }

    protected void resolveStyleClass(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsStyleClass = this.msg(keyPrefix, normalizeNamed, KEY_STYLE_CLASS, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsStyleClass)) {
            this.trace(keyPrefix + normalizeNamed, KEY_STYLE_CLASS, rsStyleClass);
            action.setStyleClass(rsStyleClass);
        }
    }

    protected void resolveStyle(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsStyle = this.msg(keyPrefix, normalizeNamed, KEY_STYLE, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsStyle)) {
            this.trace(keyPrefix + normalizeNamed, KEY_STYLE, rsStyle);
            action.setStyle(rsStyle);
        }
    }

    protected void resolveGraphicStyleClass(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsGraphicStyleClass = this.msg(keyPrefix, normalizeNamed, KEY_GRAPHIC_STYLE_CLASS, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsGraphicStyleClass)) {
            this.trace(keyPrefix + normalizeNamed, KEY_GRAPHIC_STYLE_CLASS, rsGraphicStyleClass);
            action.setGraphicStyleClass(rsGraphicStyleClass);
        }
    }

    protected void resolveGraphicStyle(@Nonnull JavaFXGriffonControllerAction action, @Nonnull GriffonController controller, @Nonnull String normalizeNamed, @Nonnull String keyPrefix) {
        String rsGraphicStyle = this.msg(keyPrefix, normalizeNamed, KEY_GRAPHIC_STYLE, EMPTY_STRING);
        if (GriffonNameUtils.isNotBlank((String)rsGraphicStyle)) {
            this.trace(keyPrefix + normalizeNamed, KEY_GRAPHIC_STYLE, rsGraphicStyle);
            action.setGraphicStyle(rsGraphicStyle);
        }
    }

    protected void trace(@Nonnull String actionKey, @Nonnull String key, @Nonnull String value) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(actionKey + DOT + key + EQUALS + value);
        }
    }
}

