/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonClass;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.exceptions.GriffonException;
import griffon.javafx.artifact.JavaFXGriffonView;
import griffon.javafx.support.ActionMatcher;
import griffon.javafx.support.GriffonBuilderFactory;
import griffon.javafx.support.JavaFXAction;
import griffon.javafx.support.JavaFXUtils;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.BuilderFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.artifact.AbstractGriffonView;

public abstract class AbstractJavaFXGriffonView
extends AbstractGriffonView
implements JavaFXGriffonView {
    private static final String FXML_SUFFIX = ".fxml";
    @Inject
    protected ActionMatcher actionMatcher;

    public AbstractJavaFXGriffonView() {
    }

    @Inject
    @Deprecated
    public AbstractJavaFXGriffonView(@Nonnull GriffonApplication application) {
        super(application);
    }

    @Nonnull
    protected Node loadFromFXML() {
        return this.loadFromFXML(this.resolveBasename());
    }

    @Nonnull
    protected Node loadFromFXML(@Nonnull String baseName) {
        GriffonNameUtils.requireNonBlank((String)baseName, (String)"Argument 'baseName' must not be blank");
        if (baseName.endsWith(FXML_SUFFIX)) {
            baseName = ConfigUtils.stripFilenameExtension((String)baseName);
        }
        baseName = baseName.replace('.', '/');
        String viewName = baseName + FXML_SUFFIX;
        String styleName = baseName + ".css";
        URL viewResource = this.getResourceAsURL(viewName);
        if (viewResource == null) {
            throw new IllegalStateException("resource " + viewName + " not found");
        }
        FXMLLoader fxmlLoader = this.createFxmlLoader(viewResource);
        this.configureFxmlLoader(fxmlLoader);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new GriffonException((Throwable)e);
        }
        Parent node = (Parent)fxmlLoader.getRoot();
        URL cssResource = this.getResourceAsURL(styleName);
        if (cssResource != null) {
            String uriToCss = cssResource.toExternalForm();
            node.getStylesheets().add((Object)uriToCss);
        }
        return node;
    }

    @Nonnull
    protected FXMLLoader createFxmlLoader(@Nonnull URL viewResource) {
        return new FXMLLoader(viewResource);
    }

    protected void configureFxmlLoader(@Nonnull FXMLLoader fxmlLoader) {
        fxmlLoader.setBuilderFactory((BuilderFactory)new GriffonBuilderFactory(this.getApplication(), this.getMvcGroup()));
        fxmlLoader.setResources(this.getApplication().getMessageSource().asResourceBundle());
        fxmlLoader.setClassLoader(this.getApplication().getApplicationClassLoader().get());
        fxmlLoader.setControllerFactory(klass -> this.getMvcGroup().getView());
    }

    @Nonnull
    protected String resolveBasename() {
        GriffonClass griffonClass = this.getGriffonClass();
        String packageName = griffonClass.getPackageName();
        String baseName = griffonClass.getLogicalPropertyName();
        if (GriffonNameUtils.isNotBlank((String)packageName)) {
            baseName = packageName + "." + baseName;
        }
        return baseName;
    }

    protected void connectActions(@Nonnull Object node, @Nonnull GriffonController controller) {
        JavaFXUtils.connectActions(node, controller, this.actionMatcher);
    }

    protected void connectMessageSource(@Nonnull Object node) {
        JavaFXUtils.connectMessageSource(node, this.getApplication());
    }

    @Nullable
    protected JavaFXAction toolkitActionFor(@Nonnull GriffonController controller, @Nonnull String actionName) {
        Action action = this.actionFor(controller, actionName);
        return action != null ? (JavaFXAction)action.getToolkitAction() : null;
    }
}

