/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx;

import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.env.ApplicationPhase;
import griffon.core.view.WindowDisplayHandler;
import griffon.javafx.JavaFXWindowDisplayHandler;
import griffon.javafx.JavaFXWindowManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javafx.event.EventHandler;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.core.view.AbstractWindowManager;

public class DefaultJavaFXWindowManager
extends AbstractWindowManager<Window>
implements JavaFXWindowManager {
    private final OnWindowHidingHelper onWindowHiding = new OnWindowHidingHelper();
    private final OnWindowShownHelper onWindowShown = new OnWindowShownHelper();
    private final OnWindowHiddenHelper onWindowHidden = new OnWindowHiddenHelper();

    @Inject
    @Nonnull
    public DefaultJavaFXWindowManager(@Nonnull GriffonApplication application, @Nonnull @Named(value="windowDisplayHandler") JavaFXWindowDisplayHandler windowDisplayHandler) {
        super(application, (WindowDisplayHandler)windowDisplayHandler);
        Objects.requireNonNull(application.getEventRouter(), "Argument 'application.eventRouter' must not be null");
    }

    protected void doAttach(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        window.setOnHiding((EventHandler)this.onWindowHiding);
        window.setOnShown((EventHandler)this.onWindowShown);
        window.setOnHidden((EventHandler)this.onWindowHidden);
    }

    protected void doDetach(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        window.setOnHiding(null);
        window.setOnShown(null);
        window.setOnHidden(null);
    }

    protected boolean isWindowVisible(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        return window.isShowing();
    }

    public void handleClose(@Nonnull Window widget) {
        if (this.getApplication().getPhase() == ApplicationPhase.SHUTDOWN) {
            return;
        }
        ArrayList<Window> visibleWindows = new ArrayList<Window>();
        for (Window window : this.getWindows()) {
            if (!window.isShowing()) continue;
            visibleWindows.add(window);
        }
        if (this.isAutoShutdown() && visibleWindows.size() <= 1 && visibleWindows.contains(widget) && !this.getApplication().shutdown()) {
            this.show(widget);
        }
    }

    private class OnWindowHiddenHelper
    implements EventHandler<WindowEvent> {
        private OnWindowHiddenHelper() {
        }

        public void handle(WindowEvent windowEvent) {
            Window window = (Window)windowEvent.getSource();
            DefaultJavaFXWindowManager.this.event(ApplicationEvent.WINDOW_HIDDEN, Arrays.asList(DefaultJavaFXWindowManager.this.findWindowName(window), window));
        }
    }

    private class OnWindowShownHelper
    implements EventHandler<WindowEvent> {
        private OnWindowShownHelper() {
        }

        public void handle(WindowEvent windowEvent) {
            Window window = (Window)windowEvent.getSource();
            DefaultJavaFXWindowManager.this.event(ApplicationEvent.WINDOW_SHOWN, Arrays.asList(DefaultJavaFXWindowManager.this.findWindowName(window), window));
        }
    }

    private class OnWindowHidingHelper
    implements EventHandler<WindowEvent> {
        private OnWindowHidingHelper() {
        }

        public void handle(WindowEvent event) {
            DefaultJavaFXWindowManager.this.hide((Window)event.getSource());
            DefaultJavaFXWindowManager.this.handleClose((Window)event.getSource());
        }
    }
}

