/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.support;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.controller.ActionManager;
import griffon.core.editors.ValueConversionException;
import griffon.core.i18n.MessageSource;
import griffon.exceptions.InstanceMethodInvocationException;
import griffon.javafx.collections.GriffonFXCollections;
import griffon.javafx.support.ActionMatcher;
import griffon.javafx.support.JavaFXAction;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JavaFXUtils {
    private static final String ERROR_NODE_NULL = "Argument 'node' must not be null";
    private static final String ERROR_CONTROL_NULL = "Argument 'control' must not be null";
    private static final String ERROR_ACTION_NULL = "Argument 'action' must not be null";
    private static final String ERROR_ICON_BLANK = "Argument 'iconUrl' must not be blank";
    private static final String ERROR_ID_BLANK = "Argument 'id' must not be blank";
    private static final String ERROR_URL_BLANK = "Argument 'url' must not be blank";
    private static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";
    private static final String ERROR_ARGS_BLANK = "Argument 'args' must not be blank";
    private static final String ERROR_ROOT_NULL = "Argument 'root' must not be null";
    private static final String ERROR_PREDICATE_NULL = "Argument 'predicate' must not be null";
    private static final String ERROR_CONTROLLER_NULL = "Argument 'controller' must not be null";
    private static final String ERROR_APPLICATION_NULL = "Argument 'application' must not be null";
    private static final String PROPERTY_SUFFIX = "Property";
    private static final String SUFFIX_KEY = "-KEY";
    private static final String SUFFIX_ARGS = "-ARGS";
    private static final String SUFFIX_DEFAULT_VALUE = "-DEFAULT_VALUE";
    private static final ActionMatcher DEFAULT_ACTION_MATCHER = ActionMatcher.DEFAULT;

    private JavaFXUtils() {
    }

    public static void setI18nKey(@Nonnull Labeled node, @Nonnull String key) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_KEY), (Object)key);
    }

    @Nullable
    public static String getI18nKey(@Nonnull Labeled node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_KEY));
    }

    public static void setI18nArgs(@Nonnull Labeled node, @Nullable String args) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)args, (String)ERROR_ARGS_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_ARGS), (Object)args);
    }

    @Nullable
    public static String getI18nArgs(@Nonnull Labeled node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_ARGS));
    }

    public static void setI18nDefaultValue(@Nonnull Labeled node, @Nullable String defaultValue) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE), (Object)defaultValue);
    }

    @Nullable
    public static String getI18nDefaultValue(@Nonnull Labeled node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE));
    }

    public static void setI18nKey(@Nonnull Tab node, @Nonnull String key) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_KEY), (Object)key);
    }

    @Nullable
    public static String getI18nKey(@Nonnull Tab node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_KEY));
    }

    public static void setI18nArgs(@Nonnull Tab node, @Nullable String args) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)args, (String)ERROR_ARGS_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_ARGS), (Object)args);
    }

    @Nullable
    public static String getI18nArgs(@Nonnull Tab node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_ARGS));
    }

    public static void setI18nDefaultValue(@Nonnull Tab node, @Nullable String defaultValue) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE), (Object)defaultValue);
    }

    @Nullable
    public static String getI18nDefaultValue(@Nonnull Tab node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE));
    }

    public static void setI18nKey(@Nonnull MenuItem node, @Nonnull String key) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_KEY), (Object)key);
    }

    @Nullable
    public static String getI18nKey(@Nonnull MenuItem node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_KEY));
    }

    public static void setI18nArgs(@Nonnull MenuItem node, @Nullable String args) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)args, (String)ERROR_ARGS_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_ARGS), (Object)args);
    }

    @Nullable
    public static String getI18nArgs(@Nonnull MenuItem node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_ARGS));
    }

    public static void setI18nDefaultValue(@Nonnull MenuItem node, @Nullable String defaultValue) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE), (Object)defaultValue);
    }

    @Nullable
    public static String getI18nDefaultValue(@Nonnull MenuItem node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE));
    }

    public static void setI18nKey(@Nonnull Axis<?> node, @Nonnull String key) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_KEY), (Object)key);
    }

    @Nullable
    public static String getI18nKey(@Nonnull Axis<?> node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_KEY));
    }

    public static void setI18nArgs(@Nonnull Axis<?> node, @Nullable String args) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)args, (String)ERROR_ARGS_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_ARGS), (Object)args);
    }

    @Nullable
    public static String getI18nArgs(@Nonnull Axis<?> node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_ARGS));
    }

    public static void setI18nDefaultValue(@Nonnull Axis<?> node, @Nullable String defaultValue) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE), (Object)defaultValue);
    }

    @Nullable
    public static String getI18nDefaultValue(@Nonnull Axis<?> node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE));
    }

    public static void setI18nKey(@Nonnull TableColumn<?, ?> node, @Nonnull String key) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_KEY), (Object)key);
    }

    @Nullable
    public static String getI18nKey(@Nonnull TableColumn<?, ?> node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_KEY));
    }

    public static void setI18nArgs(@Nonnull TableColumn<?, ?> node, @Nullable String args) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)args, (String)ERROR_ARGS_BLANK);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_ARGS), (Object)args);
    }

    @Nullable
    public static String getI18nArgs(@Nonnull TableColumn<?, ?> node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_ARGS));
    }

    public static void setI18nDefaultValue(@Nonnull TableColumn<?, ?> node, @Nullable String defaultValue) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        node.getProperties().put((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE), (Object)defaultValue);
    }

    @Nullable
    public static String getI18nDefaultValue(@Nonnull TableColumn<?, ?> node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)(MessageSource.class.getName() + SUFFIX_DEFAULT_VALUE));
    }

    public static void connectMessageSource(@Nonnull Object node, @Nonnull GriffonApplication application) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        Objects.requireNonNull(application, ERROR_APPLICATION_NULL);
        JavaFXUtils.findElements(node, arg -> arg instanceof Labeled && GriffonNameUtils.isNotBlank((String)JavaFXUtils.getI18nKey((Labeled)arg)) || arg instanceof Tab && GriffonNameUtils.isNotBlank((String)JavaFXUtils.getI18nKey((Tab)arg)) || arg instanceof MenuItem && GriffonNameUtils.isNotBlank((String)JavaFXUtils.getI18nKey((MenuItem)arg)) || arg instanceof TableColumn && GriffonNameUtils.isNotBlank((String)JavaFXUtils.getI18nKey((TableColumn)arg)) || arg instanceof Axis && GriffonNameUtils.isNotBlank((String)JavaFXUtils.getI18nKey((Axis)arg))).forEach(element -> {
            if (element instanceof Labeled) {
                JavaFXUtils.doConnectMessageSource((Labeled)element, application);
            } else if (element instanceof Tab) {
                JavaFXUtils.doConnectMessageSource((Tab)element, application);
            } else if (element instanceof MenuItem) {
                JavaFXUtils.doConnectMessageSource((MenuItem)element, application);
            } else if (element instanceof TableColumn) {
                JavaFXUtils.doConnectMessageSource((TableColumn)element, application);
            } else if (element instanceof Axis) {
                JavaFXUtils.doConnectMessageSource((Axis)element, application);
            }
        });
    }

    private static void doConnectMessageSource(@Nonnull Labeled node, @Nonnull GriffonApplication application) {
        application.addPropertyChangeListener("locale", evt -> JavaFXUtils.updateLabeled(node, application));
        JavaFXUtils.updateLabeled(node, application);
    }

    private static void doConnectMessageSource(@Nonnull Tab node, @Nonnull GriffonApplication application) {
        application.addPropertyChangeListener("locale", evt -> JavaFXUtils.updateLabeled(node, application));
        JavaFXUtils.updateLabeled(node, application);
    }

    private static void doConnectMessageSource(@Nonnull MenuItem node, @Nonnull GriffonApplication application) {
        application.addPropertyChangeListener("locale", evt -> JavaFXUtils.updateLabeled(node, application));
        JavaFXUtils.updateLabeled(node, application);
    }

    private static void doConnectMessageSource(@Nonnull TableColumn<?, ?> node, @Nonnull GriffonApplication application) {
        application.addPropertyChangeListener("locale", evt -> JavaFXUtils.updateLabeled(node, application));
        JavaFXUtils.updateLabeled(node, application);
    }

    private static void doConnectMessageSource(@Nonnull Axis<?> node, @Nonnull GriffonApplication application) {
        application.addPropertyChangeListener("locale", evt -> JavaFXUtils.updateLabeled(node, application));
        JavaFXUtils.updateLabeled(node, application);
    }

    private static void updateLabeled(@Nonnull Labeled node, @Nonnull GriffonApplication application) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] argArray;
            String key = JavaFXUtils.getI18nKey(node);
            String args = JavaFXUtils.getI18nArgs(node);
            String defaultValue = JavaFXUtils.getI18nDefaultValue(node);
            Object[] objectArray = argArray = GriffonNameUtils.isBlank((String)args) ? GriffonClassUtils.EMPTY_OBJECT_ARRAY : args.split(",");
            if (GriffonNameUtils.isBlank((String)defaultValue)) {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale()));
            } else {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale(), defaultValue));
            }
        });
    }

    private static void updateLabeled(@Nonnull Tab node, @Nonnull GriffonApplication application) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] argArray;
            String key = JavaFXUtils.getI18nKey(node);
            String args = JavaFXUtils.getI18nArgs(node);
            String defaultValue = JavaFXUtils.getI18nDefaultValue(node);
            Object[] objectArray = argArray = GriffonNameUtils.isBlank((String)args) ? GriffonClassUtils.EMPTY_OBJECT_ARRAY : args.split(",");
            if (GriffonNameUtils.isBlank((String)defaultValue)) {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale()));
            } else {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale(), defaultValue));
            }
        });
    }

    private static void updateLabeled(@Nonnull MenuItem node, @Nonnull GriffonApplication application) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] argArray;
            String key = JavaFXUtils.getI18nKey(node);
            String args = JavaFXUtils.getI18nArgs(node);
            String defaultValue = JavaFXUtils.getI18nDefaultValue(node);
            Object[] objectArray = argArray = GriffonNameUtils.isBlank((String)args) ? GriffonClassUtils.EMPTY_OBJECT_ARRAY : args.split(",");
            if (GriffonNameUtils.isBlank((String)defaultValue)) {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale()));
            } else {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale(), defaultValue));
            }
        });
    }

    private static void updateLabeled(@Nonnull TableColumn<?, ?> node, @Nonnull GriffonApplication application) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] argArray;
            String key = JavaFXUtils.getI18nKey(node);
            String args = JavaFXUtils.getI18nArgs(node);
            String defaultValue = JavaFXUtils.getI18nDefaultValue(node);
            Object[] objectArray = argArray = GriffonNameUtils.isBlank((String)args) ? GriffonClassUtils.EMPTY_OBJECT_ARRAY : args.split(",");
            if (GriffonNameUtils.isBlank((String)defaultValue)) {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale()));
            } else {
                node.setText(application.getMessageSource().getMessage(key, argArray, application.getLocale(), defaultValue));
            }
        });
    }

    private static void updateLabeled(@Nonnull Axis<?> node, @Nonnull GriffonApplication application) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] argArray;
            String key = JavaFXUtils.getI18nKey(node);
            String args = JavaFXUtils.getI18nArgs(node);
            String defaultValue = JavaFXUtils.getI18nDefaultValue(node);
            Object[] objectArray = argArray = GriffonNameUtils.isBlank((String)args) ? GriffonClassUtils.EMPTY_OBJECT_ARRAY : args.split(",");
            if (GriffonNameUtils.isBlank((String)defaultValue)) {
                node.setLabel(application.getMessageSource().getMessage(key, argArray, application.getLocale()));
            } else {
                node.setLabel(application.getMessageSource().getMessage(key, argArray, application.getLocale(), defaultValue));
            }
        });
    }

    public static void setGriffonActionId(@Nonnull Node node, @Nonnull String actionId) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)actionId, (String)ERROR_ID_BLANK);
        node.getProperties().put((Object)Action.class.getName(), (Object)actionId);
    }

    @Nullable
    public static String getGriffonActionId(@Nonnull Node node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return (String)node.getProperties().get((Object)Action.class.getName());
    }

    public static void setGriffonActionId(@Nonnull MenuItem menuItem, @Nonnull String actionId) {
        Objects.requireNonNull(menuItem, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)actionId, (String)ERROR_ID_BLANK);
        menuItem.getProperties().put((Object)Action.class.getName(), (Object)actionId);
    }

    @Nullable
    public static String getGriffonActionId(@Nonnull MenuItem menuItem) {
        Objects.requireNonNull(menuItem, ERROR_NODE_NULL);
        return (String)menuItem.getProperties().get((Object)Action.class.getName());
    }

    @Deprecated
    @Nonnull
    public static <E> ObservableList<E> createJavaFXThreadProxyList(@Nonnull ObservableList<E> source) {
        return GriffonFXCollections.uiThreadAwareObservableList(source);
    }

    @Deprecated
    @Nonnull
    public static <E> ObservableSet<E> createJavaFXThreadProxySet(@Nonnull ObservableSet<E> source) {
        return GriffonFXCollections.uiThreadAwareObservableSet(source);
    }

    @Deprecated
    @Nonnull
    public static <K, V> ObservableMap<K, V> createJavaFXThreadProxyMap(@Nonnull ObservableMap<K, V> source) {
        return GriffonFXCollections.uiThreadAwareObservableMap(source);
    }

    @Nonnull
    public static <B> Property<?> extractProperty(@Nonnull B bean, @Nonnull String propertyName) {
        Objects.requireNonNull(bean, "Argument 'bean' must not be null");
        GriffonNameUtils.requireNonBlank((String)propertyName, (String)"Argument 'propertyName' must not be null");
        if (!propertyName.endsWith(PROPERTY_SUFFIX)) {
            propertyName = propertyName + PROPERTY_SUFFIX;
        }
        try {
            return (Property)GriffonClassUtils.invokeExactInstanceMethod(bean, (String)propertyName);
        }
        catch (InstanceMethodInvocationException e) {
            InstanceMethodInvocationException imie = e;
            try {
                return (Property)GriffonClassUtils.invokeExactInstanceMethod(bean, (String)GriffonClassUtils.getGetterName((String)propertyName));
            }
            catch (InstanceMethodInvocationException e2) {
                throw imie;
            }
        }
    }

    public static void connectActions(@Nonnull Object node, @Nonnull GriffonController controller, @Nonnull ActionMatcher actionMatcher) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        Objects.requireNonNull(controller, ERROR_CONTROLLER_NULL);
        actionMatcher = actionMatcher != null ? actionMatcher : DEFAULT_ACTION_MATCHER;
        ActionManager actionManager = controller.getApplication().getActionManager();
        for (Map.Entry e : actionManager.actionsFor(controller).entrySet()) {
            String actionName = actionManager.normalizeName((String)e.getKey());
            JavaFXAction action = (JavaFXAction)((Action)e.getValue()).getToolkitAction();
            actionMatcher.match(node, actionName, action);
        }
    }

    public static void connectActions(@Nonnull Object node, @Nonnull GriffonController controller) {
        JavaFXUtils.connectActions(node, controller, DEFAULT_ACTION_MATCHER);
    }

    public static void configureControl(@Nonnull Object control, @Nonnull JavaFXAction action) {
        if (control instanceof ButtonBase) {
            JavaFXUtils.configure((ButtonBase)control, action);
        } else if (control instanceof MenuItem) {
            JavaFXUtils.configure((MenuItem)control, action);
        } else if (control instanceof Node) {
            ((Node)control).addEventHandler(ActionEvent.ACTION, JavaFXUtils.wrapAction(action));
        } else {
            try {
                GriffonClassUtils.invokeInstanceMethod((Object)control, (String)"setOnAction", JavaFXUtils.wrapAction(action));
            }
            catch (InstanceMethodInvocationException instanceMethodInvocationException) {
                // empty catch block
            }
        }
    }

    private static EventHandler<ActionEvent> wrapAction(@Nonnull JavaFXAction action) {
        return event -> {
            if (action.isEnabled()) {
                action.getOnAction().handle(event);
            }
        };
    }

    private static void runInsideUIThread(@Nonnull Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static String normalizeStyle(@Nonnull String style, @Nonnull String key, @Nonnull String value) {
        GriffonNameUtils.requireNonBlank((String)style, (String)"Argument 'style' must not be blank");
        GriffonNameUtils.requireNonBlank((String)key, (String)ERROR_KEY_BLANK);
        GriffonNameUtils.requireNonBlank((String)value, (String)"Argument 'value' must not be blank");
        int start = style.indexOf(key);
        if (start != -1) {
            int end = style.indexOf(59, start);
            end = end >= start ? end : style.length() - 1;
            style = style.substring(0, start) + style.substring(end + 1);
        }
        return style + key + ": " + value + ";";
    }

    public static void configure(@Nonnull ToggleButton control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((ButtonBase)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull CheckBox control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((ButtonBase)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull RadioButton control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((ButtonBase)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull ButtonBase control, @Nonnull JavaFXAction action) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        Objects.requireNonNull(action, ERROR_ACTION_NULL);
        action.onActionProperty().addListener((v, o, n) -> control.setOnAction(n));
        control.setOnAction(action.getOnAction());
        action.nameProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setText(n)));
        JavaFXUtils.runInsideUIThread(() -> control.setText(action.getName()));
        action.descriptionProperty().addListener((v, o, n) -> JavaFXUtils.setTooltip((Control)control, n));
        JavaFXUtils.setTooltip((Control)control, action.getDescription());
        action.iconProperty().addListener((v, o, n) -> JavaFXUtils.setIcon((Labeled)control, n));
        if (GriffonNameUtils.isNotBlank((String)action.getIcon())) {
            JavaFXUtils.setIcon((Labeled)control, action.getIcon());
        }
        action.imageProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic((Labeled)control, n));
        if (null != action.getImage()) {
            JavaFXUtils.setGraphic((Labeled)control, action.getImage());
        }
        action.graphicProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic((Labeled)control, n));
        if (null != action.getGraphic()) {
            JavaFXUtils.setGraphic((Labeled)control, action.getGraphic());
        }
        action.enabledProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setDisable(n == false)));
        JavaFXUtils.runInsideUIThread(() -> control.setDisable(!action.isEnabled()));
        action.visibleProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setVisible(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setVisible(action.isVisible()));
        action.styleClassProperty().addListener((v, o, n) -> {
            JavaFXUtils.setStyleClass((Node)control, o, true);
            JavaFXUtils.setStyleClass((Node)control, n);
        });
        JavaFXUtils.setStyleClass((Node)control, action.getStyleClass());
        action.styleProperty().addListener((v, o, n) -> JavaFXUtils.setStyle((Node)control, n));
        JavaFXUtils.setStyle((Node)control, action.getStyle());
        action.graphicStyleClassProperty().addListener((v, o, n) -> {
            JavaFXUtils.setGraphicStyleClass(control, o, true);
            JavaFXUtils.setGraphicStyleClass(control, n);
        });
        JavaFXUtils.setGraphicStyleClass(control, action.getGraphicStyleClass());
        action.graphicStyleProperty().addListener((v, o, n) -> JavaFXUtils.setGraphicStyle(control, n));
        JavaFXUtils.setGraphicStyle(control, action.getGraphicStyle());
    }

    public static void configure(@Nonnull CheckMenuItem control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((MenuItem)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull RadioMenuItem control, @Nonnull JavaFXAction action) {
        JavaFXUtils.configure((MenuItem)control, action);
        action.selectedProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setSelected(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setSelected(action.isSelected()));
    }

    public static void configure(@Nonnull MenuItem control, @Nonnull JavaFXAction action) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        Objects.requireNonNull(action, ERROR_ACTION_NULL);
        action.onActionProperty().addListener((v, o, n) -> control.setOnAction(n));
        control.setOnAction(action.getOnAction());
        action.nameProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setText(n)));
        JavaFXUtils.runInsideUIThread(() -> control.setText(action.getName()));
        action.iconProperty().addListener((v, o, n) -> JavaFXUtils.setIcon(control, n));
        if (GriffonNameUtils.isNotBlank((String)action.getIcon())) {
            JavaFXUtils.setIcon(control, action.getIcon());
        }
        action.imageProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic(control, n));
        if (null != action.getImage()) {
            JavaFXUtils.setGraphic(control, action.getImage());
        }
        action.graphicProperty().addListener((v, o, n) -> JavaFXUtils.setGraphic(control, n));
        if (null != action.getGraphic()) {
            JavaFXUtils.setGraphic(control, action.getGraphic());
        }
        action.enabledProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setDisable(n == false)));
        JavaFXUtils.runInsideUIThread(() -> control.setDisable(!action.getEnabled()));
        action.acceleratorProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setAccelerator(n)));
        JavaFXUtils.runInsideUIThread(() -> control.setAccelerator(action.getAccelerator()));
        action.visibleProperty().addListener((v, o, n) -> JavaFXUtils.runInsideUIThread(() -> control.setVisible(n.booleanValue())));
        JavaFXUtils.runInsideUIThread(() -> control.setVisible(action.isVisible()));
        action.styleClassProperty().addListener((v, o, n) -> {
            JavaFXUtils.setStyleClass(control, o, true);
            JavaFXUtils.setStyleClass(control, n);
        });
        JavaFXUtils.setStyleClass(control, action.getStyleClass());
        action.styleProperty().addListener((v, o, n) -> JavaFXUtils.setStyle(control, n));
        JavaFXUtils.setStyle(control, action.getStyle());
        action.graphicStyleClassProperty().addListener((v, o, n) -> {
            JavaFXUtils.setGraphicStyleClass(control, o, true);
            JavaFXUtils.setGraphicStyleClass(control, n);
        });
        JavaFXUtils.setGraphicStyleClass(control, action.getGraphicStyleClass());
        action.graphicStyleProperty().addListener((v, o, n) -> JavaFXUtils.setGraphicStyle(control, n));
        JavaFXUtils.setGraphicStyle(control, action.getGraphicStyle());
    }

    public static void setStyle(@Nonnull Node node, @Nonnull String style) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)style)) {
            return;
        }
        if (style.startsWith("&")) {
            String nodeStyle = node.getStyle();
            node.setStyle(nodeStyle + (nodeStyle.endsWith(";") ? "" : ";") + style.substring(1));
        } else {
            node.setStyle(style);
        }
    }

    public static void setStyle(@Nonnull MenuItem node, @Nonnull String style) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)style)) {
            return;
        }
        if (style.startsWith("&")) {
            String nodeStyle = node.getStyle();
            node.setStyle(nodeStyle + (nodeStyle.endsWith(";") ? "" : ";") + style.substring(1));
        } else {
            node.setStyle(style);
        }
    }

    public static void setGraphicStyle(@Nonnull ButtonBase node, @Nonnull String graphicStyle) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)graphicStyle)) {
            return;
        }
        if (node.getGraphic() != null) {
            JavaFXUtils.setStyle(node.getGraphic(), graphicStyle);
        }
    }

    public static void setGraphicStyle(@Nonnull MenuItem node, @Nonnull String graphicStyle) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)graphicStyle)) {
            return;
        }
        if (node.getGraphic() != null) {
            JavaFXUtils.setStyle(node.getGraphic(), graphicStyle);
        }
    }

    public static void setStyleClass(@Nonnull Node node, @Nonnull String styleClass) {
        JavaFXUtils.setStyleClass(node, styleClass, false);
    }

    public static void setStyleClass(@Nonnull Node node, @Nonnull String styleClass, boolean remove) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)styleClass)) {
            return;
        }
        ObservableList styleClasses = node.getStyleClass();
        JavaFXUtils.applyStyleClass(styleClass, (ObservableList<String>)styleClasses, remove);
    }

    public static void setStyleClass(@Nonnull MenuItem node, @Nonnull String styleClass) {
        JavaFXUtils.setStyleClass(node, styleClass, false);
    }

    public static void setStyleClass(@Nonnull MenuItem node, @Nonnull String styleClass, boolean remove) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)styleClass)) {
            return;
        }
        ObservableList styleClasses = node.getStyleClass();
        JavaFXUtils.applyStyleClass(styleClass, (ObservableList<String>)styleClasses, remove);
    }

    public static void setGraphicStyleClass(@Nonnull ButtonBase node, @Nonnull String graphicStyleClass) {
        JavaFXUtils.setGraphicStyleClass(node, graphicStyleClass, false);
    }

    public static void setGraphicStyleClass(@Nonnull ButtonBase node, @Nonnull String graphicStyleClass, boolean remove) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)graphicStyleClass) || node.getGraphic() == null) {
            return;
        }
        ObservableList graphicStyleClasses = node.getGraphic().getStyleClass();
        JavaFXUtils.applyStyleClass(graphicStyleClass, (ObservableList<String>)graphicStyleClasses, remove);
    }

    public static void setGraphicStyleClass(@Nonnull MenuItem node, @Nonnull String graphicStyleClass) {
        JavaFXUtils.setGraphicStyleClass(node, graphicStyleClass, false);
    }

    public static void setGraphicStyleClass(@Nonnull MenuItem node, @Nonnull String graphicStyleClass, boolean remove) {
        Objects.requireNonNull(node, ERROR_CONTROL_NULL);
        if (GriffonNameUtils.isBlank((String)graphicStyleClass) || node.getGraphic() == null) {
            return;
        }
        ObservableList graphicStyleClasses = node.getGraphic().getStyleClass();
        JavaFXUtils.applyStyleClass(graphicStyleClass, (ObservableList<String>)graphicStyleClasses, remove);
    }

    private static void applyStyleClass(String styleClass, ObservableList<String> styleClasses, boolean remove) {
        JavaFXUtils.runInsideUIThread(() -> {
            Object[] strings = styleClass.split("[,\\ ]");
            if (remove) {
                styleClasses.removeAll(strings);
            } else {
                LinkedHashSet<String> classes = new LinkedHashSet<String>((Collection<String>)styleClasses);
                for (Object s : strings) {
                    if (GriffonNameUtils.isBlank((String)s)) continue;
                    classes.add(((String)s).trim());
                }
                styleClasses.setAll(classes);
            }
        });
    }

    public static void setTooltip(@Nonnull Control control, @Nullable String text) {
        JavaFXUtils.runInsideUIThread(() -> {
            if (GriffonNameUtils.isBlank((String)text)) {
                return;
            }
            Objects.requireNonNull(control, ERROR_CONTROL_NULL);
            Tooltip tooltip = (Tooltip)control.tooltipProperty().get();
            if (tooltip == null) {
                tooltip = new Tooltip();
                control.tooltipProperty().set((Object)tooltip);
            }
            tooltip.setText(text);
        });
    }

    public static void setIcon(@Nonnull Labeled control, @Nonnull String iconUrl) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        GriffonNameUtils.requireNonBlank((String)iconUrl, (String)ERROR_ICON_BLANK);
        Node graphicNode = JavaFXUtils.resolveIcon(iconUrl);
        if (graphicNode != null) {
            JavaFXUtils.runInsideUIThread(() -> control.graphicProperty().set((Object)graphicNode));
        }
    }

    public static void setIcon(@Nonnull MenuItem control, @Nonnull String iconUrl) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        GriffonNameUtils.requireNonBlank((String)iconUrl, (String)ERROR_ICON_BLANK);
        Node graphicNode = JavaFXUtils.resolveIcon(iconUrl);
        if (graphicNode != null) {
            JavaFXUtils.runInsideUIThread(() -> control.graphicProperty().set((Object)graphicNode));
        }
    }

    public static void setGraphic(@Nonnull Labeled control, @Nullable Image graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                ImageView graphicNode = new ImageView(graphic);
                control.graphicProperty().set((Object)graphicNode);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    public static void setGraphic(@Nonnull MenuItem control, @Nullable Image graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                ImageView graphicNode = new ImageView(graphic);
                control.graphicProperty().set((Object)graphicNode);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    public static void setGraphic(@Nonnull Labeled control, @Nullable Node graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                control.graphicProperty().set((Object)graphic);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    public static void setGraphic(@Nonnull MenuItem control, @Nullable Node graphic) {
        Objects.requireNonNull(control, ERROR_CONTROL_NULL);
        JavaFXUtils.runInsideUIThread(() -> {
            if (graphic != null) {
                control.graphicProperty().set((Object)graphic);
            } else {
                control.graphicProperty().set(null);
            }
        });
    }

    @Nullable
    public static Node resolveIcon(@Nonnull String iconUrl) {
        GriffonNameUtils.requireNonBlank((String)iconUrl, (String)ERROR_URL_BLANK);
        if (iconUrl.contains("|")) {
            return JavaFXUtils.handleAsClassWithArg(iconUrl);
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(iconUrl);
        if (resource != null) {
            return new ImageView(new Image(resource.toString()));
        }
        return null;
    }

    private static Node handleAsClassWithArg(String str) {
        String[] args = str.split("\\|");
        if (args.length == 2) {
            Class<?> iconClass = null;
            try {
                iconClass = JavaFXUtils.class.getClassLoader().loadClass(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw JavaFXUtils.illegalValue(str, Node.class, e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = iconClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw JavaFXUtils.illegalValue(str, Node.class, e);
            }
            try {
                Object o = constructor.newInstance(args[1]);
                if (o instanceof Node) {
                    return (Node)o;
                }
                if (o instanceof Image) {
                    return new ImageView((Image)o);
                }
                throw JavaFXUtils.illegalValue(str, Node.class);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw JavaFXUtils.illegalValue(str, Node.class, e);
            }
        }
        throw JavaFXUtils.illegalValue(str, Node.class);
    }

    @Nullable
    public static Node findNode(@Nonnull Node root, @Nonnull String id) {
        Node found;
        TableView tableView;
        Node placeholder;
        Iterator found2;
        Node found3;
        TabPane parent;
        Objects.requireNonNull(root, ERROR_ROOT_NULL);
        GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_BLANK);
        if (id.equals(root.getId())) {
            return root;
        }
        if (root instanceof TabPane) {
            parent = (TabPane)root;
            for (Tab child : parent.getTabs()) {
                if (child.getContent() == null || (found3 = JavaFXUtils.findNode(child.getContent(), id)) == null) continue;
                return found3;
            }
        } else if (root instanceof TitledPane) {
            parent = (TitledPane)root;
            if (parent.getContent() != null && (found2 = JavaFXUtils.findNode(parent.getContent(), id)) != null) {
                return found2;
            }
        } else if (root instanceof Accordion) {
            parent = (Accordion)root;
            for (Tab child : parent.getPanes()) {
                found3 = JavaFXUtils.findNode((Node)child, id);
                if (found3 == null) continue;
                return found3;
            }
        } else if (root instanceof SplitPane) {
            parent = (SplitPane)root;
            for (Tab child : parent.getItems()) {
                found3 = JavaFXUtils.findNode((Node)child, id);
                if (found3 == null) continue;
                return found3;
            }
        } else if (root instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)root;
            if (scrollPane.getContent() != null && (found2 = JavaFXUtils.findNode(scrollPane.getContent(), id)) != null) {
                return found2;
            }
        } else if (root instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)root;
            for (Tab child : toolBar.getItems()) {
                found3 = JavaFXUtils.findNode((Node)child, id);
                if (found3 == null) continue;
                return found3;
            }
        } else if (root instanceof ButtonBar) {
            ButtonBar buttonBar = (ButtonBar)root;
            for (Tab child : buttonBar.getButtons()) {
                found3 = JavaFXUtils.findNode((Node)child, id);
                if (found3 == null) continue;
                return found3;
            }
        } else if (root instanceof TableView && (placeholder = (tableView = (TableView)root).getPlaceholder()) != null && (found = JavaFXUtils.findNode(placeholder, id)) != null) {
            return found;
        }
        if (root instanceof Parent) {
            parent = (Parent)root;
            for (Tab child : parent.getChildrenUnmodifiable()) {
                found3 = JavaFXUtils.findNode((Node)child, id);
                if (found3 == null) continue;
                return found3;
            }
        }
        return null;
    }

    @Nullable
    public static Object findElement(@Nonnull Object root, @Nonnull String id) {
        Parent parent;
        Object found;
        Object found2;
        Object found3;
        Objects.requireNonNull(root, ERROR_ROOT_NULL);
        GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_BLANK);
        if (id.equals(GriffonClassUtils.getPropertyValue((Object)root, (String)"id"))) {
            return root;
        }
        if (root instanceof Control) {
            Control control = (Control)root;
            ContextMenu contextMenu = control.getContextMenu();
            if (contextMenu != null && (found3 = JavaFXUtils.findElement((Object)contextMenu, id)) != null) {
                return found3;
            }
            Tooltip tooltip = control.getTooltip();
            if (tooltip != null && (found2 = JavaFXUtils.findElement((Object)tooltip, id)) != null) {
                return found2;
            }
        }
        if (root instanceof ButtonBar) {
            ButtonBar buttonBar = (ButtonBar)root;
            for (Node child : buttonBar.getButtons()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof MenuBar) {
            MenuBar menuBar = (MenuBar)root;
            for (Node child : menuBar.getMenus()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof ContextMenu) {
            ContextMenu contextMenu = (ContextMenu)root;
            for (Node child : contextMenu.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof Menu) {
            Menu menu = (Menu)root;
            for (Node child : menu.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof TabPane) {
            TabPane tabPane = (TabPane)root;
            for (Node child : tabPane.getTabs()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof Tab) {
            Tab tab = (Tab)root;
            if (tab.getContent() != null && (found = JavaFXUtils.findElement((Object)tab.getContent(), id)) != null) {
                return found;
            }
        } else if (root instanceof TitledPane) {
            parent = (TitledPane)root;
            if (parent.getContent() != null && (found = JavaFXUtils.findElement((Object)parent.getContent(), id)) != null) {
                return found;
            }
        } else if (root instanceof Accordion) {
            parent = (Accordion)root;
            for (Node child : parent.getPanes()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof SplitPane) {
            parent = (SplitPane)root;
            for (Node child : parent.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)root;
            if (scrollPane.getContent() != null && (found = JavaFXUtils.findElement((Object)scrollPane.getContent(), id)) != null) {
                return found;
            }
        } else if (root instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)root;
            for (Node child : toolBar.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof TableView) {
            TableView tableView = (TableView)root;
            Node placeholder = tableView.getPlaceholder();
            if (placeholder != null && (found3 = JavaFXUtils.findElement((Object)placeholder, id)) != null) {
                return found3;
            }
            for (Object child : tableView.getColumns()) {
                Object found4 = JavaFXUtils.findElement(child, id);
                if (found4 == null) continue;
                return found4;
            }
        }
        if (root instanceof Parent) {
            parent = (Parent)root;
            for (Node child : parent.getChildrenUnmodifiable()) {
                found2 = JavaFXUtils.findElement((Object)child, id);
                if (found2 == null) continue;
                return found2;
            }
        }
        return null;
    }

    @Nullable
    public static Object findElement(@Nonnull Object root, @Nonnull Predicate<Object> predicate) {
        Parent parent;
        Object found;
        Object found2;
        Object found3;
        Objects.requireNonNull(root, ERROR_ROOT_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        if (predicate.test(root)) {
            return root;
        }
        if (root instanceof Control) {
            Control control = (Control)root;
            ContextMenu contextMenu = control.getContextMenu();
            if (contextMenu != null && (found3 = JavaFXUtils.findElement((Object)contextMenu, predicate)) != null) {
                return found3;
            }
            Tooltip tooltip = control.getTooltip();
            if (tooltip != null && (found2 = JavaFXUtils.findElement((Object)tooltip, predicate)) != null) {
                return found2;
            }
        }
        if (root instanceof ButtonBar) {
            ButtonBar buttonBar = (ButtonBar)root;
            for (Node child : buttonBar.getButtons()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof MenuBar) {
            MenuBar menuBar = (MenuBar)root;
            for (Node child : menuBar.getMenus()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof ContextMenu) {
            ContextMenu contextMenu = (ContextMenu)root;
            for (Node child : contextMenu.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof Menu) {
            Menu menu = (Menu)root;
            for (Node child : menu.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof TabPane) {
            TabPane tabPane = (TabPane)root;
            for (Node child : tabPane.getTabs()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof Tab) {
            Tab tab = (Tab)root;
            if (tab.getContent() != null && (found = JavaFXUtils.findElement((Object)tab.getContent(), predicate)) != null) {
                return found;
            }
        } else if (root instanceof TitledPane) {
            parent = (TitledPane)root;
            if (parent.getContent() != null && (found = JavaFXUtils.findElement((Object)parent.getContent(), predicate)) != null) {
                return found;
            }
        } else if (root instanceof Accordion) {
            parent = (Accordion)root;
            for (Node child : parent.getPanes()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof SplitPane) {
            parent = (SplitPane)root;
            for (Node child : parent.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)root;
            if (scrollPane.getContent() != null && (found = JavaFXUtils.findElement((Object)scrollPane.getContent(), predicate)) != null) {
                return found;
            }
        } else if (root instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)root;
            for (Node child : toolBar.getItems()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        } else if (root instanceof TableView) {
            TableView tableView = (TableView)root;
            Node placeholder = tableView.getPlaceholder();
            if (placeholder != null && (found3 = JavaFXUtils.findElement((Object)placeholder, predicate)) != null) {
                return found3;
            }
            for (Object child : tableView.getColumns()) {
                Object found4 = JavaFXUtils.findElement(child, predicate);
                if (found4 == null) continue;
                return found4;
            }
        }
        if (root instanceof Parent) {
            parent = (Parent)root;
            for (Node child : parent.getChildrenUnmodifiable()) {
                found2 = JavaFXUtils.findElement((Object)child, predicate);
                if (found2 == null) continue;
                return found2;
            }
        }
        return null;
    }

    @Nonnull
    public static Collection<Object> findElements(@Nonnull Object root, @Nonnull Predicate<Object> predicate) {
        LinkedHashSet<Object> accumulator = new LinkedHashSet<Object>();
        JavaFXUtils.findElements(root, predicate, accumulator);
        return accumulator;
    }

    private static void findElements(@Nonnull Object root, @Nonnull Predicate<Object> predicate, @Nonnull Collection<Object> accumulator) {
        Parent parent;
        Objects.requireNonNull(root, ERROR_ROOT_NULL);
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        if (predicate.test(root)) {
            accumulator.add(root);
        }
        if (root instanceof Control) {
            Tooltip tooltip;
            Control control = (Control)root;
            ContextMenu contextMenu = control.getContextMenu();
            if (contextMenu != null) {
                JavaFXUtils.findElements(contextMenu, predicate, accumulator);
            }
            if ((tooltip = control.getTooltip()) != null) {
                JavaFXUtils.findElements(tooltip, predicate, accumulator);
            }
        }
        if (root instanceof ButtonBar) {
            ButtonBar buttonBar = (ButtonBar)root;
            for (Object child : buttonBar.getButtons()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof MenuBar) {
            MenuBar menuBar = (MenuBar)root;
            for (Object child : menuBar.getMenus()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof ContextMenu) {
            ContextMenu contextMenu = (ContextMenu)root;
            for (Object child : contextMenu.getItems()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof Menu) {
            Menu menu = (Menu)root;
            for (Object child : menu.getItems()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof TabPane) {
            TabPane tabPane = (TabPane)root;
            for (Object child : tabPane.getTabs()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof Tab) {
            Tab tab = (Tab)root;
            if (tab.getContent() != null) {
                JavaFXUtils.findElements(tab.getContent(), predicate, accumulator);
            }
        } else if (root instanceof TitledPane) {
            parent = (TitledPane)root;
            if (parent.getContent() != null) {
                JavaFXUtils.findElements(parent.getContent(), predicate, accumulator);
            }
        } else if (root instanceof Accordion) {
            parent = (Accordion)root;
            for (Object child : parent.getPanes()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof SplitPane) {
            parent = (SplitPane)root;
            for (Object child : parent.getItems()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof ScrollPane) {
            ScrollPane scrollPane = (ScrollPane)root;
            if (scrollPane.getContent() != null) {
                JavaFXUtils.findElements(scrollPane.getContent(), predicate, accumulator);
            }
        } else if (root instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)root;
            for (Object child : toolBar.getItems()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        } else if (root instanceof TableView) {
            TableView tableView = (TableView)root;
            Node placeholder = tableView.getPlaceholder();
            if (placeholder != null) {
                JavaFXUtils.findElements(placeholder, predicate, accumulator);
            }
            for (Object child : tableView.getColumns()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        }
        if (root instanceof Parent) {
            parent = (Parent)root;
            for (Object child : parent.getChildrenUnmodifiable()) {
                JavaFXUtils.findElements(child, predicate, accumulator);
            }
        }
    }

    @Nullable
    public static Window getWindowAncestor(@Nonnull Object node) {
        TabPane tabPane;
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        if (node instanceof Window) {
            return (Window)node;
        }
        if (node instanceof Scene) {
            return ((Scene)node).getWindow();
        }
        if (node instanceof Node) {
            Scene scene = ((Node)node).getScene();
            if (scene != null) {
                return scene.getWindow();
            }
        } else if (node instanceof Tab && (tabPane = ((Tab)node).getTabPane()) != null) {
            return JavaFXUtils.getWindowAncestor(tabPane);
        }
        return null;
    }

    private static ValueConversionException illegalValue(Object value, Class<?> klass) {
        throw new ValueConversionException(value, klass);
    }

    private static ValueConversionException illegalValue(Object value, Class<?> klass, Exception e) {
        throw new ValueConversionException(value, klass, e);
    }
}

