/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.support;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonView;
import griffon.core.mvc.MVCGroup;
import griffon.javafx.artifact.ContentProvider;
import griffon.javafx.support.MetaComponent;
import griffon.util.GriffonNameUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javax.annotation.Nonnull;

public class GriffonBuilderFactory
implements BuilderFactory {
    protected final GriffonApplication application;
    protected final MVCGroup mvcGroup;
    protected final BuilderFactory delegate;

    public GriffonBuilderFactory(@Nonnull GriffonApplication application, @Nonnull MVCGroup mvcGroup) {
        this(application, mvcGroup, application.getApplicationClassLoader().get());
    }

    public GriffonBuilderFactory(@Nonnull GriffonApplication application, @Nonnull MVCGroup mvcGroup, @Nonnull ClassLoader classLoader) {
        this.application = Objects.requireNonNull(application, "Argument 'application' must not be null");
        this.mvcGroup = Objects.requireNonNull(mvcGroup, "Argument 'mvcGroup' must not be null");
        this.delegate = new JavaFXBuilderFactory(Objects.requireNonNull(classLoader, "Argument 'classLoader' must not be null"));
    }

    public Builder<?> getBuilder(Class<?> type) {
        if (type == MetaComponent.class) {
            return new MetaComponentBuilder(this.application, this.mvcGroup);
        }
        return this.delegate.getBuilder(type);
    }

    private static class MetaComponentBuilder
    extends MetaComponent
    implements Builder<Object> {
        private final GriffonApplication application;
        private final MVCGroup mvcGroup;

        public MetaComponentBuilder(@Nonnull GriffonApplication application, @Nonnull MVCGroup mvcGroup) {
            this.application = Objects.requireNonNull(application, "Argument 'application' must not be null");
            this.mvcGroup = Objects.requireNonNull(mvcGroup, "Argument 'mvcGroup' must not be null");
        }

        public Object build() {
            MVCGroup group;
            GriffonView view;
            String mvcType = GriffonNameUtils.requireNonBlank((String)this.getMvcType(), (String)"Must define a value for 'mvcType'");
            String mvcId = this.getMcvId();
            if (GriffonNameUtils.isBlank((String)mvcId) || this.application.getMvcGroupManager().findGroup(mvcId) != null) {
                mvcId = mvcType + "-" + UUID.randomUUID().toString();
            }
            if ((view = (group = this.mvcGroup.createMVCGroup(mvcType, mvcId, this.toMap(this.getMvcArgs()))).getView()) instanceof ContentProvider) {
                return ((ContentProvider)view).getContent();
            }
            return group.getContext().get(group.getMvcId() + "-rootNode");
        }

        @Nonnull
        private Map<String, Object> toMap(@Nonnull List<MetaComponent.MvcArg> mvcArgs) {
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
            mvcArgs.forEach(arg -> args.put(arg.getName(), arg.getValue()));
            return args;
        }
    }
}

