/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.scene.layout;

import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamedCardPane
extends StackPane {
    private static final String ERROR_NODE_NULL = "Argument 'node' must not be null";
    private static final String ERROR_ID_NULL = "Argument 'id' must not be null";
    private final Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();
    private final StringProperty selectedNodeId = new SimpleStringProperty((Object)this, "selectedNodeId");
    private final ObjectProperty<Node> selectedNode = new SimpleObjectProperty((Object)this, "selectedNode");
    private final AtomicBoolean adjusting = new AtomicBoolean(false);

    public NamedCardPane() {
        this.getStyleClass().add((Object)"named-cardpane");
        this.getChildren().addListener(c -> {
            if (this.adjusting.get()) {
                return;
            }
            while (c.next()) {
                Node node2;
                if (c.wasAdded()) {
                    Node lastAddedNode = null;
                    for (Node node2 : c.getAddedSubList()) {
                        String id = node2.getId();
                        GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_NULL);
                        if (this.nodes.containsKey(id)) continue;
                        this.nodes.put(id, node2);
                        lastAddedNode = node2;
                    }
                    if (lastAddedNode == null) continue;
                    String nextId = lastAddedNode.getId();
                    this.doShow(nextId);
                    continue;
                }
                if (!c.wasRemoved()) continue;
                String selectedId = this.getSelectedNodeId();
                boolean selectionChanged = false;
                node2 = c.getRemoved().iterator();
                while (node2.hasNext()) {
                    Node node3 = (Node)node2.next();
                    String id = node3.getId();
                    GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_NULL);
                    if (!this.nodes.containsKey(id)) continue;
                    this.nodes.remove(id);
                    if (!id.equals(selectedId)) continue;
                    selectionChanged = true;
                }
                if (!selectionChanged) continue;
                String nextId = this.nodes.size() > 0 ? this.nodes.keySet().iterator().next() : null;
                this.doShow(nextId);
            }
        });
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.updateBoundsInChildren());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.updateBoundsInChildren());
    }

    protected void updateBoundsInChildren() {
        this.nodes.values().forEach(this::updateChildBounds);
        this.layout();
    }

    protected void updateChildBounds(Node node) {
        if (node instanceof Region) {
            Region child = (Region)node;
            child.setPrefWidth(this.getWidth());
            child.setPrefHeight(this.getHeight());
        }
    }

    @Nonnull
    public ReadOnlyStringProperty selectedNodeIdProperty() {
        return this.selectedNodeId;
    }

    @Nonnull
    public ReadOnlyObjectProperty<Node> selectedNodeProperty() {
        return this.selectedNode;
    }

    @Nullable
    public String getSelectedNodeId() {
        return (String)this.selectedNodeId.get();
    }

    @Nullable
    public Node getSelectedNode() {
        return (Node)this.selectedNode.get();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public void clear() {
        this.nodes.clear();
        this.getChildren().clear();
        this.selectedNodeId.set(null);
        this.selectedNode.set(null);
    }

    public void add(@Nonnull String id, @Nonnull Node node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_NULL);
        this.adjusting.set(true);
        this.nodes.put(id, node);
        this.adjusting.set(false);
        this.show(id);
    }

    public void remove(@Nonnull String id) {
        GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_NULL);
        if (!this.nodes.containsKey(id)) {
            return;
        }
        String selectedId = this.getSelectedNodeId();
        this.adjusting.set(true);
        this.nodes.remove(id);
        this.adjusting.set(false);
        if (id.equals(selectedId)) {
            String nextId = null;
            if (this.nodes.size() > 0) {
                nextId = this.nodes.keySet().iterator().next();
            }
            this.doShow(nextId);
        }
    }

    public void show(@Nonnull String id) {
        GriffonNameUtils.requireNonBlank((String)id, (String)ERROR_ID_NULL);
        GriffonClassUtils.requireState((boolean)this.nodes.containsKey(id), (String)("No content associated with id '" + id + "'"));
        this.doShow(id);
    }

    protected void doShow(@Nullable String id) {
        Platform.runLater(() -> {
            if (GriffonNameUtils.isBlank((String)id)) {
                this.adjusting.set(true);
                this.getChildren().clear();
                this.adjusting.set(false);
                this.selectedNodeId.set(null);
                this.selectedNode.set(null);
            } else {
                Node node = this.nodes.get(id);
                this.adjusting.set(true);
                this.getChildren().setAll((Object[])new Node[]{node});
                this.adjusting.set(false);
                this.selectedNodeId.set((Object)id);
                this.selectedNode.set((Object)node);
            }
        });
    }
}

