/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.scene.layout;

import griffon.util.GriffonClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexedCardPane
extends StackPane {
    private static final String ERROR_NODE_NULL = "Argument 'node' must not be null";
    private final List<Node> nodes = new ArrayList<Node>();
    private final IntegerProperty selectedIndex = new SimpleIntegerProperty((Object)this, "selectedIndex", -1);
    private final ObjectProperty<Node> selectedNode = new SimpleObjectProperty((Object)this, "selectedNode");
    private final AtomicBoolean adjusting = new AtomicBoolean(false);

    public IndexedCardPane() {
        this.getStyleClass().add((Object)"indexed-cardpane");
        this.getChildren().addListener(c -> {
            if (this.adjusting.get()) {
                return;
            }
            while (c.next()) {
                if (c.wasAdded()) {
                    Node lastAddedNode = null;
                    for (Node node : c.getAddedSubList()) {
                        if (this.nodes.contains(node)) continue;
                        this.nodes.add(node);
                        lastAddedNode = node;
                    }
                    if (lastAddedNode == null) continue;
                    this.doShow(this.indexOf(lastAddedNode));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                int selectedIndex = this.getSelectedIndex();
                for (Node node : c.getRemoved()) {
                    if (!this.nodes.contains(node)) continue;
                    int removedIndex = this.indexOf(node);
                    this.nodes.remove(node);
                    if (removedIndex > selectedIndex) continue;
                    selectedIndex = -1;
                }
                this.doShow(selectedIndex);
            }
        });
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.updateBoundsInChildren());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.updateBoundsInChildren());
    }

    protected void updateBoundsInChildren() {
        for (Node node : this.nodes) {
            this.updateChildBounds(node);
        }
        this.layout();
    }

    protected void updateChildBounds(Node node) {
        if (node instanceof Region) {
            Region child = (Region)node;
            child.setPrefWidth(this.getWidth());
            child.setPrefHeight(this.getHeight());
        }
    }

    @Nonnull
    public ReadOnlyIntegerProperty selectedIndexProperty() {
        return this.selectedIndex;
    }

    @Nonnull
    public ReadOnlyObjectProperty<Node> selectedNodeProperty() {
        return this.selectedNode;
    }

    public int getSelectedIndex() {
        return this.selectedIndex.get();
    }

    @Nullable
    public Node getSelectedNode() {
        return (Node)this.selectedNode.get();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public void clear() {
        this.nodes.clear();
        this.getChildren().clear();
        this.selectedIndex.set(-1);
        this.selectedNode.set(null);
    }

    public int indexOf(@Nonnull Node node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        return this.nodes.indexOf(node);
    }

    public void add(@Nonnull Node node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        if (!this.nodes.contains(node)) {
            this.adjusting.set(true);
            this.nodes.add(node);
            this.adjusting.set(false);
        }
        this.show(this.indexOf(node));
    }

    public void remove(@Nonnull Node node) {
        Objects.requireNonNull(node, ERROR_NODE_NULL);
        if (!this.nodes.contains(node)) {
            return;
        }
        int selectedIndex = this.getSelectedIndex();
        int removedIndex = this.indexOf(node);
        this.adjusting.set(true);
        this.nodes.remove(node);
        this.adjusting.set(false);
        if (removedIndex <= selectedIndex) {
            this.doShow(selectedIndex - 1);
        }
    }

    public void first() {
        if (!this.nodes.isEmpty()) {
            this.show(0);
        }
    }

    public void last() {
        int size = this.nodes.size();
        if (size > 0) {
            this.show(size - 1);
        }
    }

    public void next() {
        int size = this.nodes.size();
        if (size > 0) {
            int index = this.getSelectedIndex() + 1;
            this.show(index >= size ? 0 : index);
        }
    }

    public void previous() {
        int size = this.nodes.size();
        if (size > 0) {
            int index = this.getSelectedIndex() - 1;
            this.show(index < 0 ? size - 1 : index);
        }
    }

    public void show(int index) {
        GriffonClassUtils.requireState((index > -1 ? 1 : 0) != 0, (String)"Argument 'index' must be greater than -1");
        GriffonClassUtils.requireState((index < this.nodes.size() ? 1 : 0) != 0, (String)("Argument 'index' must be less than " + this.nodes.size()));
        this.doShow(index);
    }

    protected void doShow(int index) {
        Platform.runLater(() -> {
            if (index < 0) {
                this.adjusting.set(true);
                this.getChildren().clear();
                this.adjusting.set(false);
                this.selectedIndex.set(-1);
                this.selectedNode.set(null);
            } else {
                Node node = this.nodes.get(index);
                this.adjusting.set(true);
                this.getChildren().setAll((Object[])new Node[]{node});
                this.adjusting.set(false);
                this.selectedIndex.set(index);
                this.selectedNode.set((Object)node);
            }
        });
    }
}

