/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.scene.control;

import griffon.javafx.scene.control.TableCellFactory;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ChoiceBoxTableCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.ProgressBarTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;

public class TableCellFactories {
    private static final String ERROR_ITEMS_NULL = "Argument 'items' must not be null";
    private static final String ERROR_ENUMTYPE_NULL = "Argument 'enumType' must not be null";

    @Nonnull
    public static <E, T> TableCellFactory<E, T> checkboxTableCellFactory() {
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                CheckBoxTableCell cell = new CheckBoxTableCell();
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableCheckboxTableCellFactory() {
        return new EditableTableCellFactory(TableCellFactories.checkboxTableCellFactory());
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> choiceBoxTableCellFactory(E ... items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])items);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ChoiceBoxTableCell cell = new ChoiceBoxTableCell(observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> choiceBoxTableCellFactory(final @Nonnull StringConverter<E> converter, E ... items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])items);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ChoiceBoxTableCell cell = new ChoiceBoxTableCell(converter, observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> choiceBoxTableCellFactory(final @Nonnull ObservableList<E> observableItems) {
        Objects.requireNonNull(observableItems, ERROR_ITEMS_NULL);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ChoiceBoxTableCell cell = new ChoiceBoxTableCell(observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> choiceBoxTableCellFactory(final @Nonnull StringConverter<E> converter, final @Nonnull ObservableList<E> observableItems) {
        Objects.requireNonNull(observableItems, ERROR_ITEMS_NULL);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ChoiceBoxTableCell cell = new ChoiceBoxTableCell(converter, observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> choiceBoxTableCellFactory(@Nonnull Class<E> enumType) {
        Objects.requireNonNull(enumType, ERROR_ENUMTYPE_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])enumType.getEnumConstants());
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ChoiceBoxTableCell cell = new ChoiceBoxTableCell(observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> choiceBoxTableCellFactory(final @Nonnull StringConverter<E> converter, @Nonnull Class<E> enumType) {
        Objects.requireNonNull(enumType, ERROR_ENUMTYPE_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])enumType.getEnumConstants());
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ChoiceBoxTableCell cell = new ChoiceBoxTableCell(converter, observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableChoiceBoxTableCellFactory(E ... items) {
        return new EditableTableCellFactory(TableCellFactories.choiceBoxTableCellFactory(items));
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableChoiceBoxTableCellFactory(@Nonnull StringConverter<E> converter, E ... items) {
        return new EditableTableCellFactory(TableCellFactories.choiceBoxTableCellFactory(converter, items));
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableChoiceBoxTableCellFactory(@Nonnull ObservableList<E> observableItems) {
        return new EditableTableCellFactory(TableCellFactories.choiceBoxTableCellFactory(observableItems));
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableChoiceBoxTableCellFactory(@Nonnull StringConverter<E> converter, @Nonnull ObservableList<E> observableItems) {
        return new EditableTableCellFactory(TableCellFactories.choiceBoxTableCellFactory(converter, observableItems));
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> editableChoiceBoxTableCellFactory(@Nonnull Class<E> enumType) {
        return new EditableTableCellFactory(TableCellFactories.choiceBoxTableCellFactory(enumType));
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> editableChoiceBoxTableCellFactory(@Nonnull StringConverter<E> converter, @Nonnull Class<E> enumType) {
        return new EditableTableCellFactory(TableCellFactories.choiceBoxTableCellFactory(converter, enumType));
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> comboBoxTableCellFactory(E ... items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])items);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ComboBoxTableCell cell = new ComboBoxTableCell(observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> comboBoxTableCellFactory(final @Nonnull StringConverter<E> converter, E ... items) {
        Objects.requireNonNull(items, ERROR_ITEMS_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])items);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ComboBoxTableCell cell = new ComboBoxTableCell(converter, observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> comboBoxTableCellFactory(final @Nonnull ObservableList<E> observableItems) {
        Objects.requireNonNull(observableItems, ERROR_ITEMS_NULL);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ComboBoxTableCell cell = new ComboBoxTableCell(observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> comboBoxTableCellFactory(final @Nonnull StringConverter<E> converter, final @Nonnull ObservableList<E> observableItems) {
        Objects.requireNonNull(observableItems, ERROR_ITEMS_NULL);
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ComboBoxTableCell cell = new ComboBoxTableCell(converter, observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> comboBoxTableCellFactory(@Nonnull Class<E> enumType) {
        Objects.requireNonNull(enumType, ERROR_ENUMTYPE_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])enumType.getEnumConstants());
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ComboBoxTableCell cell = new ComboBoxTableCell(observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> comboBoxTableCellFactory(final @Nonnull StringConverter<E> converter, @Nonnull Class<E> enumType) {
        Objects.requireNonNull(enumType, ERROR_ENUMTYPE_NULL);
        final ObservableList observableItems = FXCollections.observableArrayList((Object[])enumType.getEnumConstants());
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                ComboBoxTableCell cell = new ComboBoxTableCell(converter, observableItems);
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableComboBoxTableCellFactory(E ... items) {
        return new EditableTableCellFactory(TableCellFactories.comboBoxTableCellFactory(items));
    }

    @SafeVarargs
    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableComboBoxTableCellFactory(@Nonnull StringConverter<E> converter, E ... items) {
        return new EditableTableCellFactory(TableCellFactories.comboBoxTableCellFactory(converter, items));
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableComboBoxTableCellFactory(@Nonnull ObservableList<E> observableItems) {
        return new EditableTableCellFactory(TableCellFactories.comboBoxTableCellFactory(observableItems));
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableComboBoxTableCellFactory(@Nonnull StringConverter<E> converter, @Nonnull ObservableList<E> observableItems) {
        return new EditableTableCellFactory(TableCellFactories.comboBoxTableCellFactory(converter, observableItems));
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> editableComboBoxTableCellFactory(@Nonnull Class<E> enumType) {
        return new EditableTableCellFactory(TableCellFactories.comboBoxTableCellFactory(enumType));
    }

    @Nonnull
    public static <E extends Enum, T> TableCellFactory<E, T> editableComboBoxTableCellFactory(@Nonnull StringConverter<E> converter, @Nonnull Class<E> enumType) {
        return new EditableTableCellFactory(TableCellFactories.comboBoxTableCellFactory(converter, enumType));
    }

    @Nonnull
    public static <E> TableCellFactory<E, Double> progressBarTableCellFactory() {
        return new TableCellFactory<E, Double>(){

            @Override
            @Nonnull
            public TableCell<E, Double> createTableCell(@Nonnull TableColumn<E, Double> tableColumn) {
                return new ProgressBarTableCell();
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> textFieldTableCellFactory() {
        return new TableCellFactory<E, T>(){

            @Override
            @Nonnull
            public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
                TextFieldTableCell cell = new TextFieldTableCell();
                cell.setEditable(false);
                return cell;
            }
        };
    }

    @Nonnull
    public static <E, T> TableCellFactory<E, T> editableTextFieldTableCellFactory() {
        return new EditableTableCellFactory(TableCellFactories.textFieldTableCellFactory());
    }

    private static class EditableTableCellFactory<E, T>
    implements TableCellFactory<E, T> {
        private final TableCellFactory delegate;

        private EditableTableCellFactory(@Nonnull TableCellFactory<E, T> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
        }

        @Override
        @Nonnull
        public TableCell<E, T> createTableCell(@Nonnull TableColumn<E, T> tableColumn) {
            TableCell<E, T> cell = this.delegate.createTableCell(tableColumn);
            cell.setEditable(true);
            return cell;
        }
    }
}

