/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.scene.control;

import griffon.javafx.scene.control.TableCellFactory;
import griffon.javafx.scene.control.TableViewFormat;
import griffon.javafx.scene.control.TableViewModel;
import griffon.util.GriffonClassUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.Nonnull;

public class DefaultTableViewModel<E>
implements TableViewModel<E> {
    private static final String ERROR_TABLE_VIEW_NULL = "Argument 'tableView' must not be null";
    protected final ObservableList<E> source;
    protected final TableViewFormat<E> format;
    protected final List<TableColumn<E, Object>> columns = new ArrayList<TableColumn<E, Object>>();

    public DefaultTableViewModel(@Nonnull ObservableList<E> source, @Nonnull TableViewFormat<E> format) {
        this.source = Objects.requireNonNull(source, "Argument 'source' must not be null");
        this.format = Objects.requireNonNull(format, "Argument 'format' must not be null");
        this.computeColumns();
    }

    protected void computeColumns() {
        for (int i = 0; i < this.format.getColumnCount(); ++i) {
            String columnName = this.format.getColumnName(i);
            TableColumn column = new TableColumn(columnName);
            int columnIndex = i;
            TableCellFactory tableCellFactory = this.format.getTableCellFactory(i);
            if (tableCellFactory != null) {
                column.setCellFactory(cell -> tableCellFactory.createTableCell((TableColumn)cell));
            }
            column.setCellValueFactory(cell -> this.format.getObservableValue(((TableColumn.CellDataFeatures)cell).getValue(), columnIndex));
            this.columns.add(column);
        }
    }

    @Override
    @Nonnull
    public ObservableList<E> getSource() {
        return this.source;
    }

    @Override
    @Nonnull
    public TableViewFormat<E> getFormat() {
        return this.format;
    }

    @Override
    @Nonnull
    public TableColumn<E, ?> getColumnAt(int index) {
        GriffonClassUtils.requireState((index >= 0 ? 1 : 0) != 0, (String)"Argument 'index' must be greater or equal to zero");
        GriffonClassUtils.requireState((index < this.columns.size() ? 1 : 0) != 0, (String)("Argument 'index' must be less than " + this.columns.size()));
        return this.columns.get(index);
    }

    @Override
    public void attachTo(@Nonnull TableView<E> tableView) {
        Objects.requireNonNull(tableView, ERROR_TABLE_VIEW_NULL);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableView.setItems(this.source);
        tableView.getColumns().addAll(this.columns);
        this.resizeColumns();
    }

    protected void resizeColumns() {
        int proportionalSize = 100 / this.columns.size();
        for (int i = 0; i < this.columns.size(); ++i) {
            Double size = this.format.getColumnSize(i);
            int columnSize = size != null ? (int)(100.0 * size) : proportionalSize;
            TableColumn<E, Object> column = this.columns.get(i);
            column.setMaxWidth((double)(2.1474836E9f * (float)columnSize));
        }
    }

    @Override
    public void detachFrom(@Nonnull TableView<E> tableView) {
        Objects.requireNonNull(tableView, ERROR_TABLE_VIEW_NULL);
        tableView.setItems(FXCollections.emptyObservableList());
        tableView.getColumns().removeAll(this.columns);
    }
}

