/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.scene.control;

import griffon.javafx.scene.control.TableCellFactory;
import griffon.javafx.scene.control.TableViewFormat;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultTableFormat<E>
implements TableViewFormat<E> {
    protected final Column[] columns;
    private final Map<Class<?>, Map<String, Method>> observableMetadata = new LinkedHashMap();

    public DefaultTableFormat(String ... names) {
        Objects.requireNonNull(names, "Argument 'names' must not be null");
        GriffonClassUtils.requireState((names.length > 0 ? 1 : 0) != 0, (String)"Column size must be greater than zero");
        this.columns = new Column[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.columns[i] = new Column(names[i]);
        }
    }

    public DefaultTableFormat(Column ... columns) {
        Objects.requireNonNull(columns, "Argument 'columns' must not be null");
        GriffonClassUtils.requireState((columns.length > 0 ? 1 : 0) != 0, (String)"Column size must be greater than zero");
        this.columns = new Column[columns.length];
        System.arraycopy(columns, 0, this.columns, 0, columns.length);
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    @Nonnull
    public String getColumnName(int index) {
        return this.columns[index].getTitle();
    }

    @Override
    @Nullable
    public Double getColumnSize(int index) {
        return this.columns[index].getSize();
    }

    @Override
    @Nonnull
    public ObservableValue<?> getObservableValue(@Nonnull E instance, int index) {
        String columnName = this.columns[index].getName();
        Class<?> klass = instance.getClass();
        Map metadata = this.observableMetadata.computeIfAbsent(klass, this::harvestMetadata);
        try {
            Method method = (Method)metadata.get(columnName);
            if (method == null) {
                throw new IllegalStateException("Could not find a method in " + klass + " returning " + ObservableValue.class.getSimpleName() + " associated with column " + columnName);
            }
            return (ObservableValue)method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    @Override
    @Nullable
    public TableCellFactory getTableCellFactory(int index) {
        return this.columns[index].getTableCellFactory();
    }

    @Nonnull
    private Map<String, Method> harvestMetadata(@Nonnull Class<?> klass) {
        LinkedHashMap<String, Method> map = new LinkedHashMap<String, Method>();
        for (Method method : klass.getMethods()) {
            if (!ObservableValue.class.isAssignableFrom(method.getReturnType()) || method.getParameterCount() != 0) continue;
            Arrays.stream(this.columns).map(Column::getName).filter(name -> method.getName().startsWith((String)name)).findFirst().ifPresent(name -> map.put((String)name, method));
        }
        return map;
    }

    public static class Column<E, T> {
        private final String name;
        private final String title;
        private final Double size;
        private final TableCellFactory<E, T> tableCellFactory;

        public Column(@Nonnull String name) {
            this(name, GriffonNameUtils.getNaturalName((String)name), null, null);
        }

        public Column(@Nonnull String name, @Nonnull String title) {
            this(name, title, null, null);
        }

        public Column(@Nonnull String name, @Nonnull Double size) {
            this(name, GriffonNameUtils.getNaturalName((String)name), size, null);
        }

        public Column(@Nonnull String name, @Nonnull TableCellFactory<E, T> tableCellFactory) {
            this(name, GriffonNameUtils.getNaturalName((String)name), null, tableCellFactory);
        }

        public Column(@Nonnull String name, @Nonnull String title, @Nonnull Double size) {
            this(name, title, size, null);
        }

        public Column(@Nonnull String name, @Nonnull String title, @Nonnull TableCellFactory<E, T> tableCellFactory) {
            this(name, title, null, tableCellFactory);
        }

        public Column(@Nonnull String name, @Nonnull Double size, @Nonnull TableCellFactory<E, T> tableCellFactory) {
            this(name, GriffonNameUtils.getNaturalName((String)name), size, tableCellFactory);
        }

        public Column(@Nonnull String name, @Nonnull String title, @Nullable Double size, @Nonnull TableCellFactory<E, T> tableCellFactory) {
            this.name = GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'name' must not be blank");
            this.title = GriffonNameUtils.requireNonBlank((String)title, (String)"Argument 'title' must not be blank");
            if (size != null) {
                GriffonClassUtils.requireState((size > 0.0 ? 1 : 0) != 0, (String)"Argument 'size' must be greater than 0.0d");
                GriffonClassUtils.requireState((size <= 1.0 ? 1 : 0) != 0, (String)"Argument 'size' must be less than or equal to 1.0d");
            }
            this.size = size;
            this.tableCellFactory = tableCellFactory;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public Double getSize() {
            return this.size;
        }

        @Nullable
        public TableCellFactory<E, T> getTableCellFactory() {
            return this.tableCellFactory;
        }
    }
}

