/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.util.List;
import java.util.Map;
import javafx.geometry.Insets;

public class InsetsPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Insets i = (Insets)this.getValue();
        return i.getTop() + ", " + i.getRight() + ", " + i.getBottom() + ", " + i.getLeft();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Insets) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Insets.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        double t = 0.0;
        double l = 0.0;
        double r = 0.0;
        double b = 0.0;
        String[] parts = str.split(",");
        switch (parts.length) {
            case 4: {
                l = this.parseValue(parts[3]);
            }
            case 3: {
                b = this.parseValue(parts[2]);
            }
            case 2: {
                r = this.parseValue(parts[1]);
            }
            case 1: {
                t = this.parseValue(parts[0]);
                super.setValueInternal((Object)new Insets(t, r, b, l));
                break;
            }
            default: {
                throw this.illegalValue(str, Insets.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double t = 0.0;
        double l = 0.0;
        double r = 0.0;
        double b = 0.0;
        switch (list.size()) {
            case 4: {
                l = this.parseValue(list.get(3));
            }
            case 3: {
                b = this.parseValue(list.get(2));
            }
            case 2: {
                r = this.parseValue(list.get(1));
            }
            case 1: {
                t = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Insets(t, r, b, l));
                break;
            }
            default: {
                throw this.illegalValue(list, Insets.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double t = this.getMapValue(map, "top", 0.0);
        double l = this.getMapValue(map, "left", 0.0);
        double r = this.getMapValue(map, "right", 0.0);
        double b = this.getMapValue(map, "bottom", 0.0);
        super.setValueInternal((Object)new Insets(t, r, b, l));
    }

    protected double parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Insets.class);
    }

    protected double parse(String val) {
        try {
            return Double.parseDouble(String.valueOf(val).trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Insets.class, e);
        }
    }

    protected double parse(Number val) {
        return val.doubleValue();
    }

    protected double getMapValue(Map<?, ?> map, String key, double defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Insets.class);
    }

    protected void handleAsNumber(Number value) {
        double c = this.parse(value);
        super.setValueInternal((Object)new Insets(c, c, c, c));
    }
}

