/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections.transformation;

import griffon.javafx.collections.ObservableSetBase;
import java.util.Objects;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.WeakSetChangeListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TransformationSet<E, F>
extends ObservableSetBase<E>
implements ObservableSet<E> {
    private final ObservableSet<? extends F> source;
    private SetChangeListener<F> sourceListener;

    protected TransformationSet(@Nonnull ObservableSet<? extends F> source) {
        this.source = Objects.requireNonNull(source, "Argument 'source' must not be null");
        source.addListener((SetChangeListener)new WeakSetChangeListener(this.getListener()));
    }

    @Nonnull
    public final ObservableSet<? extends F> getSource() {
        return this.source;
    }

    public SetChangeListener<F> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = this::sourceChanged;
        }
        return this.sourceListener;
    }

    public final boolean isInTransformationChain(@Nullable ObservableSet<?> set) {
        if (this.source == set) {
            return true;
        }
        ObservableSet<? extends F> currentSource = this.source;
        while (currentSource instanceof TransformationSet) {
            currentSource = ((TransformationSet)currentSource).source;
            if (currentSource != set) continue;
            return true;
        }
        return false;
    }

    protected abstract void sourceChanged(SetChangeListener.Change<? extends F> var1);
}

