/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections.transformation;

import griffon.javafx.collections.ObservableMapBase;
import java.util.Objects;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.WeakMapChangeListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TransformationMap<K, V, F>
extends ObservableMapBase<K, V>
implements ObservableMap<K, V> {
    private final ObservableMap<K, ? extends F> source;
    private MapChangeListener<K, F> sourceListener;

    protected TransformationMap(@Nonnull ObservableMap<K, ? extends F> source) {
        this.source = Objects.requireNonNull(source, "Argument 'source' must not be null");
        source.addListener((MapChangeListener)new WeakMapChangeListener(this.getListener()));
    }

    @Nonnull
    public final ObservableMap<K, ? extends F> getSource() {
        return this.source;
    }

    public MapChangeListener<K, F> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = this::sourceChanged;
        }
        return this.sourceListener;
    }

    public final boolean isInTransformationChain(@Nullable ObservableMap<?, ?> map) {
        if (this.source == map) {
            return true;
        }
        ObservableMap<K, ? extends F> currentSource = this.source;
        while (currentSource instanceof TransformationMap) {
            currentSource = ((TransformationMap)currentSource).source;
            if (currentSource != map) continue;
            return true;
        }
        return false;
    }

    protected abstract void sourceChanged(MapChangeListener.Change<? extends K, ? extends F> var1);
}

