/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import com.sun.javafx.collections.SetListenerHelper;
import java.util.AbstractSet;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javax.annotation.Nonnull;

public abstract class ObservableSetBase<E>
extends AbstractSet<E>
implements ObservableSet<E> {
    private SetListenerHelper<E> listenerHelper;

    public final void addListener(InvalidationListener listener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, (InvalidationListener)listener);
    }

    public final void removeListener(InvalidationListener listener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, (InvalidationListener)listener);
    }

    public final void addListener(SetChangeListener<? super E> listener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
    }

    public final void removeListener(SetChangeListener<? super E> listener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
    }

    protected final void fireChange(SetChangeListener.Change<? extends E> change) {
        SetListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    protected final boolean hasListeners() {
        return SetListenerHelper.hasListeners(this.listenerHelper);
    }

    public static class BaseRemoveChange<T>
    extends SetChangeListener.Change<T> {
        private final T removed;

        public BaseRemoveChange(@Nonnull ObservableSet<T> set, @Nonnull T removed) {
            super(Objects.requireNonNull(set, "Argument 'set' must not be null"));
            this.removed = Objects.requireNonNull(removed, "Argument 'removed' must not be null");
        }

        public boolean wasAdded() {
            return false;
        }

        public boolean wasRemoved() {
            return true;
        }

        public T getElementAdded() {
            return null;
        }

        public T getElementRemoved() {
            return this.removed;
        }

        public String toString() {
            return "removed " + this.removed;
        }
    }

    public static class BaseAddChange<T>
    extends SetChangeListener.Change<T> {
        private final T added;

        public BaseAddChange(@Nonnull ObservableSet<T> set, @Nonnull T added) {
            super(Objects.requireNonNull(set, "Argument 'set' must not be null"));
            this.added = Objects.requireNonNull(added, "Argument 'added' must not be null");
        }

        public boolean wasAdded() {
            return true;
        }

        public boolean wasRemoved() {
            return false;
        }

        public T getElementAdded() {
            return this.added;
        }

        public T getElementRemoved() {
            return null;
        }

        public String toString() {
            return "added " + this.added;
        }
    }
}

