/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import javax.annotation.Nonnull;

public class MappingObservableList<T, S>
extends TransformationList<T, S> {
    private static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";
    private static final String ERROR_SOURCE_NULL = "Argument 'source' must not be null";
    private T[] elements;
    private Function<S, T> mapper;
    private ObservableValue<Function<S, T>> observableMapper;

    public MappingObservableList(@Nonnull ObservableList<? extends S> source, @Nonnull Function<S, T> mapper) {
        super(Objects.requireNonNull(source, ERROR_SOURCE_NULL));
        this.mapper = Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        int size = source.size();
        this.elements = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.elements[i] = mapper.apply(source.get(i));
        }
    }

    public MappingObservableList(@Nonnull ObservableList<? extends S> source, @Nonnull ObservableValue<Function<S, T>> mapper) {
        super(Objects.requireNonNull(source, ERROR_SOURCE_NULL));
        this.observableMapper = Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        int size = source.size();
        this.elements = new Object[size];
        Function<S, Object> function = this.resolveMapper();
        for (int i = 0; i < size; ++i) {
            this.elements[i] = function.apply(source.get(i));
        }
        mapper.addListener((v, o, n) -> this.updateAll());
    }

    @Nonnull
    protected Function<S, T> resolveMapper() {
        Function function = this.observableMapper != null ? (Function)this.observableMapper.getValue() : this.mapper;
        return Objects.requireNonNull(function, ERROR_MAPPER_NULL);
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public T get(int index) {
        return this.elements[index];
    }

    public int size() {
        return this.getSource().size();
    }

    protected void sourceChanged(ListChangeListener.Change<? extends S> c) {
        this.beginChange();
        while (c.next()) {
            if (c.wasPermutated()) {
                this.permutate(c);
                continue;
            }
            if (c.wasReplaced()) {
                this.replace(c);
                continue;
            }
            if (c.wasUpdated()) {
                this.update(c);
                continue;
            }
            if (c.wasAdded()) {
                this.add(c);
                continue;
            }
            if (!c.wasRemoved()) continue;
            this.remove(c);
        }
        this.endChange();
    }

    private void permutate(ListChangeListener.Change<? extends S> c) {
        int from = c.getFrom();
        int to = c.getTo();
        int[] perms = new int[from - to];
        Function<S, Object> function = this.resolveMapper();
        int j = 0;
        for (int i = from; i < to; ++i) {
            perms[j++] = c.getPermutation(i);
            this.elements[i] = function.apply(c.getList().get(i));
        }
        this.nextPermutation(from, to, perms);
    }

    private void replace(ListChangeListener.Change<? extends S> c) {
        int from = c.getFrom();
        int to = c.getTo();
        ArrayList<T> removed = new ArrayList<T>();
        Function<S, Object> function = this.resolveMapper();
        for (int i = from; i < to; ++i) {
            this.elements[i] = function.apply(c.getList().get(i));
            removed.add(this.elements[i]);
        }
        this.nextReplace(from, to, removed);
    }

    private void update(ListChangeListener.Change<? extends S> c) {
        int from = c.getFrom();
        int to = c.getTo();
        Function<S, Object> function = this.resolveMapper();
        for (int i = from; i < to; ++i) {
            this.elements[i] = function.apply(c.getList().get(i));
            this.nextUpdate(i);
        }
    }

    private void add(ListChangeListener.Change<? extends S> c) {
        int from = 0;
        int to = c.getAddedSize();
        int offset = this.elements.length;
        T[] tmp = Arrays.copyOf(this.elements, offset + to);
        Function function = this.resolveMapper();
        for (int i = 0; i < to; ++i) {
            tmp[offset + i] = function.apply(c.getAddedSubList().get(i));
        }
        this.elements = tmp;
        this.nextAdd(offset + from, offset + to);
    }

    private void remove(ListChangeListener.Change<? extends S> c) {
        int from = c.getFrom();
        int size = this.elements.length - c.getRemovedSize();
        int to = c.getTo();
        to = to == from ? from + c.getRemovedSize() - 1 : to;
        ArrayList<T> removed = new ArrayList<T>();
        Object[] tmp = new Object[size];
        int j = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            if (i < from || i > to) {
                tmp[j++] = this.elements[i];
                continue;
            }
            removed.add(this.elements[i]);
        }
        this.elements = tmp;
        this.nextRemove(from, removed);
    }

    private void updateAll() {
        Function function = this.resolveMapper();
        ArrayList copy = new ArrayList(this.getSource());
        List<T> removed = Arrays.asList(this.elements);
        Object[] tmp = new Object[removed.size()];
        this.beginChange();
        for (int i = 0; i < removed.size(); ++i) {
            tmp[i] = function.apply(copy.get(i));
        }
        this.elements = tmp;
        this.nextReplace(0, this.elements.length, removed);
        this.endChange();
    }
}

