/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.collections.DelegatingObservableList;
import griffon.javafx.collections.DelegatingObservableMap;
import griffon.javafx.collections.DelegatingObservableSet;
import griffon.javafx.collections.ListObservableStream;
import griffon.javafx.collections.MapObservableStream;
import griffon.javafx.collections.ObservableStream;
import griffon.javafx.collections.SetObservableStream;
import java.util.Objects;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javax.annotation.Nonnull;

public final class GriffonFXCollections {
    private static final String ERROR_SOURCE_NULL = "Argument 'source' must not be null";

    private GriffonFXCollections() {
    }

    @Nonnull
    public static <E> ObservableList<E> uiThreadAwareObservableList(@Nonnull ObservableList<E> source) {
        Objects.requireNonNull(source, ERROR_SOURCE_NULL);
        return source instanceof UIThreadAware ? source : new UIThreadAwareObservableList(source);
    }

    @Nonnull
    public static <E> ObservableSet<E> uiThreadAwareObservableSet(@Nonnull ObservableSet<E> source) {
        Objects.requireNonNull(source, ERROR_SOURCE_NULL);
        return source instanceof UIThreadAware ? source : new UIThreadAwareObservableSet(source);
    }

    @Nonnull
    public static <K, V> ObservableMap<K, V> uiThreadAwareObservableMap(@Nonnull ObservableMap<K, V> source) {
        Objects.requireNonNull(source, ERROR_SOURCE_NULL);
        return source instanceof UIThreadAware ? source : new UIThreadAwareObservableMap(source);
    }

    @Nonnull
    public static <E> ObservableStream<E> observableStream(@Nonnull ObservableList<E> list) {
        return new ListObservableStream<E>(list);
    }

    @Nonnull
    public static <E> ObservableStream<E> observableStream(@Nonnull ObservableSet<E> set) {
        return new SetObservableStream<E>(set);
    }

    @Nonnull
    public static <K, V> ObservableStream<V> observableStream(@Nonnull ObservableMap<K, V> map) {
        return new MapObservableStream<V>(map);
    }

    private static class UIThreadAwareObservableMap<K, V>
    extends DelegatingObservableMap<K, V>
    implements UIThreadAware {
        protected UIThreadAwareObservableMap(ObservableMap<K, V> delegate) {
            super(delegate);
        }

        @Override
        protected void sourceChanged(@Nonnull MapChangeListener.Change<? extends K, ? extends V> c) {
            if (Platform.isFxApplicationThread()) {
                this.fireChange(c);
            } else {
                Platform.runLater(() -> this.fireChange(c));
            }
        }
    }

    private static class UIThreadAwareObservableSet<E>
    extends DelegatingObservableSet<E>
    implements UIThreadAware {
        protected UIThreadAwareObservableSet(ObservableSet<E> delegate) {
            super(delegate);
        }

        @Override
        protected void sourceChanged(@Nonnull SetChangeListener.Change<? extends E> c) {
            if (Platform.isFxApplicationThread()) {
                this.fireChange(c);
            } else {
                Platform.runLater(() -> this.fireChange(c));
            }
        }
    }

    private static class UIThreadAwareObservableList<E>
    extends DelegatingObservableList<E>
    implements UIThreadAware {
        protected UIThreadAwareObservableList(ObservableList<E> delegate) {
            super(delegate);
        }

        @Override
        protected void sourceChanged(@Nonnull ListChangeListener.Change<? extends E> c) {
            if (Platform.isFxApplicationThread()) {
                this.fireChange(c);
            } else {
                Platform.runLater(() -> this.fireChange(c));
            }
        }
    }
}

