/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import griffon.javafx.collections.DelegatingObservableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ElementObservableList<E>
extends DelegatingObservableList<E> {
    private final Map<E, List<ListenerSubscription>> subscriptions = new LinkedHashMap<E, List<ListenerSubscription>>();
    private final ObservableValueExtractor<E> observableValueExtractor;

    public ElementObservableList() {
        this(FXCollections.observableArrayList(), new DefaultObservableValueExtractor());
    }

    public ElementObservableList(@Nonnull ObservableValueExtractor<E> observableValueExtractor) {
        this(FXCollections.observableArrayList(), observableValueExtractor);
    }

    public ElementObservableList(@Nonnull ObservableList<E> delegate) {
        this(delegate, new DefaultObservableValueExtractor());
    }

    public ElementObservableList(@Nonnull ObservableList<E> delegate, @Nonnull ObservableValueExtractor<E> observableValueExtractor) {
        super(delegate);
        this.observableValueExtractor = Objects.requireNonNull(observableValueExtractor, "Argument 'observableValueExtractor' must not be null");
    }

    @Override
    protected void sourceChanged(@Nonnull ListChangeListener.Change<? extends E> c) {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(this::registerListeners);
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(this::unregisterListeners);
        }
        this.fireChange(c);
    }

    private void registerListeners(@Nonnull E element) {
        if (this.subscriptions.containsKey(element)) {
            return;
        }
        ArrayList<ListenerSubscription> elementSubscriptions = new ArrayList<ListenerSubscription>();
        for (ObservableValue<?> observable : this.observableValueExtractor.observableValues(element)) {
            elementSubscriptions.add(this.createChangeListener(element, observable));
        }
        this.subscriptions.put(element, elementSubscriptions);
    }

    @Nonnull
    private ListenerSubscription createChangeListener(@Nonnull E element, @Nonnull ObservableValue<?> observable) {
        ChangeListener listener = (value, oldValue, newValue) -> this.fireChange(this.changeFor(element));
        observable.addListener(listener);
        return () -> observable.removeListener(listener);
    }

    @Nonnull
    private ListChangeListener.Change<? extends E> changeFor(@Nonnull E element) {
        final int position = this.indexOf(element);
        final int[] permutations = new int[]{};
        return new ListChangeListener.Change<E>(this){
            private boolean invalid;
            {
                super(x0);
                this.invalid = true;
            }

            public boolean next() {
                if (this.invalid) {
                    this.invalid = false;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.invalid = true;
            }

            public int getFrom() {
                return position;
            }

            public int getTo() {
                return position + 1;
            }

            public List<E> getRemoved() {
                return Collections.emptyList();
            }

            protected int[] getPermutation() {
                return permutations;
            }

            public boolean wasUpdated() {
                return true;
            }
        };
    }

    private void unregisterListeners(@Nonnull E element) {
        List<ListenerSubscription> registeredSubscriptions = this.subscriptions.remove(element);
        if (registeredSubscriptions != null) {
            registeredSubscriptions.forEach(ListenerSubscription::unsubscribe);
        }
    }

    private static class DefaultObservableValueExtractor<T>
    implements ObservableValueExtractor<T> {
        private final Map<Class<?>, List<Method>> observableValueMetadata = new LinkedHashMap();

        private DefaultObservableValueExtractor() {
        }

        @Override
        @Nonnull
        public ObservableValue<?>[] observableValues(@Nullable T instance) {
            if (instance == null) {
                return new ObservableValue[0];
            }
            if (instance instanceof ObservableValueContainer) {
                return ((ObservableValueContainer)instance).observableValues();
            }
            List metadata = this.observableValueMetadata.computeIfAbsent(instance.getClass(), this::harvestMetadata);
            ObservableValue[] observableValues = new ObservableValue[metadata.size()];
            for (int i = 0; i < observableValues.length; ++i) {
                try {
                    observableValues[i] = (ObservableValue)((Method)metadata.get(i)).invoke(instance, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getTargetException());
                }
            }
            return observableValues;
        }

        private List<Method> harvestMetadata(@Nonnull Class<?> klass) {
            ArrayList<Method> metadata = new ArrayList<Method>();
            for (Method method : klass.getMethods()) {
                if (!ObservableValue.class.isAssignableFrom(method.getReturnType()) || method.getParameterCount() != 0) continue;
                metadata.add(method);
            }
            return metadata;
        }
    }

    private static interface ListenerSubscription {
        public void unsubscribe();
    }

    public static interface ObservableValueExtractor<E> {
        @Nonnull
        public ObservableValue<?>[] observableValues(@Nullable E var1);
    }

    public static interface ObservableValueContainer {
        @Nonnull
        public ObservableValue<?>[] observableValues();
    }
}

