/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import griffon.javafx.collections.ObservableSetBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.WeakSetChangeListener;
import javax.annotation.Nonnull;

public abstract class DelegatingObservableSet<E>
extends ObservableSetBase<E>
implements ObservableSet<E> {
    private final ObservableSet<E> delegate;
    private SetChangeListener<E> sourceListener;

    public DelegatingObservableSet(@Nonnull ObservableSet<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
        this.delegate.addListener((SetChangeListener)new WeakSetChangeListener(this.getListener()));
    }

    @Nonnull
    protected ObservableSet<E> getDelegate() {
        return this.delegate;
    }

    private SetChangeListener<E> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = this::sourceChanged;
        }
        return this.sourceListener;
    }

    protected abstract void sourceChanged(@Nonnull SetChangeListener.Change<? extends E> var1);

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getDelegate().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getDelegate().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray((Object[])a);
    }

    @Override
    public boolean add(E e) {
        return this.getDelegate().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.getDelegate().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.getDelegate().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getDelegate().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getDelegate().removeAll(c);
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

