/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import griffon.javafx.collections.ObservableMapBase;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.WeakMapChangeListener;
import javax.annotation.Nonnull;

public abstract class DelegatingObservableMap<K, V>
extends ObservableMapBase<K, V>
implements ObservableMap<K, V> {
    private final ObservableMap<K, V> delegate;
    private MapChangeListener<K, V> sourceListener;

    public DelegatingObservableMap(@Nonnull ObservableMap<K, V> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
        this.delegate.addListener((MapChangeListener)new WeakMapChangeListener(this.getListener()));
    }

    @Nonnull
    protected ObservableMap<K, V> getDelegate() {
        return this.delegate;
    }

    private MapChangeListener<K, V> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = this::sourceChanged;
        }
        return this.sourceListener;
    }

    protected abstract void sourceChanged(@Nonnull MapChangeListener.Change<? extends K, ? extends V> var1);

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public V get(Object key) {
        return (V)this.getDelegate().get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.getDelegate().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.getDelegate().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.getDelegate().putAll(m);
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getDelegate().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getDelegate().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getDelegate().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }
}

