/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.collections.WeakListChangeListener;
import javax.annotation.Nonnull;

public abstract class DelegatingObservableList<E>
extends ObservableListBase<E>
implements ObservableList<E> {
    private final ObservableList<E> delegate;
    private ListChangeListener<E> sourceListener;

    public DelegatingObservableList(@Nonnull ObservableList<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Argument 'delegate' must not be null");
        this.delegate.addListener((ListChangeListener)new WeakListChangeListener(this.getListener()));
    }

    @Nonnull
    protected ObservableList<E> getDelegate() {
        return this.delegate;
    }

    private ListChangeListener<E> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = this::sourceChanged;
        }
        return this.sourceListener;
    }

    protected abstract void sourceChanged(@Nonnull ListChangeListener.Change<? extends E> var1);

    public boolean removeAll(E ... elements) {
        return this.getDelegate().removeAll((Object[])elements);
    }

    public void remove(int from, int to) {
        this.getDelegate().remove(from, to);
    }

    public E remove(int index) {
        return (E)this.getDelegate().remove(index);
    }

    public int size() {
        return this.getDelegate().size();
    }

    public int lastIndexOf(Object o) {
        return this.getDelegate().lastIndexOf(o);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean addAll(E ... elements) {
        return this.getDelegate().addAll((Object[])elements);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    public E set(int index, E element) {
        return (E)this.getDelegate().set(index, element);
    }

    public void add(int index, E element) {
        this.getDelegate().add(index, element);
    }

    public boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(c);
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public Iterator<E> iterator() {
        return this.getDelegate().iterator();
    }

    public boolean removeAll(Collection<?> c) {
        return this.getDelegate().removeAll(c);
    }

    public <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray((Object[])a);
    }

    public boolean remove(Object o) {
        return this.getDelegate().remove(o);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.getDelegate().addAll(c);
    }

    public boolean retainAll(E ... elements) {
        return this.getDelegate().retainAll((Object[])elements);
    }

    public boolean retainAll(Collection<?> c) {
        return this.getDelegate().retainAll(c);
    }

    public boolean contains(Object o) {
        return this.getDelegate().contains(o);
    }

    public boolean setAll(Collection<? extends E> col) {
        return this.getDelegate().setAll(col);
    }

    public ListIterator<E> listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    public boolean add(E e) {
        return this.getDelegate().add(e);
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        return this.getDelegate().addAll(index, c);
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public ListIterator<E> listIterator() {
        return this.getDelegate().listIterator();
    }

    public E get(int index) {
        return (E)this.getDelegate().get(index);
    }

    public boolean setAll(E ... elements) {
        return this.getDelegate().setAll((Object[])elements);
    }

    public int indexOf(Object o) {
        return this.getDelegate().indexOf(o);
    }
}

