/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.collections;

import griffon.javafx.collections.ObservableStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractObservableStream<T>
implements ObservableStream<T> {
    protected static final String ERROR_PREDICATE_NULL = "Argument 'predicate' must not be null";
    protected static final String ERROR_MAPPER_NULL = "Argument 'mapper' must not be null";
    protected static final String ERROR_COMPARATOR_NULL = "Argument 'comparator' must not be null";
    protected static final String ERROR_OBSERVABLE_NULL = "Argument 'observable' must not be null";
    protected static final String ERROR_ACCUMULATOR = "Argument 'accumulator' must not be null";
    protected static final String ERROR_SUPPLIER_NULL = "Argument 'supplier' must not be null";
    protected static final String ERROR_COMBINER_NULL = "Argument 'combiner' must not be null";
    protected static final String ERROR_IDENTITY_NULL = "Argument 'identity' must not be null";
    protected final Observable observable;
    protected final List<StreamOp> operations = new ArrayList<StreamOp>();

    AbstractObservableStream(@Nonnull Observable observable, @Nonnull List<StreamOp> operations) {
        this.observable = Objects.requireNonNull(observable, ERROR_OBSERVABLE_NULL);
        this.operations.addAll(operations);
    }

    @Nonnull
    protected abstract <E> ObservableStream<E> createInstance(@Nonnull List<StreamOp> var1);

    @Nonnull
    protected abstract Stream createStream();

    @Override
    @Nonnull
    public ObservableStream<T> limit(final long maxSize) {
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.limit(maxSize);
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> limit(final @Nonnull ObservableLongValue maxSize) {
        Objects.requireNonNull(maxSize, ERROR_OBSERVABLE_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOp(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.limit(maxSize.get());
            }

            @Override
            @Nullable
            public Observable dependency() {
                return maxSize;
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> skip(final long n) {
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.skip(n);
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> skip(final @Nonnull ObservableLongValue n) {
        Objects.requireNonNull(n, ERROR_OBSERVABLE_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOp(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.skip(n.get());
            }

            @Override
            @Nullable
            public Observable dependency() {
                return n;
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> distinct() {
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.distinct();
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> sorted() {
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.sorted();
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> sorted(final @Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.sorted(comparator);
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> sorted(final @Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOp(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                Comparator c = (Comparator)comparator.getValue();
                Objects.requireNonNull(c, AbstractObservableStream.ERROR_COMPARATOR_NULL);
                return stream.sorted(c);
            }

            @Override
            @Nullable
            public Observable dependency() {
                return comparator;
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> filter(final @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.filter(predicate);
            }
        }));
    }

    @Override
    @Nonnull
    public <R> ObservableStream<R> map(final @Nonnull Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.map(mapper);
            }
        }));
    }

    @Override
    @Nonnull
    public <R> ObservableStream<R> flatMap(final @Nonnull Function<? super T, ? extends ObservableStream<? extends R>> mapper) {
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOpAdapter(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                return stream.flatMap(mapper);
            }
        }));
    }

    @Override
    @Nonnull
    public ObservableStream<T> filter(final @Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOp(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                Predicate p = (Predicate)predicate.getValue();
                Objects.requireNonNull(p, AbstractObservableStream.ERROR_PREDICATE_NULL);
                return stream.filter(p);
            }

            @Override
            @Nullable
            public Observable dependency() {
                return predicate;
            }
        }));
    }

    @Override
    @Nonnull
    public <R> ObservableStream<R> map(final @Nonnull ObservableValue<Function<? super T, ? extends R>> mapper) {
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOp(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                Function m = (Function)mapper.getValue();
                Objects.requireNonNull(m, AbstractObservableStream.ERROR_MAPPER_NULL);
                return stream.map(m);
            }

            @Override
            @Nullable
            public Observable dependency() {
                return mapper;
            }
        }));
    }

    @Override
    @Nonnull
    public <R> ObservableStream<R> flatMap(final @Nonnull ObservableValue<Function<? super T, ? extends ObservableStream<? extends R>>> mapper) {
        Objects.requireNonNull(mapper, ERROR_MAPPER_NULL);
        return this.createInstance(AbstractObservableStream.push(this.operations, new StreamOp(){

            @Override
            @Nonnull
            public Stream apply(@Nonnull Stream stream) {
                Function m = (Function)mapper.getValue();
                Objects.requireNonNull(m, AbstractObservableStream.ERROR_MAPPER_NULL);
                return stream.flatMap(m);
            }

            @Override
            @Nullable
            public Observable dependency() {
                return mapper;
            }
        }));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> reduce(@Nonnull BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        return Bindings.createObjectBinding(() -> this.stream().reduce(accumulator).orElse(null), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> reduce(@Nullable T defaultValue, @Nonnull BinaryOperator<T> accumulator) {
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        return Bindings.createObjectBinding(() -> this.stream().reduce(accumulator).orElse(defaultValue), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> reduce(@Nonnull Supplier<T> supplier, @Nonnull BinaryOperator<T> accumulator) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        return Bindings.createObjectBinding(() -> this.stream().reduce(accumulator).orElseGet(supplier), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public <U> ObjectBinding<U> reduce(@Nullable U identity, @Nonnull BiFunction<U, ? super T, U> accumulator, @Nonnull BinaryOperator<U> combiner) {
        Objects.requireNonNull(combiner, ERROR_COMBINER_NULL);
        return Bindings.createObjectBinding(() -> this.stream().reduce(identity, accumulator, combiner), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> reduce(@Nonnull ObservableValue<BinaryOperator<T>> accumulator) {
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator a = (BinaryOperator)accumulator.getValue();
            Objects.requireNonNull(a, ERROR_ACCUMULATOR);
            return this.stream().reduce(a).orElse(null);
        }, (Observable[])this.dependencies(new Observable[]{accumulator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> reduce(@Nullable T defaultValue, @Nonnull ObservableValue<BinaryOperator<T>> accumulator) {
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator a = (BinaryOperator)accumulator.getValue();
            Objects.requireNonNull(a, ERROR_ACCUMULATOR);
            return this.stream().reduce(a).orElse(defaultValue);
        }, (Observable[])this.dependencies(new Observable[]{accumulator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> reduce(@Nonnull Supplier<T> supplier, @Nonnull ObservableValue<BinaryOperator<T>> accumulator) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        return Bindings.createObjectBinding(() -> {
            BinaryOperator a = (BinaryOperator)accumulator.getValue();
            Objects.requireNonNull(a, ERROR_ACCUMULATOR);
            return this.stream().reduce(a).orElseGet(supplier);
        }, (Observable[])this.dependencies(new Observable[]{accumulator}));
    }

    @Override
    @Nonnull
    public <U> ObjectBinding<U> reduce(@Nonnull ObservableValue<U> identity, @Nonnull ObservableValue<BiFunction<U, ? super T, U>> accumulator, @Nonnull ObservableValue<BinaryOperator<U>> combiner) {
        Objects.requireNonNull(identity, ERROR_IDENTITY_NULL);
        Objects.requireNonNull(accumulator, ERROR_ACCUMULATOR);
        Objects.requireNonNull(combiner, ERROR_COMBINER_NULL);
        return Bindings.createObjectBinding(() -> {
            Object i = identity.getValue();
            Objects.requireNonNull(i, ERROR_IDENTITY_NULL);
            BiFunction a = (BiFunction)accumulator.getValue();
            Objects.requireNonNull(a, ERROR_ACCUMULATOR);
            BinaryOperator c = (BinaryOperator)combiner.getValue();
            Objects.requireNonNull(c, ERROR_COMBINER_NULL);
            return this.stream().reduce(i, a, c);
        }, (Observable[])this.dependencies(new Observable[]{identity, accumulator, combiner}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> min(@Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> this.stream().min(comparator).orElse(null), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> max(@Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> this.stream().max(comparator).orElse(null), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> min(@Nullable T defaultValue, @Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> this.stream().min(comparator).orElse(defaultValue), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> max(@Nullable T defaultValue, @Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> this.stream().max(comparator).orElse(defaultValue), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> min(@Nonnull Supplier<T> supplier, @Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> this.stream().min(comparator).orElseGet(supplier), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> max(@Nonnull Supplier<T> supplier, @Nonnull Comparator<? super T> comparator) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> this.stream().max(comparator).orElseGet(supplier), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public BooleanBinding anyMatch(@Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> this.stream().anyMatch(predicate), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public BooleanBinding allMatch(@Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> this.stream().allMatch(predicate), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public BooleanBinding noneMatch(@Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> this.stream().noneMatch(predicate), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> min(@Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> {
            Comparator c = (Comparator)comparator.getValue();
            Objects.requireNonNull(c, ERROR_COMPARATOR_NULL);
            return this.stream().min(c).orElse(null);
        }, (Observable[])this.dependencies(new Observable[]{comparator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> max(@Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> {
            Comparator c = (Comparator)comparator.getValue();
            Objects.requireNonNull(c, ERROR_COMPARATOR_NULL);
            return this.stream().max(c).orElse(null);
        }, (Observable[])this.dependencies(new Observable[]{comparator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> min(@Nullable T defaultValue, @Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> {
            Comparator c = (Comparator)comparator.getValue();
            Objects.requireNonNull(c, ERROR_COMPARATOR_NULL);
            return this.stream().min(c).orElse(defaultValue);
        }, (Observable[])this.dependencies(new Observable[]{comparator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> max(@Nullable T defaultValue, @Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        return Bindings.createObjectBinding(() -> {
            Comparator c = (Comparator)comparator.getValue();
            Objects.requireNonNull(c, ERROR_COMPARATOR_NULL);
            return this.stream().max(c).orElse(defaultValue);
        }, (Observable[])this.dependencies(new Observable[]{comparator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> min(@Nonnull Supplier<T> supplier, @Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> {
            Comparator c = (Comparator)comparator.getValue();
            Objects.requireNonNull(c, ERROR_COMPARATOR_NULL);
            return this.stream().min(c).orElseGet(supplier);
        }, (Observable[])this.dependencies(new Observable[]{comparator}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> max(@Nonnull Supplier<T> supplier, @Nonnull ObservableValue<Comparator<? super T>> comparator) {
        Objects.requireNonNull(comparator, ERROR_COMPARATOR_NULL);
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> {
            Comparator c = (Comparator)comparator.getValue();
            Objects.requireNonNull(c, ERROR_COMPARATOR_NULL);
            return this.stream().max(c).orElseGet(supplier);
        }, (Observable[])this.dependencies(new Observable[]{comparator}));
    }

    @Override
    @Nonnull
    public BooleanBinding anyMatch(@Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate p = (Predicate)predicate.getValue();
            Objects.requireNonNull(p, ERROR_PREDICATE_NULL);
            return this.stream().anyMatch(p);
        }, (Observable[])this.dependencies(new Observable[]{predicate}));
    }

    @Override
    @Nonnull
    public BooleanBinding allMatch(@Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate p = (Predicate)predicate.getValue();
            Objects.requireNonNull(p, ERROR_PREDICATE_NULL);
            return this.stream().allMatch(p);
        }, (Observable[])this.dependencies(new Observable[]{predicate}));
    }

    @Override
    @Nonnull
    public BooleanBinding noneMatch(@Nonnull ObservableValue<Predicate<? super T>> predicate) {
        Objects.requireNonNull(predicate, ERROR_PREDICATE_NULL);
        return Bindings.createBooleanBinding(() -> {
            Predicate p = (Predicate)predicate.getValue();
            Objects.requireNonNull(p, ERROR_PREDICATE_NULL);
            return this.stream().noneMatch(p);
        }, (Observable[])this.dependencies(new Observable[]{predicate}));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> findFirst() {
        return Bindings.createObjectBinding(() -> this.stream().findFirst().orElse(null), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> findFirst(@Nullable T defaultValue) {
        return Bindings.createObjectBinding(() -> this.stream().findFirst().orElse(defaultValue), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> findFirst(@Nonnull Supplier<T> supplier) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> this.stream().findFirst().orElseGet(supplier), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> findAny() {
        return Bindings.createObjectBinding(() -> this.stream().findAny().orElse(null), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> findAny(@Nullable T defaultValue) {
        return Bindings.createObjectBinding(() -> this.stream().findAny().orElse(defaultValue), (Observable[])this.dependencies(new Observable[0]));
    }

    @Override
    @Nonnull
    public ObjectBinding<T> findAny(@Nonnull Supplier<T> supplier) {
        Objects.requireNonNull(supplier, ERROR_SUPPLIER_NULL);
        return Bindings.createObjectBinding(() -> this.stream().findAny().orElseGet(supplier), (Observable[])this.dependencies(new Observable[0]));
    }

    @Nonnull
    private Stream stream() {
        Stream stream = this.createStream();
        for (StreamOp op : this.operations) {
            stream = op.apply(stream);
        }
        return stream;
    }

    @Nonnull
    private Observable[] dependencies(Observable ... deps) {
        ArrayList<Observable> dependencies = new ArrayList<Observable>();
        dependencies.add(this.observable);
        if (deps != null) {
            Collections.addAll(dependencies, deps);
        }
        for (StreamOp op : this.operations) {
            Observable dependency = op.dependency();
            if (dependency == null) continue;
            dependencies.add(dependency);
        }
        return dependencies.toArray(new Observable[dependencies.size()]);
    }

    private static List<StreamOp> push(List<StreamOp> operations, StreamOp op) {
        ArrayList<StreamOp> ops = new ArrayList<StreamOp>(operations);
        ops.add(op);
        return ops;
    }

    static class StreamOpAdapter
    implements StreamOp {
        StreamOpAdapter() {
        }

        @Override
        @Nonnull
        public Stream apply(@Nonnull Stream stream) {
            return stream;
        }

        @Override
        @Nullable
        public Observable dependency() {
            return null;
        }
    }

    static interface StreamOp {
        @Nonnull
        public Stream apply(@Nonnull Stream var1);

        @Nullable
        public Observable dependency();
    }
}

