/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.property;

import griffon.javafx.beans.property.ResetableProperty;
import griffon.util.GriffonNameUtils;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractResetableProperty<T>
implements ResetableProperty<T> {
    private static final Object DEFAULT_BEAN = null;
    private static final String DEFAULT_NAME = "";
    private final Object bean;
    private final String name;
    protected final BooleanBinding dirty;

    public AbstractResetableProperty() {
        this(DEFAULT_BEAN, DEFAULT_NAME, null);
    }

    public AbstractResetableProperty(@Nullable T baseValue) {
        this(DEFAULT_BEAN, DEFAULT_NAME, baseValue);
    }

    public AbstractResetableProperty(@Nullable Object bean, @Nonnull String name) {
        this(bean, name, null);
    }

    public AbstractResetableProperty(@Nullable Object bean, @Nonnull String name, @Nullable T baseValue) {
        this.bean = bean;
        this.name = GriffonNameUtils.isBlank((String)name) ? DEFAULT_NAME : name;
        this.writableBaseValueProperty().setValue(baseValue);
        this.setValue(baseValue);
        this.dirty = this.createDirtyBinding();
    }

    @Nonnull
    protected BooleanBinding createDirtyBinding() {
        return Bindings.createBooleanBinding(this::checkValuesAreNotEqual, (Observable[])new Observable[]{this.baseValueProperty(), this.valueProperty()});
    }

    protected boolean checkValuesAreNotEqual() {
        return !Objects.equals(this.getBaseValue(), this.getValue());
    }

    @Nonnull
    protected abstract Property<T> writableBaseValueProperty();

    @Override
    @Nonnull
    public BooleanBinding dirtyProperty() {
        return this.dirty;
    }

    @Override
    @Nullable
    public T getBaseValue() {
        return (T)this.baseValueProperty().getValue();
    }

    @Override
    @Nullable
    public T getValue() {
        return (T)this.valueProperty().getValue();
    }

    @Override
    @Nonnull
    public ResetableProperty<T> setValue(@Nullable T value) {
        this.valueProperty().setValue(value);
        return this;
    }

    @Override
    public boolean isDirty() {
        return this.dirty.get();
    }

    @Override
    @Nonnull
    public ResetableProperty<T> rebase() {
        this.writableBaseValueProperty().setValue(this.getValue());
        return this;
    }

    @Override
    @Nonnull
    public ResetableProperty<T> reset() {
        this.setValue(this.getBaseValue());
        return this;
    }

    @Override
    @Nullable
    public Object getBean() {
        return this.bean;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }
}

