/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.StringPropertyDecorator;
import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javax.annotation.Nonnull;

class UIThreadAwareStringProperty
extends StringPropertyDecorator
implements UIThreadAware {
    UIThreadAwareStringProperty(@Nonnull StringProperty delegate) {
        super(delegate);
    }

    @Override
    public void set(String value) {
        if (Platform.isFxApplicationThread()) {
            this.getDelegate().set((Object)value);
        } else {
            Platform.runLater(() -> this.getDelegate().set((Object)value));
        }
    }

    @Override
    public void addListener(ChangeListener<? super String> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareChangeListener<String>(listener));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super String> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareChangeListener<String>(listener));
        }
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }
}

