/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.SetPropertyDecorator;
import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import griffon.javafx.beans.binding.UIThreadAwareSetChangeListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.SetProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javax.annotation.Nonnull;

class UIThreadAwareSetProperty<E>
extends SetPropertyDecorator<E>
implements UIThreadAware {
    UIThreadAwareSetProperty(@Nonnull SetProperty<E> delegate) {
        super(delegate);
    }

    @Override
    public void set(ObservableSet<E> value) {
        if (Platform.isFxApplicationThread()) {
            this.getDelegate().set(value);
        } else {
            Platform.runLater(() -> this.getDelegate().set((Object)value));
        }
    }

    @Override
    public void addListener(SetChangeListener<? super E> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareSetChangeListener<E>(listener));
        }
    }

    @Override
    public void removeListener(SetChangeListener<? super E> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareSetChangeListener<E>(listener));
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableSet<E>> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareChangeListener<ObservableSet<E>>(listener));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableSet<E>> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareChangeListener<ObservableSet<E>>(listener));
        }
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }
}

