/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.ObjectBindingDecorator;
import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javax.annotation.Nonnull;

class UIThreadAwareObjectBinding<T>
extends ObjectBindingDecorator<T>
implements UIThreadAware {
    UIThreadAwareObjectBinding(@Nonnull ObjectBinding<T> delegate) {
        super(delegate);
    }

    @Override
    public void addListener(ChangeListener<? super T> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareChangeListener<T>(listener));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super T> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareChangeListener<T>(listener));
        }
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }
}

