/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.MapPropertyDecorator;
import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import griffon.javafx.beans.binding.UIThreadAwareMapChangeListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.MapProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javax.annotation.Nonnull;

class UIThreadAwareMapProperty<K, V>
extends MapPropertyDecorator<K, V>
implements UIThreadAware {
    UIThreadAwareMapProperty(@Nonnull MapProperty<K, V> delegate) {
        super(delegate);
    }

    @Override
    public void set(ObservableMap<K, V> value) {
        if (Platform.isFxApplicationThread()) {
            this.getDelegate().set(value);
        } else {
            Platform.runLater(() -> this.getDelegate().set((Object)value));
        }
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareMapChangeListener<K, V>(listener));
        }
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareMapChangeListener<K, V>(listener));
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareChangeListener<ObservableMap<K, V>>(listener));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareChangeListener<ObservableMap<K, V>>(listener));
        }
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }
}

