/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.beans.binding;

import griffon.javafx.beans.binding.ListPropertyDecorator;
import griffon.javafx.beans.binding.UIThreadAware;
import griffon.javafx.beans.binding.UIThreadAwareChangeListener;
import griffon.javafx.beans.binding.UIThreadAwareInvalidationListener;
import griffon.javafx.beans.binding.UIThreadAwareListChangeListener;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ListProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;

class UIThreadAwareListProperty<E>
extends ListPropertyDecorator<E>
implements UIThreadAware {
    UIThreadAwareListProperty(@Nonnull ListProperty<E> delegate) {
        super(delegate);
    }

    @Override
    public void set(ObservableList<E> value) {
        if (Platform.isFxApplicationThread()) {
            this.getDelegate().set(value);
        } else {
            Platform.runLater(() -> this.getDelegate().set((Object)value));
        }
    }

    @Override
    public void addListener(ListChangeListener<? super E> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareListChangeListener<E>(listener));
        }
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareListChangeListener<E>(listener));
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener(new UIThreadAwareChangeListener<ObservableList<E>>(listener));
        }
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener(new UIThreadAwareChangeListener<ObservableList<E>>(listener));
        }
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().addListener(listener);
        } else {
            this.getDelegate().addListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (listener instanceof UIThreadAware) {
            this.getDelegate().removeListener(listener);
        } else {
            this.getDelegate().removeListener((InvalidationListener)new UIThreadAwareInvalidationListener(listener));
        }
    }
}

